/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;
import org.apache.tools.ant.types.FileSet;

public abstract class ComponentAdmin
extends AppServerAdmin {
    LocalStringsManager lsm = new LocalStringsManager();
    protected Component component;
    protected List components = new ArrayList();
    private List filesets = new ArrayList();
    protected static final String TYPE_APP = "application";
    protected static final String TYPE_EJB = "ejb";
    protected static final String TYPE_WEB = "web";
    protected static final String TYPE_CONN = "connector";
    protected static final String TYPE_CLIENT = "client";
    protected static final Map TYPE_MAP = new HashMap(4);

    public ComponentAdmin() {
        this.component = this.getNewComponent();
    }

    protected Component getNewComponent() {
        return new Component(this.component);
    }

    public void setFile(File file) {
        this.component.setFile(file);
    }

    public void setName(String name) {
        this.component.setName(name);
    }

    public void setType(String type) {
        this.component.setType(type);
    }

    public void setTarget(String target) {
        this.component.setTarget(target);
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public Component createComponent() {
        Component newComponent = this.getNewComponent();
        this.components.add(newComponent);
        return newComponent;
    }

    protected void prepareToExecute() throws BuildException {
        super.prepareToExecute();
        this.processFilesets();
        if (this.components.size() == 0) {
            this.components.add(this.component);
        }
    }

    protected void execute(AppServerAdmin.Server aServer) throws BuildException {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Component comp = (Component)iterator.next();
            String cmdString = this.getCommandString(aServer, comp);
            this.execAdminCommand(cmdString);
        }
    }

    private void processFilesets() {
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fileset = (FileSet)this.filesets.get(i);
            DirectoryScanner scanner = fileset.getDirectoryScanner(this.project);
            File baseDir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                Component archive = this.getNewComponent();
                archive.setFile(new File(baseDir, files[j]));
                this.components.add(archive);
            }
            String[] dirs = scanner.getIncludedDirectories();
            for (int j = 0; j < dirs.length; ++j) {
                Component expandedArchive = this.getNewComponent();
                expandedArchive.setFile(new File(baseDir, dirs[j]));
                this.components.add(expandedArchive);
            }
        }
    }

    protected void checkConfiguration() throws BuildException {
        super.checkConfiguration();
        this.log(this.components.size() + " components were found.", 4);
        if (this.components.size() == 0) {
            this.log(this.lsm.getString("NoComponentsSpecified"), 1);
        }
    }

    protected void checkConfiguration(AppServerAdmin.Server aServer) throws BuildException {
        String hostname = aServer.getHost();
        if (hostname == null) {
            hostname = "localhost";
        }
        this.log("Checking server config for " + hostname, 4);
        if (!aServer.hasPassword()) {
            throw new BuildException(this.lsm.getString("PasswordMustBeSpecified", new Object[]{this.getTaskName(), hostname}), this.getLocation());
        }
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Component comp = (Component)iterator.next();
            this.checkComponentConfig(aServer, comp);
        }
    }

    protected void checkComponentConfig(AppServerAdmin.Server aServer, Component comp) {
        this.log("Checking config for server \"" + aServer + "\" and component \"" + comp + "\"", 4);
        File theFile = comp.getFile();
        this.log("The file for this component: " + theFile, 4);
        if (theFile != null && !theFile.exists()) {
            throw new BuildException(this.lsm.getString("FileCouldNotBeFound", new Object[]{theFile}), this.getLocation());
        }
        String theName = comp.getName();
        if (theName == null || theName.length() == 0) {
            throw new BuildException(this.lsm.getString("CouldNotDetermineComponentName"), this.getLocation());
        }
        String theType = comp.getType();
        if (theType != null && !TYPE_MAP.values().contains(theType)) {
            throw new BuildException(this.lsm.getString("TypeNotValid", new Object[]{theType}), this.getLocation());
        }
    }

    protected abstract String getCommandString(AppServerAdmin.Server var1, Component var2);

    static {
        TYPE_MAP.put("ear", TYPE_APP);
        TYPE_MAP.put("jar", TYPE_EJB);
        TYPE_MAP.put("war", TYPE_WEB);
        TYPE_MAP.put("rar", TYPE_CONN);
    }

    public class Component {
        protected Component parent;
        private File file;
        private String name;
        private String type;
        private String target;
        private static final String DEFAULT_TYPE = "application";

        public Component() {
            this(null);
        }

        public Component(Component parent) {
            this.parent = parent;
        }

        public void setParent(Component parent) {
            this.parent = parent;
        }

        public void setFile(File file) {
            this.file = file;
        }

        protected File getFile() {
            return this.file;
        }

        public void setName(String name) {
            this.name = name;
        }

        protected String getName() {
            if (this.name == null) {
                String fileName = null;
                if (this.file == null) {
                    return null;
                }
                fileName = this.file.getName();
                int index = fileName.indexOf(46);
                this.name = index < 0 ? fileName : fileName.substring(0, index);
            }
            return this.name;
        }

        public void setType(String type) {
            this.type = type;
        }

        protected String getType() {
            if (this.type == null) {
                return null;
            }
            return this.type;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        protected String getTarget() {
            if (this.target == null) {
                return null;
            }
            return this.target;
        }

        public String toString() {
            return this.getName();
        }
    }
}

