/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public class TreeHandlers {
    public static final String VALUE = "value";
    public static final String OBJECT_NAME = "objectName";

    public void refreshTreeNode(RequestContext ctx, HandlerContext handlerCtx) {
        ctx.getRequest().setAttribute("refreshTree", (Object)new Boolean("true"));
        Util.getSelectedNode().setRefresh(true);
    }

    public void refreshTreeNodeById(RequestContext ctx, HandlerContext handlerCtx) {
        ctx.getRequest().setAttribute("refreshTree", (Object)new Boolean("true"));
        String nodeId = (String)handlerCtx.getInputValue("nodeId");
        IndexTreeNode node = Util.getCurrentTreeModel().getNodeByUniqueID(nodeId, null, null);
        if (node != null) {
            node.setRefresh(true);
        }
    }

    public void refreshParentNode(RequestContext ctx, HandlerContext handlerCtx) {
        ctx.getRequest().setAttribute("refreshTree", (Object)new Boolean("true"));
        Util.getSelectedNode().getParent().setRefresh(true);
    }

    public void openTreeNode(RequestContext ctx, HandlerContext handlerCtx) {
        Util.getSelectedNode().openNode(ctx);
    }

    public void getNumberOfChildNodes(RequestContext ctx, HandlerContext handlerCtx) {
        int count = Util.getSelectedNode().getChildren().size();
        handlerCtx.setOutputValue("count", (Object)new Integer(count));
    }

    public void getAttributeFromTree(RequestContext ctx, HandlerContext handlerCtx) {
        HttpServletRequest req = ctx.getRequest();
        String attrName = (String)handlerCtx.getInputValue("attrName");
        boolean lookInHierarchy = true;
        Boolean look = (Boolean)handlerCtx.getInputValue("lookInHierarchy");
        if (look != null) {
            lookInHierarchy = look;
        }
        Object attrValue = Util.getSelectedNode().getAttribute(attrName, lookInHierarchy);
        handlerCtx.setOutputValue(VALUE, attrValue);
    }

    public void changeTreeModel(RequestContext ctx, HandlerContext handlerCtx) {
        Util.setCurrentTreeModelType(ctx, (String)handlerCtx.getInputValue("modelName"));
        ctx.getRequest().setAttribute("refreshRightSide", (Object)new Boolean("true"));
    }

    public void getTreeModelType(RequestContext ctx, HandlerContext handlerCtx) {
        handlerCtx.setOutputValue(VALUE, (Object)Util.getCurrentTreeModelType(ctx));
    }

    public void moveSelectedNode(RequestContext ctx, HandlerContext handlerCtx) {
        String childName = (String)handlerCtx.getInputValue("editKeyValue");
        if (childName == null) {
            throw new FrameworkException("\"editKeyValue\" not defined!", null, handlerCtx.getView());
        }
        IndexTreeNode selectedNode = Util.getSelectedNode();
        IndexTreeNode childNode = selectedNode.getChild(childName);
        if (childNode == null) {
            if (Util.isLoggableFINE()) {
                Util.logFINE("Child node (" + childName + ") not found!");
            }
            handlerCtx.setOutputValue(OBJECT_NAME, null);
            return;
        }
        Util.setSelectedNode(childNode);
        handlerCtx.setOutputValue(OBJECT_NAME, childNode.getAttribute(OBJECT_NAME, false));
    }

    public void warpToNode(RequestContext ctx, HandlerContext handlerCtx) {
        IndexTreeNode node;
        ArrayList parentIDs = (ArrayList)handlerCtx.getInputValue("parentID");
        if (parentIDs == null) {
            throw new FrameworkException("warpToNode: \"parentID\" not defined!", null, handlerCtx.getView());
        }
        String childName = (String)handlerCtx.getInputValue("childName");
        IndexTreeNode childNode = null;
        for (int i = 0; i < parentIDs.size(); ++i) {
            String parentID = (String)parentIDs.get(i);
            childNode = Util.getCurrentTreeModel().getNodeByUniqueID(parentID, childName, null);
            if (childNode != null) break;
        }
        if (childNode == null) {
            return;
        }
        String grandChildId = (String)handlerCtx.getInputValue("grandChildId");
        if (grandChildId != null && (node = Util.getCurrentTreeModel().getNodeByUniqueID(grandChildId, null, childNode)) != null) {
            childNode = node;
        }
        IndexTreeNode parentNode = childNode.getParent();
        parentNode.setRefresh(true);
        parentNode.openNode(ctx);
        Util.setSelectedNode(childNode);
        handlerCtx.setOutputValue(OBJECT_NAME, childNode.getAttribute(OBJECT_NAME, false));
    }

    public void moveSelectedNodeToParent(RequestContext ctx, HandlerContext handlerCtx) {
        IndexTreeNode selectedNode = Util.getSelectedNode();
        IndexTreeNode parent = selectedNode.getParent();
        Util.setSelectedNode(parent);
        if (parent != null) {
            handlerCtx.setOutputValue(OBJECT_NAME, parent.getAttribute(OBJECT_NAME, false));
        } else {
            handlerCtx.setOutputValue(OBJECT_NAME, null);
        }
    }

    public void initializeCurrentNode(RequestContext ctx, HandlerContext handlerCtx) {
        IndexTreeModel model = Util.getCurrentTreeModel();
        IndexTreeNode root = model.getRoot();
        if (root != null) {
            model.setCurrentNode(root);
            Util.setSelectedNode(root);
        }
    }

    public void syncTreeView(RequestContext ctx, HandlerContext handlerCtx) {
        Object[] keys = (Object[])handlerCtx.getInputValue("keys");
        if (keys == null) {
            return;
        }
        IndexTreeNode node = Util.getSelectedNode();
        if (node == null) {
            return;
        }
        if (node.getChildren().size() != keys.length) {
            ctx.getRequest().setAttribute("refreshTree", (Object)new Boolean("true"));
            node.setRefresh(true);
        }
    }
}

