/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.logging;

import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public abstract class AbstractLogger
implements Logger {
    private static final ResourceBundle _messages = I18NHelper.loadBundle(AbstractLogger.class);
    private static final int _defaultLevel = 800;
    private static final char _levelSeparator = '.';
    private static Map _levelNamesToValues;
    private static boolean _hasLoggingProperties;
    private static Properties _loggingProperties;
    private final ResourceBundle _bundle;
    private final String _loggerName;
    private final int _level;

    public AbstractLogger(String loggerName, String bundleName, ClassLoader loader) {
        this._loggerName = loggerName;
        this._level = this.readLoggingLevel(loggerName);
        this._bundle = I18NHelper.loadBundle(bundleName, loader);
    }

    protected static ResourceBundle getMessages() {
        return _messages;
    }

    private static Map getLevelNameMap() {
        return _levelNamesToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized Properties getLoggingProperties() {
        if (!_hasLoggingProperties || _loggingProperties != null) return _loggingProperties;
        String fileName = System.getProperty("java.util.logging.config.file");
        if (fileName == null && (fileName = System.getProperty("java.home")) != null) {
            File file = new File(fileName, "lib");
            file = new File(file, "logging.properties");
            try {
                fileName = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                fileName = null;
            }
        }
        if (fileName != null) {
            InputStream inputStream = null;
            Object file = null;
            Properties properties = new Properties();
            BufferedInputStream bufferedInputStream = null;
            inputStream = new FileInputStream(fileName);
            bufferedInputStream = new BufferedInputStream(inputStream);
            properties.load(bufferedInputStream);
            _loggingProperties = properties;
            Object var6_7 = null;
            if (inputStream == null) return _loggingProperties;
            try {
                inputStream.close();
                return _loggingProperties;
            }
            catch (IOException ioe) {}
            return _loggingProperties;
            {
                catch (Exception e) {
                    _hasLoggingProperties = false;
                    Object var6_8 = null;
                    if (inputStream == null) return _loggingProperties;
                    try {
                        inputStream.close();
                        return _loggingProperties;
                    }
                    catch (IOException ioe) {}
                    return _loggingProperties;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        _hasLoggingProperties = false;
        return _loggingProperties;
    }

    public static String toString(int level) {
        String bundleKey = null;
        switch (level) {
            case 0x7FFFFFFF: {
                bundleKey = "utility.level_off";
                break;
            }
            case 1000: {
                bundleKey = "utility.level_severe";
                break;
            }
            case 900: {
                bundleKey = "utility.level_warning";
                break;
            }
            case 800: {
                bundleKey = "utility.level_info";
                break;
            }
            case 700: {
                bundleKey = "utility.level_config";
                break;
            }
            case 500: {
                bundleKey = "utility.level_fine";
                break;
            }
            case 400: {
                bundleKey = "utility.level_finer";
                break;
            }
            case 300: {
                bundleKey = "utility.level_finest";
                break;
            }
            case -2147483648: {
                bundleKey = "utility.level_all";
            }
        }
        return bundleKey != null ? I18NHelper.getMessage(AbstractLogger.getMessages(), bundleKey) : null;
    }

    protected ResourceBundle getBundle() {
        return this._bundle;
    }

    public int getLevel() {
        return this._level;
    }

    private int readLoggingLevel(String loggerName) {
        String value = this.findLevelMatch(loggerName);
        int level = 800;
        if (value != null) {
            Object lookupValue = null;
            value = value.trim();
            lookupValue = AbstractLogger.getLevelNameMap().get(value);
            if (lookupValue != null) {
                level = lookupValue;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return level;
    }

    private String findLevelMatch(String loggerName) {
        Properties properties = AbstractLogger.getLoggingProperties();
        String value = null;
        if (properties != null) {
            while (value == null) {
                int lastIndex = loggerName.lastIndexOf(46);
                value = properties.getProperty(loggerName + ".level");
                if (loggerName.trim().length() > 0) {
                    loggerName = lastIndex == -1 ? "" : loggerName.substring(0, lastIndex);
                    continue;
                }
                return value;
            }
        }
        return value;
    }

    public boolean isLoggable() {
        return 500 >= this.getLevel();
    }

    public boolean isLoggable(int levelValue) {
        return levelValue >= this.getLevel();
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.entering(sourceClass, sourceMethod, null);
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (this.isLoggable(400)) {
            this.entering(sourceClass, sourceMethod, new Object[]{param1});
        }
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (this.isLoggable(400)) {
            MessageFormat messageFormat = null;
            String messageKey = null;
            String[] args = null;
            if (params != null && params.length > 0) {
                messageKey = "entering_method_params";
                args = new String[]{sourceClass, sourceMethod, StringHelper.arrayToSeparatedList(Arrays.asList(params))};
            } else {
                messageKey = "entering_method";
                args = new String[]{sourceClass, sourceMethod};
            }
            messageFormat = new MessageFormat(AbstractLogger.getMessages().getString(messageKey));
            this.finer(messageFormat.format(args));
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.exiting(sourceClass, sourceMethod, null);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (this.isLoggable(400)) {
            MessageFormat messageFormat = null;
            String messageKey = null;
            Object[] args = null;
            if (result != null) {
                messageKey = "exiting_method_return";
                args = new Object[]{sourceClass, sourceMethod, result};
            } else {
                messageKey = "exiting_method";
                args = new Object[]{sourceClass, sourceMethod};
            }
            messageFormat = new MessageFormat(AbstractLogger.getMessages().getString(messageKey));
            this.finer(messageFormat.format(args));
        }
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.isLoggable(400)) {
            MessageFormat messageFormat = new MessageFormat(AbstractLogger.getMessages().getString("throwing_method"));
            this.log(400, messageFormat.format(new String[]{sourceClass, sourceMethod}), thrown);
        }
    }

    public void severe(String msg) {
        this.log(1000, msg);
    }

    public void warning(String msg) {
        this.log(900, msg);
    }

    public void info(String msg) {
        this.log(800, msg);
    }

    public void config(String msg) {
        this.log(700, msg);
    }

    public void log(int level, String msg) {
        if (this.isLoggable(level)) {
            this.logInternal(level, this.getMessage(msg));
        }
    }

    public void log(int level, String msg, Object o1) {
        if (this.isLoggable(level)) {
            this.log(level, msg, new Object[]{o1});
        }
    }

    public void log(int level, String msg, Object[] o) {
        if (this.isLoggable(level)) {
            int count = o == null ? 0 : o.length;
            String formattedMessage = msg;
            if (count > 0) {
                MessageFormat messageFormat = new MessageFormat(this.getBundle().getString(msg));
                if (messageFormat != null) {
                    formattedMessage = messageFormat.format(o);
                }
            } else {
                formattedMessage = this.getMessage(msg);
            }
            this.logInternal(level, formattedMessage);
        }
    }

    public void log(int level, String msg, Object o1, Object o2) {
        if (this.isLoggable(level)) {
            this.log(level, msg, new Object[]{o1, o2});
        }
    }

    public void log(int level, String msg, Object o1, Object o2, Object o3) {
        if (this.isLoggable(level)) {
            this.log(level, msg, new Object[]{o1, o2, o3});
        }
    }

    public abstract void log(int var1, String var2, Throwable var3);

    public void fine(String msg) {
        this.log(500, msg);
    }

    public void fine(String msg, Object o1) {
        this.log(500, msg, o1);
    }

    public void fine(String msg, Object[] o) {
        this.log(500, msg, o);
    }

    public void fine(String msg, Object o1, Object o2) {
        this.log(500, msg, o1, o2);
    }

    public void fine(String msg, Object o1, Object o2, Object o3) {
        this.log(500, msg, o1, o2, o3);
    }

    public void finer(String msg) {
        this.log(400, msg);
    }

    public void finer(String msg, Object[] o) {
        this.log(400, msg, o);
    }

    public void finer(String msg, Object o1) {
        this.log(400, msg, o1);
    }

    public void finer(String msg, Object o1, Object o2) {
        this.log(400, msg, o1, o2);
    }

    public void finer(String msg, Object o1, Object o2, Object o3) {
        this.log(400, msg, o1, o2, o3);
    }

    public void finest(String msg) {
        this.log(300, msg);
    }

    public void finest(String msg, Object[] o) {
        this.log(300, msg, o);
    }

    public void finest(String msg, Object o1) {
        this.log(300, msg, o1);
    }

    public void finest(String msg, Object o1, Object o2) {
        this.log(300, msg, o1, o2);
    }

    public void finest(String msg, Object o1, Object o2, Object o3) {
        this.log(300, msg, o1, o2, o3);
    }

    public String getName() {
        return this._loggerName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": ");
        buffer.append(" name: ");
        buffer.append(this.getName());
        buffer.append(", logging level: ");
        buffer.append(AbstractLogger.toString(this.getLevel()));
        return buffer.toString();
    }

    protected String getMessage(String message) {
        try {
            return this.getBundle().getString(message);
        }
        catch (MissingResourceException e) {
            return message;
        }
    }

    protected String getMessageWithPrefix(int level, String message) {
        MessageFormat messageFormat = new MessageFormat(AbstractLogger.getMessages().getString("logging_prefix"));
        return messageFormat.format(new String[]{AbstractLogger.toString(level), message});
    }

    protected abstract void logInternal(int var1, String var2);

    static {
        _hasLoggingProperties = true;
        _levelNamesToValues = new HashMap();
        _levelNamesToValues.put("ALL", new Integer(Integer.MIN_VALUE));
        _levelNamesToValues.put("FINEST", new Integer(300));
        _levelNamesToValues.put("FINER", new Integer(400));
        _levelNamesToValues.put("FINE", new Integer(500));
        _levelNamesToValues.put("CONFIG", new Integer(700));
        _levelNamesToValues.put("INFO", new Integer(800));
        _levelNamesToValues.put("WARNING", new Integer(900));
        _levelNamesToValues.put("SEVERE", new Integer(1000));
        _levelNamesToValues.put("OFF", new Integer(Integer.MAX_VALUE));
    }
}

