/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.api.persistence.support.JDOFatalDataStoreException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.TableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintField;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintJoin;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.DBStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputParamValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.SelectQueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SelectStatement
extends Statement {
    private boolean isJoined;
    private StringBuffer orderClause = new StringBuffer();
    SelectQueryPlan plan;

    public SelectStatement(DBVendorType vendorType, SelectQueryPlan plan) {
        super(vendorType);
        this.plan = plan;
        this.constraint = plan.getConstraint();
    }

    public boolean isJoined() {
        return this.isJoined;
    }

    public void markJoined() {
        this.isJoined = true;
    }

    public ColumnRef addColumn(ColumnElement columnElement, QueryTable queryTable) {
        ColumnRef columnRef = null;
        columnRef = this.getColumnRef(columnElement);
        if (columnRef == null) {
            columnRef = new ColumnRef(columnElement, queryTable);
            this.addColumnRef(columnRef);
        }
        return columnRef;
    }

    public void copyColumns(SelectStatement sourceStatement) {
        ArrayList columnRefs = sourceStatement.getColumnRefs();
        int index = this.columns.size() + 1;
        for (int i = 0; i < columnRefs.size(); ++i) {
            ColumnRef cref = (ColumnRef)columnRefs.get(i);
            cref.setIndex(index + i);
            this.columns.add(cref);
        }
    }

    protected boolean isUpdateLockRequired(QueryTable table) {
        return (this.plan.options & 0x1F8) == 0 && table.getTableDesc().isUpdateLockRequired();
    }

    public void appendTableText(StringBuffer text, QueryTable table) {
        super.appendTableText(text, table);
        if (this.isUpdateLockRequired(table)) {
            text.append(this.vendorType.getHoldlock());
        }
    }

    public boolean isColumnTypeDefinitionNeeded() {
        return (this.plan.options & 0x100) == 0;
    }

    public QueryPlan getQueryPlan() {
        return this.plan;
    }

    protected void generateStatementText() {
        StringBuffer constraints = this.processConstraints();
        StringBuffer outerJoinText = this.processOuterJoinConstraints();
        if (outerJoinText != null && outerJoinText.length() > 0) {
            if (constraints.length() > 0) {
                constraints.append(" and ");
            }
            constraints.append(outerJoinText);
        }
        StringBuffer whereClause = new StringBuffer();
        if (constraints.length() > 0) {
            whereClause.append(" where ").append(constraints);
        }
        if ((this.plan.options & 0x100) == 0) {
            this.generateRegularStatementText(whereClause);
        } else {
            this.generateCountStatementText(whereClause);
        }
    }

    private void generateRegularStatementText(StringBuffer whereClause) {
        String aggregateEnd;
        this.statementText = new StringBuffer();
        StringBuffer columnText = this.generateColumnText();
        String tableListText = this.generateTableListText();
        String aggregateText = this.getAggregateText();
        String string = aggregateEnd = aggregateText.length() > 0 ? ")" : "";
        if (this.orderClause.length() > 0) {
            this.orderClause.insert(0, " order by ");
        }
        boolean updateLockRequired = this.isUpdateLockRequired();
        StringBuffer forUpdateClause = this.generateForUpdateClause(updateLockRequired);
        String distinctText = this.getDistinctText(updateLockRequired);
        this.statementText.append("select ").append(aggregateText).append(distinctText).append(columnText).append(aggregateEnd).append(" from ").append(tableListText).append(whereClause).append(this.orderClause).append(forUpdateClause);
    }

    private void generateCountStatementText(StringBuffer whereClause) {
        int selectedColumns = this.columns.size();
        if (selectedColumns == 1) {
            this.generateRegularStatementText(whereClause);
        } else {
            boolean oneTable;
            boolean bl = oneTable = this.tableList.size() == 1;
            if ((this.plan.options & 2) == 0 || oneTable) {
                int i = selectedColumns;
                while (i > 1) {
                    this.columns.remove(--i);
                }
                if (oneTable) {
                    this.plan.options &= 0xFFFFFFFD;
                }
                this.generateRegularStatementText(whereClause);
            } else {
                this.generateCorrelatedExistsText(whereClause);
                this.columns.clear();
            }
        }
    }

    private void generateCorrelatedExistsText(StringBuffer whereClause) {
        this.statementText = new StringBuffer();
        boolean updateLockRequired = this.isUpdateLockRequired();
        StringBuffer forUpdateClause = this.generateForUpdateClause(updateLockRequired);
        StringBuffer primaryTableText = new StringBuffer();
        QueryTable primaryTable = this.generatePrimaryTableText(primaryTableText);
        this.tableList.remove(primaryTable);
        String tableListText = this.generateTableListText();
        this.statementText.append("select count(*) from ").append(primaryTableText).append(" where exists (select * from ").append(tableListText).append(whereClause).append(")").append(forUpdateClause);
    }

    private QueryTable generatePrimaryTableText(StringBuffer primaryTableText) {
        QueryTable primaryTable = ((ColumnRef)this.columns.get(0)).getQueryTable();
        this.appendTableText(primaryTableText, primaryTable);
        return primaryTable;
    }

    protected StringBuffer generateColumnText() {
        StringBuffer columnText = new StringBuffer();
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnRef cr = (ColumnRef)this.columns.get(i);
            columnText.append("t").append(cr.getQueryTable().getTableIndex()).append(".").append(this.quoteCharStart).append(cr.getName()).append(this.quoteCharEnd).append(", ");
        }
        columnText.delete(columnText.length() - 2, columnText.length());
        return columnText;
    }

    private String getAggregateText() {
        int aggregateOption = this.plan.options & 0x1F8;
        switch (aggregateOption) {
            case 8: {
                return "AVG( ";
            }
            case 16: {
                return "MIN(";
            }
            case 32: {
                return "MAX(";
            }
            case 64: {
                return "SUM(";
            }
            case 128: 
            case 256: {
                return "COUNT(";
            }
        }
        return "";
    }

    private StringBuffer generateForUpdateClause(boolean updateLockRequired) {
        StringBuffer forUpdateClause = new StringBuffer();
        if (updateLockRequired) {
            boolean vendorHasForUpdateClause;
            if (!this.vendorType.isUpdateLockSupported()) {
                throw new JDOFatalDataStoreException(I18NHelper.getMessage(messages, "sqlstore.selectstatement.noupdatelocksupport"));
            }
            String vendorForUpdate = this.vendorType.getForUpdate().trim();
            boolean bl = vendorHasForUpdateClause = vendorForUpdate.length() != 0;
            if (vendorHasForUpdateClause) {
                forUpdateClause.append(" ").append(vendorForUpdate).append(" ");
                if (this.vendorType.isLockColumnListSupported()) {
                    for (int i = 0; i < this.tableList.size(); ++i) {
                        QueryTable queryTable = (QueryTable)this.tableList.get(i);
                        if (!this.isUpdateLockRequired(queryTable)) continue;
                        TableDesc tableDesc = queryTable.getTableDesc();
                        ColumnElement ce = (ColumnElement)tableDesc.getKey().getColumns().get(0);
                        forUpdateClause.append("t").append(i).append(".").append(this.quoteCharStart).append(ce.getName().getName()).append(this.quoteCharEnd).append(", ");
                    }
                    forUpdateClause.delete(forUpdateClause.length() - 2, forUpdateClause.length());
                }
            }
        }
        return forUpdateClause;
    }

    private String getDistinctText(boolean updateLockRequired) {
        String distinctText = "";
        if ((this.plan.options & 2) > 0 && (!updateLockRequired || this.vendorType.isDistinctSupportedWithUpdateLock())) {
            distinctText = "distinct ";
        }
        return distinctText;
    }

    private boolean isUpdateLockRequired() {
        boolean updateLockRequired = false;
        for (int i = 0; i < this.tableList.size() && !updateLockRequired; ++i) {
            QueryTable queryTable = (QueryTable)this.tableList.get(i);
            updateLockRequired = this.isUpdateLockRequired(queryTable);
        }
        return updateLockRequired;
    }

    protected void processRootConstraint(ConstraintOperation opNode, List stack, StringBuffer whereText) {
        int op = opNode.operation;
        int opInfo = this.operationFormat(op);
        if ((opInfo & 0x10) > 0) {
            stack.remove(stack.size() - 1);
            ConstraintNode node = (ConstraintNode)stack.get(stack.size() - 1);
            if (!(node instanceof ConstraintField)) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.needfieldnode"));
            }
            this.processOrderByField((ConstraintFieldDesc)node, op);
            stack.remove(stack.size() - 1);
        } else {
            super.processRootConstraint(opNode, stack, whereText);
        }
    }

    protected void processIrregularOperation(ConstraintOperation opNode, int opCode, List stack, StringBuffer result) {
        switch (opCode) {
            case 10: {
                this.processJoinOperation((ConstraintJoin)opNode, result);
                break;
            }
            default: {
                super.processIrregularOperation(opNode, opCode, stack, result);
            }
        }
    }

    private StringBuffer processOuterJoinConstraints() {
        StringBuffer joinCondition = null;
        List joinStack = this.constraint.getOuterJoinConstraints();
        int joinStackSize = joinStack.size();
        if (joinStackSize > 0) {
            joinCondition = new StringBuffer();
            for (int i = 0; i < joinStackSize; ++i) {
                ConstraintJoin joinNode = (ConstraintJoin)joinStack.get(i);
                this.processJoinOperation(joinNode, joinCondition);
            }
        }
        return joinCondition;
    }

    private void processJoinOperation(ConstraintJoin jnode, StringBuffer whereText) {
        boolean doAnsiJoin;
        int opCode = jnode.operation;
        boolean bl = doAnsiJoin = opCode != 10 && !this.vendorType.isNativeOuterJoin();
        if (doAnsiJoin) {
            this.generateAnsiJoin(jnode, opCode);
        } else {
            this.generateJoin(jnode, whereText, opCode);
        }
    }

    private void generateJoin(ConstraintJoin jnode, StringBuffer whereText, int opCode) {
        for (int i = 0; i < jnode.fromColumns.size(); ++i) {
            ColumnElement fromColumn = (ColumnElement)jnode.fromColumns.get(i);
            ColumnElement toColumn = (ColumnElement)jnode.toColumns.get(i);
            QueryTable fromTable = SelectStatement.findQueryTable(jnode.fromPlan, fromColumn);
            QueryTable toTable = SelectStatement.findQueryTable(jnode.toPlan, toColumn);
            this.addQueryTable(fromTable);
            this.addQueryTable(toTable);
            toTable.prevTable = null;
            this.appendJoinCondition(whereText, fromTable, toTable, fromColumn, toColumn, this.getJoinOperator(opCode));
            if (opCode != 16) continue;
            whereText.append(this.vendorType.getLeftJoinPost());
        }
    }

    private void generateAnsiJoin(ConstraintJoin jnode, int opCode) {
        for (int i = 0; i < jnode.fromColumns.size(); ++i) {
            ColumnElement fromColumn = (ColumnElement)jnode.fromColumns.get(i);
            ColumnElement toColumn = (ColumnElement)jnode.toColumns.get(i);
            QueryTable fromTable = SelectStatement.findQueryTable(jnode.fromPlan, fromColumn);
            QueryTable toTable = SelectStatement.findQueryTable(jnode.toPlan, toColumn);
            SelectStatement.processFromClause(fromTable, toTable);
            if (toTable.onClause == null) {
                toTable.onClause = new StringBuffer();
            }
            this.appendJoinCondition(toTable.onClause, fromTable, toTable, fromColumn, toColumn, "=");
            fromTable.joinOp = opCode;
        }
    }

    private static void processFromClause(QueryTable fromTable, QueryTable toTable) {
        if (toTable.prevTable == null || toTable.prevTable != fromTable) {
            // empty if block
        }
        if (fromTable.nextTable == null) {
            fromTable.nextTable = new ArrayList();
            fromTable.nextTable.add(toTable);
            toTable.prevTable = fromTable;
        } else if (!fromTable.nextTable.contains(toTable)) {
            fromTable.nextTable.add(toTable);
            toTable.prevTable = fromTable;
        }
    }

    private void appendJoinCondition(StringBuffer result, QueryTable fromTable, QueryTable toTable, ColumnElement fromColumn, ColumnElement toColumn, String joinOp) {
        if (result.length() > 0) {
            result.append(" and ");
        }
        result.append("t").append(fromTable.getTableIndex()).append(".").append(this.quoteCharStart).append(fromColumn.getName().getName()).append(this.quoteCharEnd).append(" ").append(joinOp).append(" t").append(toTable.getTableIndex()).append(".").append(this.quoteCharStart).append(toColumn.getName().getName()).append(this.quoteCharEnd);
    }

    protected String getJoinOperator(int operation) {
        String result = null;
        switch (operation) {
            case 10: {
                result = " = ";
                break;
            }
            case 16: {
                result = this.vendorType.getLeftJoin();
                break;
            }
            case 33: {
                result = this.vendorType.getRightJoin();
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.illegalop", operation));
            }
        }
        return result;
    }

    private static QueryTable findQueryTable(QueryPlan plan, ColumnElement ce) {
        QueryTable table = plan.findQueryTable(ce.getDeclaringTable());
        if (table == null) {
            // empty if block
        }
        return table;
    }

    private String generateTableListText() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.tableList.size(); ++i) {
            QueryTable t = (QueryTable)this.tableList.get(i);
            if (t.prevTable == null && t.nextTable == null) {
                this.appendTableText(str, t);
                str.append(", ");
                continue;
            }
            if (t.prevTable == null) {
                this.appendAnsiJoinText(str, t);
                continue;
            }
            while (t.prevTable != null) {
                t = t.prevTable;
            }
            if (this.tableList.contains(t)) continue;
            this.appendAnsiJoinText(str, t);
        }
        str.delete(str.length() - 2, str.length());
        return str.toString();
    }

    private void appendAnsiJoinText(StringBuffer str, QueryTable t) {
        str.append(this.vendorType.getTableListStart());
        this.appendAnsiJoinTableText(str, t);
        str.append(this.vendorType.getTableListEnd());
        str.append(", ");
    }

    private void appendAnsiJoinTableText(StringBuffer text, QueryTable table) {
        if (table.joinOp == 33) {
            text.append(this.vendorType.getRightJoinPre());
        }
        if (table.prevTable == null) {
            this.appendTableText(text, table);
        }
        for (int i = 0; i < table.nextTable.size(); ++i) {
            QueryTable toTable = (QueryTable)table.nextTable.get(i);
            text.append(this.getJoinOperator(table.joinOp)).append(" ");
            this.appendTableText(text, toTable);
            if (toTable.onClause != null) {
                text.append(" on ");
                text.append(toTable.onClause);
            }
            if (toTable.nextTable != null) {
                this.appendAnsiJoinTableText(text, toTable);
            }
            if (table.joinOp != 16) continue;
            text.append(this.vendorType.getLeftJoinPost());
        }
    }

    private void processOrderByField(ConstraintFieldDesc fieldNode, int op) {
        QueryPlan thePlan = this.getOriginalPlan(fieldNode);
        StringBuffer orderText = new StringBuffer();
        this.generateColumnText(fieldNode.desc, thePlan, orderText);
        if (op == 31) {
            orderText.append(" desc");
        }
        if (this.orderClause.length() > 0) {
            orderText.append(", ");
            orderText.append(this.orderClause);
        }
        this.orderClause = orderText;
    }

    public void bindInputValues(DBStatement s, ValueFetcher parameters) throws SQLException {
        int size = this.inputDesc.values.size();
        for (int i = 0; i < size; ++i) {
            InputValue inputVal = (InputValue)this.inputDesc.values.get(i);
            s.bindInputColumn(i + 1, SelectStatement.getInputValue(inputVal, parameters), inputVal.getColumnElement(), this.vendorType);
        }
    }

    private Object[] getInputValues(ValueFetcher parameters) {
        int size = this.inputDesc.values.size();
        Object[] inputValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            InputValue inputValue = (InputValue)this.inputDesc.values.get(i);
            inputValues[i] = SelectStatement.getInputValue(inputValue, parameters);
        }
        return inputValues;
    }

    public String getFormattedSQLText(ValueFetcher parameters) {
        return SelectStatement.formatSqlText(this.getText(), this.getInputValues(parameters));
    }

    private static Object getInputValue(InputValue inputVal, ValueFetcher parameters) {
        Object val;
        if (inputVal instanceof InputParamValue) {
            int paramIndex = ((InputParamValue)inputVal).getParamIndex();
            val = parameters.getValue(paramIndex);
        } else {
            val = inputVal.getValue();
        }
        return val;
    }
}

