/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.support.sqlstore.ConfigCache;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.VersionConsistencyCache;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ApplicationLifeCycleEventListener;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConfigCacheImpl
implements ConfigCache,
ApplicationLifeCycleEventListener {
    private Map classConfigs = new HashMap();
    private Map oidClassToClassType;
    private VersionConsistencyCache vcCache;
    private Map classLoaderToClassType = new HashMap();

    public ConfigCacheImpl() {
        this.oidClassToClassType = new HashMap();
        EJBHelper.registerApplicationLifeCycleEventListener(this);
    }

    public synchronized PersistenceConfig getPersistenceConfig(Class pcClass) {
        ClassDesc sqlConfig = (ClassDesc)this.classConfigs.get(pcClass);
        if (sqlConfig == null) {
            sqlConfig = ClassDesc.newInstance(pcClass);
            this.classConfigs.put(pcClass, sqlConfig);
            sqlConfig.initialize(this);
            this.oidClassToClassType.put(sqlConfig.getOidClass(), pcClass);
            this.addToClassLoaderMap(pcClass);
        }
        return sqlConfig;
    }

    public Class getClassByOidClass(Class oidType) {
        return (Class)this.oidClassToClassType.get(oidType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyApplicationUnloaded(ClassLoader classLoader) {
        ConfigCacheImpl configCacheImpl = this;
        synchronized (configCacheImpl) {
            List pcClasses = (List)this.classLoaderToClassType.get(classLoader);
            if (pcClasses != null) {
                Iterator it = pcClasses.iterator();
                while (it.hasNext()) {
                    Class classType = (Class)it.next();
                    ClassDesc config = (ClassDesc)this.classConfigs.remove(classType);
                    Class oidClass = config.getOidClass();
                    this.oidClassToClassType.remove(oidClass);
                    if (!config.hasVersionConsistency() || this.vcCache == null) continue;
                    this.vcCache.removePCType(classType);
                }
                this.classLoaderToClassType.remove(classLoader);
            }
        }
        TypeTable.removeInstance(classLoader);
        Model model = Model.RUNTIME;
        model.removeResourcesFromCaches(classLoader);
    }

    public synchronized void setVersionConsistencyCache(VersionConsistencyCache vcCache) {
        this.vcCache = vcCache;
    }

    private void addToClassLoaderMap(Class pcClass) {
        ClassLoader classLoader = pcClass.getClassLoader();
        ArrayList<Class> classes = (ArrayList<Class>)this.classLoaderToClassType.get(classLoader);
        if (classes == null) {
            classes = new ArrayList<Class>();
            this.classLoaderToClassType.put(classLoader, classes);
        }
        classes.add(pcClass);
    }
}

