/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.appserv.jdbc.DataSource;
import com.sun.enterprise.server.event.ApplicationEvent;
import com.sun.enterprise.server.event.ApplicationLoaderEventListener;
import com.sun.enterprise.server.event.ApplicationLoaderEventNotifier;
import com.sun.enterprise.server.event.EjbContainerEvent;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ApplicationLifeCycleEventListener;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.TransactionHelperImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class SunTransactionHelper
extends TransactionHelperImpl
implements ApplicationLoaderEventListener {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", SunTransactionHelper.class.getClassLoader());
    private static List pmf_list;
    private List applicationLifeCycleEventListeners = new ArrayList();

    SunTransactionHelper() {
    }

    public Transaction getTransaction() {
        try {
            return TransactionManagerFinder.tm.getTransaction();
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
        catch (ExceptionInInitializerError err) {
            throw new JDOFatalInternalException(err.getMessage());
        }
    }

    public UserTransaction getUserTransaction() {
        try {
            InitialContext ctx = (InitialContext)Class.forName("javax.naming.InitialContext").newInstance();
            return (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
    }

    public synchronized PersistenceManagerFactory replaceInternalPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        int i = pmf_list.indexOf(pmf);
        if (i == -1) {
            pmf_list.add(pmf);
            return pmf;
        }
        return (PersistenceManagerFactory)pmf_list.get(i);
    }

    public String getDDLNamePrefix(Object info) {
        return DeploymentHelper.getDDLNamePrefix(info);
    }

    public Connection getNonTransactionalConnection(Object resource, String username, String password) throws SQLException {
        Connection rc = null;
        if (resource instanceof DataSource) {
            DataSource ds = (DataSource)resource;
            rc = username == null ? ds.getNonTxConnection() : ds.getNonTxConnection(username, password);
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.SunTransactionHelper.wrongdatasourcetype", resource.getClass().getName()));
        }
        return rc;
    }

    public TransactionManager getLocalTransactionManager() {
        try {
            return TransactionManagerFinder.appserverTM;
        }
        catch (ExceptionInInitializerError err) {
            throw new JDOFatalInternalException(err.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerApplicationLifeCycleEventListener(ApplicationLifeCycleEventListener listener) {
        List list = this.applicationLifeCycleEventListeners;
        synchronized (list) {
            this.applicationLifeCycleEventListeners.add(listener);
        }
    }

    public void handleApplicationEvent(ApplicationEvent event) {
        if (3 == event.getEventType()) {
            ClassLoader classLoader = event.getClassLoader();
            Iterator iterator = this.applicationLifeCycleEventListeners.iterator();
            while (iterator.hasNext()) {
                ApplicationLifeCycleEventListener applicationLifeCycleEventListener = (ApplicationLifeCycleEventListener)iterator.next();
                applicationLifeCycleEventListener.notifyApplicationUnloaded(classLoader);
            }
        }
    }

    public void handleEjbContainerEvent(EjbContainerEvent event) {
    }

    static {
        SunTransactionHelper helper = new SunTransactionHelper();
        EJBHelper.registerTransactionHelper(helper);
        ApplicationLoaderEventNotifier.getInstance().addListener((ApplicationLoaderEventListener)helper);
        pmf_list = new ArrayList();
    }

    private static class TransactionManagerFinder {
        private static final String PM_TM_NAME = "java:pm/TransactionManager";
        private static final String AS_TM_NAME = "java:appserver/TransactionManager";
        static TransactionManager tm = null;
        static TransactionManager appserverTM = null;

        private TransactionManagerFinder() {
        }

        static {
            try {
                tm = (TransactionManager)new InitialContext().lookup(PM_TM_NAME);
                appserverTM = (TransactionManager)new InitialContext().lookup(AS_TM_NAME);
            }
            catch (Exception e) {
                throw new JDOFatalInternalException(e.getMessage());
            }
        }
    }
}

