/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

import antlr.TokenBuffer;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLAST;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLASTFactory;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLException;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLLexer;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLParser;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.JDOQLCodeGeneration;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.JDOQLElements;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.LogHelperQueryCompilerEJB;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ParameterSupport;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.Semantic;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.TypeSupport;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriterHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ResourceBundle;

public class EJBQLC {
    protected Model model;
    protected NameMapper nameMapper;
    protected EJBQLAST ast;
    private static Logger logger = LogHelperQueryCompilerEJB.getLogger();
    protected static final ResourceBundle msgs = I18NHelper.loadBundle(EJBQLC.class);
    public static final String SIGNATURE = "$RCSfile: EJBQLC.java,v $ $Revision: 1.7 $";

    public EJBQLC(Model model, NameMapper nameMapper) {
        this.model = model;
        this.nameMapper = nameMapper;
    }

    public JDOQLElements compile(String ejbqlQuery, Method method, int resultTypeMapping, boolean finderNotSelector, String ejbName) throws EJBQLException {
        boolean finer = logger.isLoggable(400);
        boolean finest = logger.isLoggable(300);
        if (method == null) {
            ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_MissingMethodInstance"));
        }
        if (ejbqlQuery == null || ejbqlQuery.trim().length() == 0) {
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_MissingEjbqlQueryText", ejbName, this.getMethodSignature(method)));
        }
        if (finer) {
            logger.finer("LOG_EJBQLCCompile", ejbName, this.getMethodSignature(method), ejbqlQuery);
        }
        JDOQLElements result = null;
        TypeSupport typeSupport = new TypeSupport(this.model, this.nameMapper);
        ParameterSupport paramSupport = new ParameterSupport(method);
        String pass = null;
        try {
            pass = "syntax analysis";
            if (finer) {
                logger.finer("LOG_EJBQLCStartPass", pass);
            }
            EJBQLParser parser = this.createStringParser(ejbqlQuery);
            parser.query();
            this.ast = (EJBQLAST)parser.getAST();
            if (finest) {
                logger.finest("LOG_EJBQLCDumpTree", this.ast.getTreeRepr("(AST)"));
            }
            pass = "semantic analysis";
            if (finer) {
                logger.finer("LOG_EJBQLCStartPass", pass);
            }
            Semantic semantic = new Semantic();
            semantic.init(typeSupport, paramSupport, method, resultTypeMapping, finderNotSelector, ejbName);
            semantic.setASTFactory(EJBQLASTFactory.getInstance());
            semantic.query(this.ast);
            this.ast = (EJBQLAST)semantic.getAST();
            if (finest) {
                logger.finest("LOG_EJBQLCDumpTree", this.ast.getTreeRepr("(typed AST)"));
            }
            pass = "code generation";
            if (finer) {
                logger.finer("LOG_EJBQLCStartPass", pass);
            }
            JDOQLCodeGeneration codeGen = new JDOQLCodeGeneration();
            codeGen.init(typeSupport, paramSupport);
            codeGen.setASTFactory(EJBQLASTFactory.getInstance());
            codeGen.query(this.ast);
            result = codeGen.getJDOQLElements();
            if (finer) {
                logger.finer("LOG_EJBQLCResult", result.toString());
            }
        }
        catch (EJBQLException ex) {
            Object[] msgArgs = new Object[]{ejbName, this.getMethodSignature(method), ejbqlQuery, ex.getMessage()};
            ErrorMsg.error(I18NHelper.getMessage(msgs, "EXC_InvalidEJBQLQuery", msgArgs));
        }
        catch (Throwable t) {
            Object[] msgArgs = new Object[]{ejbName, this.getMethodSignature(method), ejbqlQuery, t.toString()};
            ErrorMsg.log(1000, I18NHelper.getMessage(msgs, "EXC_EJBQLQueryInternalError", msgArgs), t);
        }
        return result;
    }

    private EJBQLParser createStringParser(String text) {
        StringReader in = new StringReader(text);
        EJBQLLexer lexer = new EJBQLLexer(in);
        TokenBuffer buffer = new TokenBuffer(lexer);
        EJBQLParser parser = new EJBQLParser(buffer);
        parser.setASTFactory(EJBQLASTFactory.getInstance());
        return parser;
    }

    private String getMethodSignature(Method m) {
        if (m == null) {
            return "";
        }
        return m.getReturnType().getName() + ' ' + m.getName() + "(" + JavaClassWriterHelper.getParameterTypesList(m) + ")";
    }
}

