/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.impl.ClassControl;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.util.ArrayList;
import java.util.Iterator;

public class EnhancerControl {
    private Environment env;

    public EnhancerControl(Environment env) {
        this.env = env;
    }

    protected static void dumpClass(ClassControl cc) {
        String name = cc.userClassName();
        System.out.println();
        System.out.println("dumping class " + name + " {");
        cc.classFile().print(System.out);
        System.out.println("} // end of class " + name);
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyClasses() {
        try {
            ClassControl cc;
            ArrayList classes;
            if (this.env.doTimingStatistics()) {
                Support.timer.push("EnhancerControl.modifyClasses()");
            }
            if ((classes = this.env.collectClasses()).size() > 1) {
                this.env.messageNL("scanning classes");
            }
            Iterator e = classes.iterator();
            while (e.hasNext()) {
                cc = (ClassControl)e.next();
                cc.scan1();
            }
            if (this.env.errorCount() > 0) {
                return;
            }
            if (classes.size() > 1) {
                this.env.messageNL("augmenting classes");
            }
            e = classes.iterator();
            while (e.hasNext()) {
                cc = (ClassControl)e.next();
                cc.augment();
            }
            if (this.env.errorCount() > 0) {
                return;
            }
            if (classes.size() > 1) {
                this.env.messageNL("annotating classes");
            }
            e = classes.iterator();
            while (e.hasNext()) {
                cc = (ClassControl)e.next();
                cc.annotate();
            }
        }
        finally {
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
    }
}

