/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasic;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasicMemberRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstDouble;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstFieldRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstFloat;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstInteger;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstInterfaceMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstLong;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstNameAndType;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstString;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUnicode;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class ConstantPool
implements VMConstants {
    private Vector pool = new Vector();
    private boolean hashed = false;
    private Hashtable utfTable = new Hashtable(11);
    private Hashtable unicodeTable = new Hashtable(3);
    private Hashtable stringTable = new Hashtable(11);
    private Hashtable classTable = new Hashtable(11);
    private Hashtable intTable = new Hashtable(3);
    private Hashtable floatTable = new Hashtable(3);
    private Hashtable longTable = new Hashtable(3);
    private Hashtable doubleTable = new Hashtable(3);
    private Vector methodRefTable = new Vector();
    private Vector fieldRefTable = new Vector();
    private Vector ifaceMethodRefTable = new Vector();
    private Vector nameAndTypeTable = new Vector();

    public int nEntries() {
        return this.pool.size();
    }

    public ConstBasic constantAt(int index) {
        return (ConstBasic)this.pool.elementAt(index);
    }

    public ConstClass addClass(String className) {
        this.hashConstants();
        ConstClass c = (ConstClass)this.classTable.get(className);
        if (c == null) {
            c = new ConstClass(this.addUtf8(className));
            this.internConstant(c);
        }
        return c;
    }

    public ConstFieldRef addFieldRef(String className, String fieldName, String type) {
        this.hashConstants();
        ConstFieldRef f = (ConstFieldRef)this.searchTable(this.fieldRefTable, className, fieldName, type);
        if (f == null) {
            f = new ConstFieldRef(this.addClass(className), this.addNameAndType(fieldName, type));
            this.internConstant(f);
        }
        return f;
    }

    public ConstMethodRef addMethodRef(String className, String methodName, String type) {
        this.hashConstants();
        ConstMethodRef m = (ConstMethodRef)this.searchTable(this.methodRefTable, className, methodName, type);
        if (m == null) {
            m = new ConstMethodRef(this.addClass(className), this.addNameAndType(methodName, type));
            this.internConstant(m);
        }
        return m;
    }

    public ConstInterfaceMethodRef addInterfaceMethodRef(String className, String methodName, String type) {
        this.hashConstants();
        ConstInterfaceMethodRef m = (ConstInterfaceMethodRef)this.searchTable(this.ifaceMethodRefTable, className, methodName, type);
        if (m == null) {
            m = new ConstInterfaceMethodRef(this.addClass(className), this.addNameAndType(methodName, type));
            this.internConstant(m);
        }
        return m;
    }

    public ConstString addString(String s) {
        this.hashConstants();
        ConstString cs = (ConstString)this.stringTable.get(s);
        if (cs == null) {
            cs = new ConstString(this.addUtf8(s));
            this.internConstant(cs);
        }
        return cs;
    }

    public ConstInteger addInteger(int i) {
        this.hashConstants();
        Integer io = new Integer(i);
        ConstInteger ci = (ConstInteger)this.intTable.get(io);
        if (ci == null) {
            ci = new ConstInteger(i);
            this.internConstant(ci);
        }
        return ci;
    }

    public ConstFloat addFloat(float f) {
        this.hashConstants();
        Float fo = new Float(f);
        ConstFloat cf = (ConstFloat)this.floatTable.get(fo);
        if (cf == null) {
            cf = new ConstFloat(f);
            this.internConstant(cf);
        }
        return cf;
    }

    public ConstLong addLong(long l) {
        this.hashConstants();
        Long lo = new Long(l);
        ConstLong cl = (ConstLong)this.longTable.get(lo);
        if (cl == null) {
            cl = new ConstLong(l);
            this.internConstant(cl);
            this.internConstant(null);
        }
        return cl;
    }

    public ConstDouble addDouble(double d) {
        this.hashConstants();
        Double dobj = new Double(d);
        ConstDouble cd = (ConstDouble)this.doubleTable.get(dobj);
        if (cd == null) {
            cd = new ConstDouble(d);
            this.internConstant(cd);
            this.internConstant(null);
        }
        return cd;
    }

    public ConstNameAndType addNameAndType(String name, String type) {
        this.hashConstants();
        for (int i = 0; i < this.nameAndTypeTable.size(); ++i) {
            ConstNameAndType nt = (ConstNameAndType)this.nameAndTypeTable.elementAt(i);
            if (!nt.name().asString().equals(name) || !nt.signature().asString().equals(type)) continue;
            return nt;
        }
        ConstNameAndType nt = new ConstNameAndType(this.addUtf8(name), this.addUtf8(type));
        this.internConstant(nt);
        return nt;
    }

    public ConstUtf8 addUtf8(String s) {
        this.hashConstants();
        ConstUtf8 u = (ConstUtf8)this.utfTable.get(s);
        if (u == null) {
            u = new ConstUtf8(s);
            this.internConstant(u);
        }
        return u;
    }

    public ConstUnicode addUnicode(String s) {
        this.hashConstants();
        ConstUnicode u = (ConstUnicode)this.unicodeTable.get(s);
        if (u == null) {
            u = new ConstUnicode(s);
            this.internConstant(u);
        }
        return u;
    }

    ConstantPool() {
        this.pool.addElement(null);
    }

    ConstantPool(DataInputStream input) throws IOException {
        this.pool.addElement(null);
        for (int nconstants = input.readUnsignedShort() - 1; nconstants > 0; nconstants -= this.readConstant(input)) {
        }
        this.resolvePool();
    }

    void print(PrintStream out) {
        for (int i = 0; i < this.pool.size(); ++i) {
            ConstBasic c = this.constantAt(i);
            if (c == null) continue;
            out.print(i);
            out.print(": ");
            out.println(c.toString());
        }
    }

    void summarize() {
        int stringSize = 0;
        int nStrings = 0;
        for (int i = 0; i < this.pool.size(); ++i) {
            ConstBasic c = this.constantAt(i);
            if (c == null || c.tag() != 1) continue;
            ConstUtf8 utf8 = (ConstUtf8)c;
            stringSize += utf8.asString().length();
            ++nStrings;
        }
        System.out.println("  " + nStrings + " strings totalling " + stringSize + " bytes");
    }

    void write(DataOutputStream buff) throws IOException {
        buff.writeShort(this.pool.size());
        for (int i = 1; i < this.pool.size(); ++i) {
            ConstBasic cb = (ConstBasic)this.pool.elementAt(i);
            if (cb == null) continue;
            buff.writeByte((byte)cb.tag());
            cb.formatData(buff);
        }
    }

    private void resolvePool() {
        for (int i = 0; i < this.pool.size(); ++i) {
            ConstBasic c = this.constantAt(i);
            if (c == null) continue;
            c.setIndex(i);
            c.resolve(this);
        }
    }

    private void hashConstants() {
        if (this.hashed) {
            return;
        }
        for (int j = 0; j < this.pool.size(); ++j) {
            ConstBasic c = this.constantAt(j);
            if (c == null) continue;
            this.recordConstant(c);
        }
        this.hashed = true;
    }

    /*
     * WARNING - void declaration
     */
    private int readConstant(DataInputStream input) throws IOException {
        void var2_4;
        byte b = input.readByte();
        int slots = 1;
        switch (b) {
            case 1: {
                ConstBasic basic = ConstUtf8.read(input);
                break;
            }
            case 2: {
                ConstBasic basic = ConstUnicode.read(input);
                break;
            }
            case 3: {
                ConstBasic basic = ConstInteger.read(input);
                break;
            }
            case 4: {
                ConstBasic basic = ConstFloat.read(input);
                break;
            }
            case 5: {
                ConstBasic basic = ConstLong.read(input);
                slots = 2;
                break;
            }
            case 6: {
                ConstBasic basic = ConstDouble.read(input);
                slots = 2;
                break;
            }
            case 7: {
                ConstBasic basic = ConstClass.read(input);
                break;
            }
            case 8: {
                ConstBasic basic = ConstString.read(input);
                break;
            }
            case 9: {
                ConstBasic basic = ConstFieldRef.read(input);
                break;
            }
            case 10: {
                ConstBasic basic = ConstMethodRef.read(input);
                break;
            }
            case 11: {
                ConstBasic basic = ConstInterfaceMethodRef.read(input);
                break;
            }
            case 12: {
                ConstBasic basic = ConstNameAndType.read(input);
                break;
            }
            default: {
                throw new ClassFormatError("Don't know this constant type: " + Integer.toString(b));
            }
        }
        this.pool.addElement(var2_4);
        if (slots > 1) {
            this.pool.addElement(null);
        }
        return slots;
    }

    private void internConstant(ConstBasic c) {
        if (c != null) {
            c.setIndex(this.pool.size());
            this.recordConstant(c);
        }
        this.pool.addElement(c);
    }

    private void recordConstant(ConstBasic c) {
        if (c != null) {
            switch (c.tag()) {
                case 1: {
                    this.utfTable.put(((ConstUtf8)c).asString(), c);
                    break;
                }
                case 2: {
                    this.unicodeTable.put(((ConstUnicode)c).asString(), c);
                    break;
                }
                case 3: {
                    this.intTable.put(new Integer(((ConstInteger)c).value()), c);
                    break;
                }
                case 4: {
                    this.floatTable.put(new Float(((ConstFloat)c).value()), c);
                    break;
                }
                case 5: {
                    this.longTable.put(new Long(((ConstLong)c).value()), c);
                    break;
                }
                case 6: {
                    this.doubleTable.put(new Double(((ConstDouble)c).value()), c);
                    break;
                }
                case 7: {
                    this.classTable.put(((ConstClass)c).asString(), c);
                    break;
                }
                case 8: {
                    this.stringTable.put(((ConstString)c).value().asString(), c);
                    break;
                }
                case 9: {
                    this.fieldRefTable.addElement(c);
                    break;
                }
                case 10: {
                    this.methodRefTable.addElement(c);
                    break;
                }
                case 11: {
                    this.ifaceMethodRefTable.addElement(c);
                    break;
                }
                case 12: {
                    this.nameAndTypeTable.addElement(c);
                }
            }
        }
    }

    private ConstBasicMemberRef searchTable(Vector table, String cname, String mname, String sig) {
        for (int i = 0; i < table.size(); ++i) {
            ConstBasicMemberRef memRef = (ConstBasicMemberRef)table.elementAt(i);
            if (!memRef.className().asString().equals(cname) || !memRef.nameAndType().name().asString().equals(mname) || !memRef.nameAndType().signature().asString().equals(sig)) continue;
            return memRef;
        }
        return null;
    }
}

