/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.nodes;

import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.DBschemaDataObject;
import com.sun.forte4j.modules.dbmodel.nodes.DBElementNodeFactory;
import com.sun.forte4j.modules.dbmodel.nodes.SchemaElementFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class SchemaRootChildren
extends Children.Keys {
    static final Object NOT_KEY = new Object();
    static final Object ERROR_KEY = new Object();
    protected SchemaElement element;
    protected DBElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private DBElementListener propL;
    private boolean nodesInited = false;
    private String schemaPackage;
    private boolean parseStatus = false;
    private DBschemaDataObject obj;

    public SchemaRootChildren(DBElementNodeFactory factory, DBschemaDataObject obj) {
        this.factory = factory;
        this.obj = obj;
        this.schemaPackage = obj.getPrimaryFile().getPackageName('.') + ".dbschema..";
    }

    protected void addNotify() {
        SchemaElement el = this.getElement();
        if (el != null) {
            if (this.wPropL == null) {
                this.propL = new DBElementListener();
                this.wPropL = WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)el);
            }
            el.addPropertyChangeListener(this.wPropL);
        }
        this.refreshKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof SchemaElement) {
            return new Node[]{this.factory.createSchemaNode((SchemaElement)key)};
        }
        if (NOT_KEY.equals(key)) {
            return new Node[]{this.factory.createWaitNode()};
        }
        return new Node[]{this.factory.createErrorNode()};
    }

    public SchemaElement getElement() {
        if (this.element == null && !this.parseStatus) {
            this.refreshKeys2();
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    SchemaRootChildren.this.nodesInited = true;
                    SchemaRootChildren.this.setElement(SchemaRootChildren.this.obj.getSchema());
                    SchemaRootChildren.this.parseStatus = true;
                }
            }, (int)0);
        }
        return this.element;
    }

    public void setElement(SchemaElement element) {
        if (this.element != null) {
            this.element.removePropertyChangeListener(this.wPropL);
        }
        this.element = element;
        if (this.element != null) {
            if (this.wPropL == null) {
                this.propL = new DBElementListener();
                this.wPropL = WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
            }
            this.element.addPropertyChangeListener(this.wPropL);
        }
        if (this.nodesInited) {
            this.refreshKeys();
        }
    }

    public void refreshKeys() {
        SchemaElement el = this.getElement();
        int status = this.parseStatus ? (el == null ? 1 : el.getStatus()) : (el == null ? 0 : el.getStatus());
        switch (status) {
            case 0: {
                this.setKeys(new Object[]{NOT_KEY});
                break;
            }
            case 1: {
                this.setKeys(new Object[]{ERROR_KEY});
                break;
            }
            case 2: 
            case 3: {
                this.refreshAllKeys();
            }
        }
    }

    private void refreshKeys2() {
        this.setKeys(new Object[]{NOT_KEY});
    }

    private void refreshAllKeys() {
        int[] order = SchemaElementFilter.DEFAULT_ORDER;
        final LinkedList keys = new LinkedList();
        for (int i = 0; i < order.length; ++i) {
            this.addKeysOfType(keys, order[i]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SchemaRootChildren.this.setKeys2(keys);
            }
        });
    }

    private void addKeysOfType(Collection keys, int elementType) {
        SchemaElement schemaElement = this.getElement();
        if (elementType != 0) {
            keys.add(schemaElement);
        }
    }

    private void setKeys2(Collection c) {
        this.setKeys(c);
    }

    private final class DBElementListener
    implements PropertyChangeListener {
        private DBElementListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            boolean refresh = "schema".equals(evt.getPropertyName());
            if (!refresh && "status".equals(evt.getPropertyName())) {
                Integer val = (Integer)evt.getNewValue();
                boolean bl = refresh = val == null || val != 0;
            }
            if (refresh) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ DBElementListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        DBElementListener.access$500(this.this$1).refreshKeys();
                    }
                });
            }
        }

        static /* synthetic */ SchemaRootChildren access$500(DBElementListener x0) {
            return x0.SchemaRootChildren.this;
        }
    }
}

