/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.openide.util.NbBundle;

public class ProgressFrame
extends JFrame {
    ResourceBundle bundle = NbBundle.getBundle((String)"com.sun.forte4j.modules.dbmodel.jdbcimpl.resources.Bundle");
    public PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private JLabel msgLabel;
    private JButton okButton;
    private JProgressBar progressBar;

    public ProgressFrame() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ProgressFrameTabA11yDesc"));
        this.okButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CancelButtonA11yDesc"));
        ImageIcon ideIcon = new ImageIcon("/org/netbeans/core/resources/frames/ide.gif");
        this.setIconImage(ideIcon.getImage());
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(380, 150);
        this.setLocation(dim.width / 2 - 190, dim.height / 2 - 80);
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.msgLabel = new JLabel();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(this.bundle.getString("Title"));
        this.setResizable(false);
        this.progressBar.setToolTipText("");
        this.progressBar.setMaximum(0);
        this.progressBar.setString(this.bundle.getString("ZeroPercent"));
        this.progressBar.setName("");
        this.progressBar.setStringPainted(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.msgLabel.setText(this.bundle.getString("PreparingToCapture"));
        this.msgLabel.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.msgLabel, gridBagConstraints);
        this.okButton.setText(this.bundle.getString("Close"));
        this.okButton.setHorizontalTextPosition(0);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProgressFrame.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.propertySupport.firePropertyChange("cancel", null, new Boolean(true));
        this.dispose();
    }

    public void setMaximum(int max) {
        this.progressBar.setMaximum(max);
    }

    public void setValue(int value) {
        this.progressBar.setValue(value);
        if (this.progressBar.getPercentComplete() == 1.0) {
            String message = MessageFormat.format(this.bundle.getString("Complete"), Integer.toString(value));
            this.progressBar.setString(message);
        } else {
            String message = MessageFormat.format(this.bundle.getString("Progress"), Integer.toString(new Double(this.progressBar.getPercentComplete() * 100.0).intValue()));
            this.progressBar.setString(message);
        }
    }

    public void setMessage(String msg) {
        this.msgLabel.setText(msg);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }
}

