/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;
import com.sun.enterprise.tools.upgrade.gui.AddDomainDialog;
import com.sun.enterprise.tools.upgrade.gui.FlowLabel;
import com.sun.enterprise.tools.upgrade.gui.HeaderPanel;
import com.sun.enterprise.tools.upgrade.gui.util.DialogEvent;
import com.sun.enterprise.tools.upgrade.gui.util.DialogListener;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

public class CertificatePanel
extends JPanel {
    private JButton addDomainButton;
    private JButton deleteDomainButton;
    private JTable domainTable;
    private DomainsTableModel domainsTableModel;
    private JScrollPane domainTableScrollPane;
    private CommonInfoModel commonInfoModel;
    private JFrame parent = null;
    private List domainNamesInTable = null;
    private AddDomainDialog addDomainDialog = null;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    static /* synthetic */ Class class$java$lang$String;

    public CertificatePanel(CommonInfoModel model, JFrame parent) {
        this.commonInfoModel = model;
        this.parent = parent;
        this.domainNamesInTable = new ArrayList();
        this.initComponents();
    }

    private void initComponents() {
        JPanel tablePanel = new JPanel();
        this.domainTableScrollPane = new JScrollPane();
        this.domainTable = new JTable();
        this.addDomainButton = new JButton();
        this.addDomainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CertificatePanel.this.performAddDomainAction();
            }
        });
        this.deleteDomainButton = new JButton();
        this.deleteDomainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CertificatePanel.this.performDeleteDomainAction();
            }
        });
        JPanel dummyPanel1 = new JPanel();
        JPanel dummyPanel2 = new JPanel();
        JPanel dummyContentPanel = new JPanel();
        this.setLayout(new BorderLayout());
        HeaderPanel headerPanel = new HeaderPanel(this.stringManager.getString("upgrade.gui.certpanel.headerPanel"));
        headerPanel.setInsets(new Insets(12, 10, 5, 10));
        this.add((Component)headerPanel, "North");
        dummyContentPanel.setLayout(new GridBagLayout());
        FlowLabel flowContentLabel = new FlowLabel();
        flowContentLabel.setText(this.stringManager.getString("upgrade.gui.certpanel.flowContentLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        dummyContentPanel.add((Component)flowContentLabel, gridBagConstraints);
        tablePanel.setLayout(new GridBagLayout());
        tablePanel.setBorder(new TitledBorder(this.stringManager.getString("upgrade.gui.certpanel.certPanelTitle")));
        this.domainsTableModel = new DomainsTableModel(this.domainNamesInTable);
        this.domainTable.setModel(this.domainsTableModel);
        this.domainTableScrollPane.setViewportView(this.domainTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        tablePanel.add((Component)this.domainTableScrollPane, gridBagConstraints);
        this.addDomainButton.setText(this.stringManager.getString("upgrade.gui.certpanel.addDomainButtonText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 15, 10, 10);
        tablePanel.add((Component)this.addDomainButton, gridBagConstraints);
        this.deleteDomainButton.setText(this.stringManager.getString("upgrade.gui.certpanel.deleteDomainButtonText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 15, 10, 10);
        tablePanel.add((Component)this.deleteDomainButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.5;
        tablePanel.add((Component)dummyPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.5;
        tablePanel.add((Component)dummyPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        dummyContentPanel.add((Component)tablePanel, gridBagConstraints);
        this.add((Component)dummyContentPanel, "Center");
    }

    void performAddDomainAction() {
        this.getAddDomainDialog().clearFields();
        this.getAddDomainDialog().setVisible(true);
    }

    void performDeleteDomainAction() {
        int selRow = this.domainTable.getSelectedRow();
        if (selRow != -1) {
            int option = JOptionPane.showConfirmDialog(this, this.stringManager.getString("upgrade.gui.certpanel.deleteConfirmMsg"), this.stringManager.getString("upgrade.gui.certpanel.deleteConfirmTitle"), 0, 3);
            if (option == 1) {
                return;
            }
            this.commonInfoModel.setCertDbPassword((String)this.domainNamesInTable.get(selRow), "");
            this.commonInfoModel.setJksKeystorePassword((String)this.domainNamesInTable.get(selRow), "");
            this.domainsTableModel.removeDomain(selRow);
        }
    }

    private AddDomainDialog getAddDomainDialog() {
        if (this.addDomainDialog == null) {
            int sourceToTarget = 0;
            sourceToTarget = this.commonInfoModel.checkUpgradefrom7xpeseto8xpe() ? 3 : (this.commonInfoModel.checkUpgradefrom80peto81pe() ? 1 : (this.commonInfoModel.checkUpgradefrom8xpeto8xse() ? 4 : 2));
            this.addDomainDialog = new AddDomainDialog((Frame)this.parent, true, this.commonInfoModel.getDomainList(), sourceToTarget);
            this.centerDialog(this.addDomainDialog);
            this.addDomainDialog.addDialogListener(new DialogListener(){

                public void dialogProcessed(DialogEvent evt) {
                    CertificatePanel.this.processAddDomainDialogEvent(evt);
                }
            });
        }
        return this.addDomainDialog;
    }

    public void reInitializeAddDomainDialog() {
        this.addDomainDialog = null;
    }

    public void centerDialog(JDialog dialog) {
        Rectangle bounds = this.parent.getBounds();
        Rectangle dialogLocation = new Rectangle();
        dialogLocation.x = bounds.x + (bounds.width - dialog.getWidth()) / 2;
        dialogLocation.y = bounds.y + (bounds.height - dialog.getHeight()) / 2;
        dialogLocation.setSize(dialog.getWidth(), dialog.getHeight());
        dialog.setBounds(dialogLocation);
    }

    private List processv70PESEto8xPE(String selectedDomainName, String pwd1, String pwd2, String pwd3) {
        this.commonInfoModel.setCurrentDomain(selectedDomainName);
        this.commonInfoModel.setCertDbPassword(pwd1);
        boolean validpwd = PasswordVerifier.verifySourceNSSPassword(this.commonInfoModel);
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidNSSPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidNSSPWDTitle"));
            return errorList;
        }
        this.commonInfoModel.setJksKeystorePassword(pwd2);
        String jksPath = this.commonInfoModel.getTargetJKSKeyStorePath();
        validpwd = PasswordVerifier.verifyKeystorePassword(jksPath, pwd2);
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidJKSPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidJKSPWDTitle"));
            return errorList;
        }
        this.commonInfoModel.setJksCAKeystorePassword(pwd3);
        String trustJksPath = this.commonInfoModel.getTargetTrustedJKSKeyStorePath();
        validpwd = PasswordVerifier.verifyKeystorePassword(trustJksPath, pwd3);
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidCAPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidCAPWDTitle"));
            return errorList;
        }
        return null;
    }

    private List processv8xPEto8xSEEE(String selectedDomainName, String pwd1, String pwd2, String pwd3) {
        this.commonInfoModel.setCurrentDomain(selectedDomainName);
        this.commonInfoModel.setCertDbPassword(pwd3);
        this.commonInfoModel.setTargetCertDbPassword(pwd3);
        boolean validpwd = PasswordVerifier.verifyTargetNSSPassword(this.commonInfoModel, this.commonInfoModel.getTargetConfig());
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidTargetNSSPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidTargetNSSPWDTitle"));
            return errorList;
        }
        this.commonInfoModel.setJksKeystorePassword(pwd1);
        String jksPath = this.commonInfoModel.getSourceJKSKeyStorePath();
        validpwd = PasswordVerifier.verifyKeystorePassword(jksPath, pwd1);
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidJKSPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidJKSPWDTitle"));
            return errorList;
        }
        this.commonInfoModel.setJksCAKeystorePassword(pwd2);
        String trustJksPath = this.commonInfoModel.getSourceTrustedJKSKeyStorePath();
        validpwd = PasswordVerifier.verifyKeystorePassword(trustJksPath, pwd2);
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidCAPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidCAPWDTitle"));
            return errorList;
        }
        return null;
    }

    private List processv80PEto81PE(String selectedDomainName, String pwd1, String pwd2) {
        this.commonInfoModel.setCurrentDomain(selectedDomainName);
        this.commonInfoModel.setJksKeystorePassword(pwd1);
        String jksPath = this.commonInfoModel.getSourceJKSKeyStorePath();
        boolean validpwd = PasswordVerifier.verifyKeystorePassword(jksPath, pwd1);
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidJKSPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidJKSPWDTitle"));
            return errorList;
        }
        this.commonInfoModel.setJksCAKeystorePassword(pwd2);
        String trustJksPath = this.commonInfoModel.getSourceTrustedJKSKeyStorePath();
        validpwd = PasswordVerifier.verifyKeystorePassword(trustJksPath, pwd2);
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidCAPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidCAPWDTitle"));
            return errorList;
        }
        return null;
    }

    private List processv70SEto81SE(String selectedDomainName, String pwd1, String pwd2) {
        this.commonInfoModel.setCurrentDomain(selectedDomainName);
        this.commonInfoModel.setCertDbPassword(pwd1);
        boolean validpwd = PasswordVerifier.verifySourceNSSPassword(this.commonInfoModel);
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidNSSPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidNSSPWDTitle"));
            return errorList;
        }
        this.commonInfoModel.setTargetCertDbPassword(pwd2);
        validpwd = PasswordVerifier.verifyTargetNSSPassword(this.commonInfoModel, this.commonInfoModel.getTargetConfig());
        if (!validpwd) {
            this.commonInfoModel.recover();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidTargetNSSPWDMsg"));
            errorList.add(this.stringManager.getString("upgrade.gui.certpanel.invalidTargetNSSPWDTitle"));
            return errorList;
        }
        return null;
    }

    private void processAddDomainDialogEvent(DialogEvent evt) {
        if (evt.getAction() == 2) {
            this.addDomainDialog.setVisible(false);
            this.addDomainDialog.dispose();
        }
        if (evt.getAction() != 6 && evt.getAction() == 5) {
            int sourceToTargetVersion;
            Vector data = (Vector)evt.getObject();
            if (data.get(0) == null || data.size() < 2) {
                JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.certpanel.chooseDomainMsg"), this.stringManager.getString("upgrade.gui.certpanel.chooseDomainTitle"), 0);
                return;
            }
            if (!this.domainNamesInTable.contains(data.get(0))) {
                this.domainsTableModel.addDomain((String)data.get(0));
                this.commonInfoModel.addDomainOptionName((String)data.get(0));
            }
            if ((sourceToTargetVersion = ((Integer)data.get(1)).intValue()) == 3 && data.size() > 4) {
                List errorMessageList = this.processv70PESEto8xPE((String)data.get(0), (String)data.get(2), (String)data.get(3), (String)data.get(4));
                if (errorMessageList != null) {
                    JOptionPane.showMessageDialog(this, (String)errorMessageList.get(0), (String)errorMessageList.get(1), 0);
                    return;
                }
            } else if (sourceToTargetVersion == 4 && data.size() > 4) {
                List errorMessageList = this.processv8xPEto8xSEEE((String)data.get(0), (String)data.get(2), (String)data.get(3), (String)data.get(4));
                if (errorMessageList != null) {
                    JOptionPane.showMessageDialog(this, (String)errorMessageList.get(0), (String)errorMessageList.get(1), 0);
                    return;
                }
            } else if (sourceToTargetVersion == 1 && data.size() > 3) {
                List errorMessageList = this.processv80PEto81PE((String)data.get(0), (String)data.get(2), (String)data.get(3));
                if (errorMessageList != null) {
                    JOptionPane.showMessageDialog(this, (String)errorMessageList.get(0), (String)errorMessageList.get(1), 0);
                    return;
                }
            } else if (sourceToTargetVersion == 2 && data.size() > 3) {
                List errorMessageList = this.processv70SEto81SE((String)data.get(0), (String)data.get(2), (String)data.get(3));
                if (errorMessageList != null) {
                    JOptionPane.showMessageDialog(this, (String)errorMessageList.get(0), (String)errorMessageList.get(1), 0);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, this.stringManager.getString("upgrade.gui.certpanel.chooseDomainMsg"), this.stringManager.getString("upgrade.gui.certpanel.chooseDomainTitle"), 0);
                return;
            }
            this.addDomainDialog.setVisible(false);
            this.addDomainDialog.dispose();
        }
    }

    static /* synthetic */ StringManager access$100(CertificatePanel x0) {
        return x0.stringManager;
    }

    class DomainsTableModel
    extends AbstractTableModel {
        private List domains = null;
        private String[] columnNames = new String[]{CertificatePanel.access$100(CertificatePanel.this).getString("upgrade.gui.certpanel.tableColumnName")};

        public DomainsTableModel(List doms) {
            this.domains = doms;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return this.domains.size();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int c) {
            return class$java$lang$String == null ? (class$java$lang$String = CertificatePanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int row, int col) {
            return (String)this.domains.get(row);
        }

        public void removeDomain(int domainIndex) {
            if (this.domains.size() > domainIndex) {
                this.domains.remove(domainIndex);
                this.fireTableDataChanged();
            }
        }

        public void addDomain(String domainName) {
            if (domainName != null) {
                this.domains.add(domainName);
                this.fireTableDataChanged();
            }
        }
    }
}

