/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.cli.framework.CLIMain;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class Commands {
    private static StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.common");

    public static boolean deploy(String modulePath, CommonInfoModel commonInfo) {
        String currentDomain = commonInfo.getCurrentDomain();
        String adminPort = DomainsProcessor.getTargetDomainPort(currentDomain, commonInfo);
        String adminSecurity = DomainsProcessor.getTargetDomainSecurity(currentDomain, commonInfo);
        String edition = commonInfo.getTargetEdition();
        String[] deploy = new String[]{"deploy", "--user", commonInfo.getAdminUserName(), "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", "--port", adminPort, "--secure=" + adminSecurity, "\"" + modulePath + "\""};
        if (!commonInfo.getTargetEdition().equals("pe")) {
            String targetName = commonInfo.getCurrentCluster();
            if (targetName == null) {
                targetName = commonInfo.getCurrentSourceInstance();
            }
            if (targetName != null && !"".equals(targetName)) {
                deploy = new String[]{"deploy", "--user", commonInfo.getAdminUserName(), "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", "--port", adminPort, "--secure=" + adminSecurity, "--target", targetName, "\"" + modulePath + "\""};
            }
        }
        try {
            return Commands.executeCommand(deploy);
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.generalExceptionMsg") + " " + (t == null ? ce.getMessage() : t.getMessage()));
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.errorDeployingMsg") + modulePath);
            return false;
        }
    }

    public static boolean startDomain(String domainName, CommonInfoModel commonInfo) {
        String[] command = new String[]{"start-domain", "--domaindir", "\"" + commonInfo.getTargetDomainRoot() + "\"", "--user", commonInfo.getAdminUserName(), "--passwordfile ", "\"" + commonInfo.getPasswordFile() + "\"", domainName};
        try {
            boolean b = Commands.executeCommand(command);
            return b;
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            CommonInfoModel.getDefaultLogger().severe(stringManager.getString("commands.generalExceptionMsg") + ce.getMessage());
            if (t != null) {
                String message = t.getMessage();
                CommonInfoModel.getDefaultLogger().severe(stringManager.getString("commands.generalExceptionMsg") + message);
                if (message.indexOf(stringManager.getString("commands.DomainRunningFragment")) != -1 || stringManager.getString("commands.DomainRunningFragment").equalsIgnoreCase("No local string defined") && message.indexOf("running") != -1) {
                    CommonInfoModel.getDefaultLogger().severe(stringManager.getString("commands.DomainRunningMsg", (Object)domainName));
                }
            }
            return false;
        }
    }

    public static boolean stopDomain(String domainName, CommonInfoModel commonInfo) {
        String[] command = new String[]{"stop-domain", "--domaindir", "\"" + commonInfo.getTargetDomainRoot() + "\"", domainName};
        try {
            boolean b = Commands.executeCommand(command);
            return b;
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            if (t != null && t.getMessage().indexOf("is not running") != -1) {
                return true;
            }
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.generalExceptionMsg") + ce.getMessage());
            return false;
        }
    }

    public static boolean executeCommand(String[] commandStrings) throws CommandException {
        try {
            StringBuffer commandOneString = new StringBuffer();
            for (int i = 0; i < commandStrings.length; ++i) {
                commandOneString.append(commandStrings[i]).append(" ");
            }
            InputsAndOutputs io = InputsAndOutputs.getInstance();
            PipedOutputStream pos = new PipedOutputStream();
            io.setErrorOutput((OutputStream)pos);
            io.setUserOutput((OutputStream)pos);
            CommandOutputReader cor = new CommandOutputReader(pos);
            cor.start();
            CommonInfoModel.getDefaultLogger().info(stringManager.getString("commands.executingCommandMsg") + commandOneString);
            CLIMain.invokeCLI((String)commandOneString.toString(), (InputsAndOutputs)io);
            pos.flush();
            return true;
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.generalExceptionMsg") + (t == null ? e.getMessage() : t.getMessage()));
            return false;
        }
    }

    static class CommandOutputReader
    extends Thread {
        PipedInputStream pis = new PipedInputStream();

        public CommandOutputReader(PipedOutputStream pout) throws IOException {
            this.pis.connect(pout);
        }

        public void run() {
            DataInputStream dis = new DataInputStream(this.pis);
            try {
                while (dis.available() > -1) {
                    CommonInfoModel.getDefaultLogger().info(dis.readLine());
                }
                this.pis.close();
            }
            catch (IOException ioe) {
                try {
                    dis.close();
                    this.pis.close();
                }
                catch (Exception e) {
                    CommonInfoModel.getDefaultLogger().info(e.getMessage());
                }
            }
        }
    }
}

