/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade;

import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.cluster.IIOPCluster;
import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.CommonProperties;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.tools.upgrade.common.HarnessException;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpgradeHarness {
    private static Logger logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
    private List moduleList = new LinkedList();
    private CommonInfoModel commonInfo;

    public void setCommonInfoModel(CommonInfoModel commonInfo) {
        this.commonInfo = commonInfo;
    }

    public void startUpgrade() {
        if (this.commonInfo.checkSourceInputAsDomainRoot(this.commonInfo.getSourceInstallDir())) {
            this.commonInfo.setSourceDomainRoot(this.commonInfo.getSourceInstallDir());
        }
        this.loadModules();
        System.setProperty("com.sun.aas.configRoot", this.commonInfo.getTargetInstallDir() + File.separator + "config");
        try {
            DomainsProcessor dProcessor = new DomainsProcessor(this.commonInfo);
            dProcessor.processTargetDomains();
            UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(30);
            if (!this.commonInfo.getSourceEdition().equals("pe")) {
                if (this.commonInfo.getSourceEdition().equals("ee")) {
                    if (dProcessor.processClusters()) {
                        this.upgradeEESource();
                    } else {
                        dProcessor.processDomainInstances();
                    }
                    return;
                }
                dProcessor.processDomainInstances();
            } else if (this.commonInfo.getSourceVersion().equals("7x") && !this.commonInfo.getTargetEdition().equals("pe")) {
                dProcessor.processDomainInstances();
            }
        }
        catch (HarnessException he) {
            logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.generalException", (Object)he.getMessage()));
            UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(-1);
            return;
        }
        UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(50);
        int totalIterations = this.getTotalIterationsFromDomainMapping();
        int currentIteration = 0;
        Iterator dItr = this.commonInfo.getDomainMapping().keySet().iterator();
        while (dItr.hasNext()) {
            DomainInfo dInfo = (DomainInfo)this.commonInfo.getDomainMapping().get(dItr.next());
            this.commonInfo.setCurrentDomain(dInfo.getDomainName());
            List instanceList = this.getProcessableInstanceList(dInfo);
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.currentlyProcessingDomain", (Object)dInfo.getDomainName()));
            for (int instIndex = 0; instIndex < instanceList.size(); ++instIndex) {
                String currentInstanceName = (String)instanceList.get(instIndex);
                this.commonInfo.setCurrentSourceInstance(currentInstanceName);
                logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.currentlyProcessingInstance", (Object)currentInstanceName));
                if (this.invokeModules(++currentIteration, totalIterations)) continue;
                return;
            }
        }
        logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.finishedUpgrade"));
        UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(100);
    }

    private int getTotalIterationsFromDomainMapping() {
        int totalIt = 1;
        Iterator dItr = this.commonInfo.getDomainMapping().keySet().iterator();
        while (dItr.hasNext()) {
            DomainInfo dInfo = (DomainInfo)this.commonInfo.getDomainMapping().get(dItr.next());
            List instanceList = this.getProcessableInstanceList(dInfo);
            totalIt += instanceList.size();
        }
        return totalIt;
    }

    private boolean invokeModules(int currentIteration, int totalIterations) {
        String moduleName = "Default";
        ArrayList<BaseModule> successfulModuleList = new ArrayList<BaseModule>();
        int moduleSize = this.moduleList.size();
        int nthModule = 0;
        int progress = 0;
        for (int i = 0; i < moduleSize; ++i) {
            ++nthModule;
            if (!UpdateProgressManager.getProgressManager().canContinueUpgrade()) {
                logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.didNotfinishUpgrade"));
                UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(-1);
                return false;
            }
            BaseModule baseModule = (BaseModule)this.moduleList.get(i);
            moduleName = baseModule.getName();
            if (baseModule.upgrade(this.commonInfo)) {
                successfulModuleList.add(baseModule);
            } else {
                logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.module_upgrade_failed", (Object)moduleName));
                UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
                baseModule.recovery(this.commonInfo);
                for (int k = 0; k < successfulModuleList.size(); ++k) {
                    BaseModule successModule = (BaseModule)successfulModuleList.get(k);
                    logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.module_rollback", (Object)successModule.getName(), (Object)this.commonInfo.getCurrentDomain()));
                    successModule.recovery(this.commonInfo);
                }
            }
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.finishedModule") + moduleName);
            int pFirst = 50 * currentIteration / totalIterations;
            int pLast = 50 / totalIterations - 50 * nthModule / (moduleSize * totalIterations);
            progress = 50 + pFirst - pLast;
            UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(progress);
        }
        return true;
    }

    private void upgradeEESource() {
        int totalIterations = ClustersInfoManager.getClusterInfoManager().getClusterInfoList().size() + UpgradeUtils.getUpgradeUtils(this.commonInfo).getStandAloneInstances(this.commonInfo.getDomainMapping()).size() + 1;
        int currentIteration = 0;
        Iterator dItr = ClustersInfoManager.getClusterInfoManager().getClusterInfoList().iterator();
        while (dItr.hasNext()) {
            ClusterInfo cInfo = (ClusterInfo)dItr.next();
            ClusteredInstance clInstance = cInfo.getMasterInstance();
            if (clInstance == null) {
                clInstance = (ClusteredInstance)cInfo.getClusteredInstanceList().get(0);
            }
            this.commonInfo.setCurrentCluster(cInfo.getClusterName());
            this.commonInfo.setCurrentDomain(clInstance.getDomain());
            this.commonInfo.setCurrentSourceInstance(clInstance.getInstanceName());
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.currentlyProcessingCLUSTER", (Object)cInfo.getClusterName()));
            if (this.invokeModules(++currentIteration, totalIterations)) continue;
            return;
        }
        this.commonInfo.setCurrentCluster(null);
        Iterator sItr = UpgradeUtils.getUpgradeUtils(this.commonInfo).getStandAloneInstances(this.commonInfo.getDomainMapping()).iterator();
        while (sItr.hasNext()) {
            Vector instDInfo = (Vector)sItr.next();
            this.commonInfo.setCurrentDomain(((DomainInfo)instDInfo.elementAt(1)).getDomainName());
            this.commonInfo.setCurrentSourceInstance((String)instDInfo.elementAt(0));
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.currentlyProcessingInstance", (Object)((String)instDInfo.elementAt(0))));
            if (this.invokeModules(++currentIteration, totalIterations)) continue;
            return;
        }
        this.updateMiscellaneousClusterInfo();
        logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.finishedUpgrade"));
        UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(100);
    }

    private void updateMiscellaneousClusterInfo() {
        Hashtable persistenceStoreMapping;
        Hashtable iiopMapping = ClustersInfoManager.getClusterInfoManager().getIIOPClustersMapping();
        if (iiopMapping != null) {
            Iterator it = iiopMapping.keySet().iterator();
            while (it.hasNext()) {
                String domainName = (String)it.next();
                List iCls = (List)iiopMapping.get(domainName);
                String domainXMLfile = this.commonInfo.getDestinationDomainPath(domainName) + File.separator + "config" + File.separator + "domain.xml";
                for (int i = 0; i < iCls.size(); ++i) {
                    IIOPCluster iiopCluster = (IIOPCluster)iCls.get(i);
                    UpgradeUtils.getUpgradeUtils(this.commonInfo).updateDomainXMLWithIIOPCluster(this.commonInfo, domainXMLfile, iiopCluster);
                }
            }
        }
        if ((persistenceStoreMapping = ClustersInfoManager.getClusterInfoManager().getPersistenceStorePropertiesMapping()) != null) {
            Iterator pit = persistenceStoreMapping.keySet().iterator();
            while (pit.hasNext()) {
                String domainName = (String)pit.next();
                Properties props = (Properties)persistenceStoreMapping.get(domainName);
                String domainXMLfile = this.commonInfo.getDestinationDomainPath(domainName) + File.separator + "domain.xml";
                UpgradeUtils.getUpgradeUtils(this.commonInfo).updateDomainXMLWithPersistenceStoreProps(props);
            }
        }
    }

    private List getProcessableInstanceList(DomainInfo dInfo) {
        ArrayList<String> instanceList = new ArrayList<String>();
        List domainInstanceList = dInfo.getInstanceNames();
        if (this.commonInfo.getSourceVersionAndEdition().equals("as80pe") || this.commonInfo.getSourceVersionAndEdition().equals("as81pe")) {
            instanceList.add(new String(""));
            return instanceList;
        }
        for (int i = 0; i < domainInstanceList.size(); ++i) {
            String instanceName = (String)domainInstanceList.get(i);
            if (!this.commonInfo.getSourceVersion().equals("7x") || instanceName.equals("admin-server")) continue;
            instanceList.add(instanceName);
            if (!this.commonInfo.getSourceEdition().equals("pe")) continue;
            if (domainInstanceList.size() <= 2) break;
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.more_thanone_instance", (Object)instanceName));
            break;
        }
        if (instanceList.isEmpty()) {
            logger.log(Level.WARNING, this.stringManager.getString("enterprise.tools.upgrade.no_server_instance", (Object)dInfo.getDomainName()));
        }
        return instanceList;
    }

    private void loadModules() {
        List list = CommonProperties.getRegisteredModules(this.commonInfo);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String moduleClassName = (String)list.get(i);
            try {
                Class<?> cls = Class.forName(moduleClassName);
                BaseModule baseModule = (BaseModule)cls.newInstance();
                this.moduleList.add(baseModule);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.load_instantiate_error", (Object)e.getMessage()), e);
                continue;
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.load_instantiate_error", (Object)e.getMessage()), e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.load_instantiate_error", (Object)e.getMessage()), e);
            }
        }
    }
}

