<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<axsl:stylesheet xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://www.ascc.net/xml/schematron" version="1.0" xmlns:t="http:///xsl-tests" t:dummy-for-xmlns="">
<axsl:output xmlns:m="messages" indent="yes" method="xml"/>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="admin-object-resource">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@jndi-name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="alert-subscription">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="appclient-module">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="application-ref">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@ref"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="audit-module">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="auth-realm">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="cluster-ref">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@ref"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="cluster">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="config">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="connector-connection-pool">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="connector-module">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="connector-resource">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@jndi-name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="custom-resource">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@jndi-name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="ejb-module">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="external-jndi-resource">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@jndi-name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="http-listener">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@id"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="iiop-listener">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@id"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="j2ee-application">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="jacc-provider">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="jdbc-connection-pool">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="jdbc-resource">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@jndi-name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="jms-host">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="jmx-connector">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="lb-config">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="lifecycle-module">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="mail-resource">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@jndi-name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="message-security-config">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@auth-layer"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="node-agent">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="profiler">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="property">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="provider-config">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@provider-id"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="resource-adapter-config">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@resource-adapter-name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="resource-ref">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@ref"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="security-map">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="server">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="server-ref">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@ref"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="system-property">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="thread-pool">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@thread-pool-id"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="virtual-server">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@id"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="web-module">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="schematron-get-full-path" match="persistence-manager-factory-resource">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:value-of select="name()"/>
<axsl:apply-templates mode="sfp" select="@jndi-name"/>
</axsl:template>
<axsl:template xmlns:m="messages" mode="sfp" match="@*">
<axsl:text>[@</axsl:text>
<axsl:value-of select="name()"/>
<axsl:text>='</axsl:text>
<axsl:value-of select="."/>
<axsl:text>']</axsl:text>
</axsl:template>
<axsl:template mode="schematron-get-full-path" match="*|@*">
<axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
<axsl:text>/</axsl:text>
<axsl:if test="count(. | ../@*) = count(../@*)">@</axsl:if>
<axsl:value-of select="name()"/>
<axsl:text>[</axsl:text>
<axsl:value-of select="1+count(preceding-sibling::*[name()=name(current())])"/>
<axsl:text>]</axsl:text>
</axsl:template>
<axsl:key xmlns:m="messages" use="@name" match="cluster" name="clusters"/>
<axsl:key xmlns:m="messages" use="@name" match="config" name="configs"/>
<axsl:key xmlns:m="messages" use="@jndi-name" match="jdbc-resource" name="jdbc-resources"/>
<axsl:key xmlns:m="messages" use="@name" match="server" name="servers"/>
<axsl:key xmlns:m="messages" use="@name" match="applications/*" name="applications"/>
<axsl:key xmlns:m="messages" use="@jndi-name | self::resource-adapter-config/@resource-adapter-name | @name" match="resources/*" name="resources"/>
<axsl:key xmlns:m="messages" use="@name" match="configs/* | servers/* |               clusters/* | node-agents/* | lb-configs/*" name="system-objects"/>
<axsl:template match="/">
<m:messages xmlns:m="messages">
<axsl:apply-templates mode="M1" select="/"/>
<axsl:apply-templates mode="M2" select="/"/>
<axsl:apply-templates mode="M3" select="/"/>
<axsl:apply-templates mode="M4" select="/"/>
</m:messages>
</axsl:template>
<axsl:template mode="M1" priority="-1" match="text()"/>
<axsl:template mode="M2" priority="3999" match="access-log">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3998" match="admin-object-resource">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@jndi-name=current()/@jndi-name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jndiPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-jndiPrimaryKey">
<m:param num="0">
<axsl:value-of select="@jndi-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3997" match="admin-service">
<axsl:choose>
<axsl:when test="not(@system-jmx-connector-name) or jmx-connector[@name=current()/@system-jmx-connector-name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namedChildExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3996" match="alert-service">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3995" match="alert-subscription">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3994" match="appclient-module">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3993" match="application-ref">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@ref=current()/@ref])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="refPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-refPrimaryKey">
<m:param num="0">
<axsl:value-of select="@ref"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(contains('1yestrueon', @enabled)) or key('applications',@ref)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="applicationRef">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="invalid-reference">
<m:param num="0">
<axsl:value-of select="@ref"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(key('applications',@ref)[@object-type='system-admin'])                   or                   key('configs',current()/../@config-ref)/admin-service[@type!='server']                   "/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="adminAppsOnDAS">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(key('applications',@ref)[@object-type='system-instance'])                   or                   key('configs',current()/../@config-ref)/admin-service[@type = 'server']                   "/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="instanceAppsOnServer">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(string(normalize-space(@virtual-servers)))                   or                   count(//virtual-server[ancestor::config[@name=current()/parent::server[not(@name=//cluster/server-ref/@ref)]/@config-ref]][contains(concat(normalize-space(current()/@virtual-servers),','),                            concat(normalize-space(@id), ','))] |                   //virtual-server[ancestor::config[@name=//cluster[server-ref/@ref=current()/../@name]/@config-ref]][contains(current()/@virtual-servers, @id)])=                   string-length(translate(normalize-space(@virtual-servers),                   translate(normalize-space(@virtual-servers), ',', ''),                   ''))+1"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="virtualServersExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3992" match="applications">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3991" match="audit-module">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3990" match="auth-realm">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3989" match="availability-service">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3988" match="backend-principal">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3987" match="cluster-ref">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@ref=current()/@ref])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="refPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-refPrimaryKey">
<m:param num="0">
<axsl:value-of select="@ref"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="key('clusters', @ref)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="referencedClustersMustExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-invalid-cluster-ref">
<m:param num="0">
<axsl:value-of select="../@name"/>
</m:param>
<m:param num="1">
<axsl:value-of select="@ref"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3986" match="cluster">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@config-ref='default-config')"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="noRefsToDefaultConfig">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not (@config-ref) or key('configs',@config-ref)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="referencedConfigsMustExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@name='domain')"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="noClustersNamedDomain">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3985" match="clusters">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3984" match="config">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3983" match="configs">
<axsl:choose>
<axsl:when test="config/admin-service[@type='das-and-server'                   or @type='das']"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="adminServiceMustExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="admin-service-diagnostic"/>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(config/admin-service[@type='das-and-server'                   or @type='das']) &lt; 2"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="onlyOneAdminService">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="admin-service-diagnostic"/>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="config[@name='default-config']"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="defaultConfigMustExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(config[@name='default-config']) &lt; 2"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="onlyOneDefaultConfig">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3982" match="connection-pool">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3981" match="connector-connection-pool">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3980" match="connector-module">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3979" match="connector-resource">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@jndi-name=current()/@jndi-name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jndiPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-jndiPrimaryKey">
<m:param num="0">
<axsl:value-of select="@jndi-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(contains('1yestrueon', @enabled)) or ../connector-connection-pool[@name = current()/@pool-name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="mustReferenceAnExistingConnectionPool">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-invalid-pool-reference">
<m:param num="0">
<axsl:value-of select="@jndi-name"/>
</m:param>
<m:param num="1">
<axsl:value-of select="@pool-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3978" match="connector-service">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3977" match="custom-resource">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@jndi-name=current()/@jndi-name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jndiPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-jndiPrimaryKey">
<m:param num="0">
<axsl:value-of select="@jndi-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3976" match="das-config">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3975" match="description">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3974" match="domain">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3973" match="ejb-container">
<axsl:choose>
<axsl:when test="@steady-pool-size &lt;= @max-pool-size"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="poolSize">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3972" match="ejb-container-availability">
<axsl:choose>
<axsl:when test="not(contains('1yestrueon', ../@availability-enabled) and                  (not(string(@availability-enabled)) or                  contains('1yestrueon', @availability-enabled)) and                  not(string(normalize-space(@sfsb-store-pool-name))))              or key('jdbc-resources', ../@store-pool-name)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="parentPoolExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3971" match="ejb-module">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3970" match="ejb-timer-service">
<axsl:choose>
<axsl:when test="not(@timer-datasource) or key('jdbc-resources',@timer-datasource)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="timerDatasourceExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3969" match="external-jndi-resource">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@jndi-name=current()/@jndi-name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jndiPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-jndiPrimaryKey">
<m:param num="0">
<axsl:value-of select="@jndi-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3968" match="filter-config">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3967" match="health-checker">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3966" match="http-access-log">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3965" match="http-file-cache">
<axsl:choose>
<axsl:when test="@medium-file-size-limit-in-bytes &lt;= @medium-file-space-in-bytes"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="mediumSizeNoGreaterThanSpace">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="@small-file-size-limit-in-bytes &lt;= @small-file-space-in-bytes"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="smallSizeNoGreaterThanSpace">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3964" match="http-listener">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@id=current()/@id])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="idPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-idPrimaryKey">
<m:param num="0">
<axsl:value-of select="@id"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@default-virtual-server) or ../virtual-server[@id = current()/@default-virtual-server]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="defaultVSPeer">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="non-existant-virtual-server-ref">
<m:param num="0">
<axsl:value-of select="@id"/>
</m:param>
<m:param num="1">
<axsl:value-of select="@default-virtual-server"/>
</m:param>
<m:param num="2">
<axsl:value-of select="../../@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(contains('1ontrue', @enabled)) or     ../virtual-server[@id=current()/@default-virtual-server and @state='on']"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="defaultVirtualServerStateCheck">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3963" match="http-protocol">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3962" match="http-service">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3961" match="iiop-listener">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@id=current()/@id])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="idPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-idPrimaryKey">
<m:param num="0">
<axsl:value-of select="@id"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3960" match="iiop-service">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3959" match="j2ee-application">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3958" match="jacc-provider">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3957" match="java-config">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3956" match="jdbc-connection-pool">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="@steady-pool-size &lt;= @max-pool-size"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="poolSize">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@connection-validation-method='table') or @validation-table-name"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="validationMethod">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3955" match="jdbc-resource">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@jndi-name=current()/@jndi-name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jndiPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-jndiPrimaryKey">
<m:param num="0">
<axsl:value-of select="@jndi-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(contains('1yestrueon', @enabled)) or ../jdbc-connection-pool[@name=current()/@pool-name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namedPoolExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3954" match="jms-host">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3953" match="jms-service">
<axsl:choose>
<axsl:when test="jms-host[@name=current()/@default-jms-host]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="defaultJmsHostExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3952" match="jmx-connector">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="../../security-service/auth-realm[@name=current()/@auth-realm-name] |     ../auth-realm[@name=current()/@auth-realm-name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="authRealmExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3951" match="jvm-options">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3950" match="keep-alive">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3949" match="lb-config">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3948" match="lb-configs">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3947" match="lifecycle-module">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3946" match="listener-config">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3945" match="log-service">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3944" match="mail-resource">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@jndi-name=current()/@jndi-name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jndiPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-jndiPrimaryKey">
<m:param num="0">
<axsl:value-of select="@jndi-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3943" match="manager-properties">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3942" match="mdb-container">
<axsl:choose>
<axsl:when test="@steady-pool-size &lt;= @max-pool-size"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="poolSize">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3941" match="message-security-config">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@auth-layer=current()/@auth-layer])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="auth-layer-IsPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="authLayerPrimaryKey">
<m:param num="0">
<axsl:value-of select="@auth-layer"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@default-provider) or provider-config[@name=current()/@default-provider]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="defaultProviderExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3940" match="module-log-levels">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3939" match="module-monitoring-levels">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3938" match="monitoring-service">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3937" match="node-agent">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3936" match="node-agents">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3935" match="orb">
<axsl:choose>
<axsl:when test="     not(string-length(normalize-space(current()/@use-thread-pool-ids)) &gt; 0) or      (count(ancestor::config//thread-pool[contains(concat(normalize-space(current()/@use-thread-pool-ids),','),                                                      concat(normalize-space(@thread-pool-id),','))])                    &gt;=      string-length(        translate(current()/@use-thread-pool-ids,                  translate(current()/@use-thread-pool-ids, ',', ''),                                '')) + 1)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="useThreadPoolsExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="orbLocation">
<m:param num="0">
<axsl:value-of select="ancestor::config/@name"/>
</m:param>
<m:param num="1">
<axsl:value-of select="@use-thread-pool-ids"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3934" match="principal">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3933" match="profiler">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3932" match="property">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3931" match="provider-config">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@ref=current()/@ref])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="providerIdPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-providerIdPrimaryKey">
<m:param num="0">
<axsl:value-of select="@provider-id"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3930" match="request-policy">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3929" match="request-processing">
<axsl:choose>
<axsl:when test="@initial-thread-count &lt;= @thread-count"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="threadCountIsMax">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3928" match="resource-adapter-config">
<axsl:choose>
<axsl:when test="not(preceding-sibling::resource-adapter-config[@resource-adapter-name=current()/@resource-adapter-name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="resource-adapter-name-IsPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(string(normalize-space(@thread-pool-ids)))              or              not(//config[@name=//server[not(@name=//server-ref/@ref)][resource-ref/@ref=current()/@resource-adapter-name]/@config-ref]                   [count(thread-pool[contains(concat(normalize-space(current()/@thread-pool-ids),','),                                                      concat(normalize-space(@thread-pool-id),','))])                           &lt;                           string-length(translate(normalize-space(current()/@thread-pool-ids),                                                   translate(normalize-space(current()/@thread-pool-ids), ',',''),                                         '')) + 1]    |    //config[@name=//cluster[resource-ref/@ref=current()/@resource-adapter-name]/@config-ref]           [count(thread-pool[contains(concat(normalize-space(current()/@thread-pool-ids),','),                                                      concat(normalize-space(@thread-pool-id),','))])                          &lt;                          string-length(translate(normalize-space(current()/@thread-pool-ids),                             translate(normalize-space(current()/@thread-pool-ids), ',',''),                                         '')) + 1]                 )"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="threadPoolsExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3927" match="resource-ref">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@ref=current()/@ref])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="refPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-refPrimaryKey">
<m:param num="0">
<axsl:value-of select="@ref"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(contains('1yestrueon', @enabled)) or     not(key('resources', @ref)[self::connector-connection-pool]     |     key('resources', @ref)[self::jdbc-connection-pool])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="noRefsToPools">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(contains('1yestrueon', @enabled)) or key('resources', @ref)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="resourceRef">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="invalid-reference">
<m:param num="0">
<axsl:value-of select="@ref"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(key('resources',@ref)[@object-type='system-admin'])                   or                   key('configs',current()/../@config-ref)/admin-service[@type!='server']                   "/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="adminResourcesOnDAS">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(key('resources',@ref)[@object-type='system-instance'])                   or                   key('configs',current()/../@config-ref)/admin-service[@type = 'server']                   "/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="instanceResourcesOnServer">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3926" match="resources">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3925" match="response-policy">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3924" match="security-map">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3923" match="security-service">
<axsl:choose>
<axsl:when test="auth-realm[@name=current()/@default-realm]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="referencedRealmExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="jacc-provider[@name=current()/@jacc]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jaccProviderExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(audit-module[contains(concat(',', normalize-space(current()/@audit-modules), ','),                                       concat(',', normalize-space(@name), ','))] |          audit-module[contains(concat(',', normalize-space(current()/@audit-modules), ','),                                       concat(', ', normalize-space(@name), ','))] |          audit-module[contains(concat(',', normalize-space(current()/@audit-modules), ','),                                       concat(',', normalize-space(@name), ' ,'))] |                               audit-module[contains(concat(',', normalize-space(current()/@audit-modules), ','),                                       concat(', ', normalize-space(@name), ' ,'))])           =    string-length(translate(current()/@audit-modules,                            translate(current()/@audit-modules, ',', ''),       '')) + 1"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="auditModulesExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3922" match="server">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@config-ref='default-config')"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="noRefsToDefaultConfig">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not (@config-ref) or key('configs',@config-ref)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="referencedConfigsMustExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@name='agent')"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="noServerCalledAgent">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="                   not(//config[@name=//server[@name=current()/@name][not(//server-ref/@ref=current()/@name)]/@config-ref]/admin-service[@type!='server'] |                       //config[@name=//cluster[server-ref/@ref=current()/@name]/@config-ref]/admin-service[@type!='server'])                         or not(@node-agent-ref)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="dasServerRefsNoNodeAgents">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@node-agent-ref) or //node-agent[@name=current()/@node-agent-ref]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="nodeAgentsExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="non-existant-node-agent-ref">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
<m:param num="1">
<axsl:value-of select="@node-agent-ref"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(//cluster[server-ref/@ref=current()/@name]) &lt; 2"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="notReferencedByTwoClusters">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3921" match="server-ref">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@ref=current()/@ref])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="refPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-refPrimaryKey">
<m:param num="0">
<axsl:value-of select="@ref"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="key('servers', @ref)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="serverRefsExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3920" match="servers">
<axsl:choose>
<axsl:when test="server[@name='server']"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="serverMustExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="count(servers[@name='server']) &lt; 2"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="onlyOneServer">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3919" match="session-config">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3918" match="session-manager">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3917" match="session-properties">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3916" match="ssl">
<axsl:choose>
<axsl:when test="not(parent::iiop-listener) or contains('0noofffalse',@ssl2-enabled)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="NoSSl2CiphersInIIOP">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3915" match="ssl-client-config">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3914" match="store-properties">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3913" match="system-property">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3912" match="thread-pool">
<axsl:choose>
<axsl:when test="not(preceding-sibling::thread-pool[@thread-pool-id=current()/@thread-pool-id])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="thread-pool-id-IsPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="threadPoolPrimaryKey">
<m:param num="0">
<axsl:value-of select="@thread-pool-id"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="@min-thread-pool-size &lt; @max-thread-pool-size"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="minLessThanMax">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3911" match="thread-pools">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3910" match="transaction-service">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3909" match="user-group">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3908" match="virtual-server">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@id=current()/@id])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="idPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-idPrimaryKey">
<m:param num="0">
<axsl:value-of select="@id"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(not(../http-listener[@default-virtual-server=current()/@id])) or     string-length(normalize-space(@http-listeners)) &gt; 0"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="listenersRequiredForNonDefaultVirtualServer">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="     not(string(normalize-space(@http-listeners))) or     (count(../http-listener[contains(concat(normalize-space(current()/@http-listeners),','),                                                         concat(normalize-space(@id),','))])                    =                    string-length(translate(current()/@http-listeners,                                            translate(current()/@http-listeners, ',', ''),                                  '')) + 1)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="httpListenersExist">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@default-web-module) or //web-module[@name=current()/@default-web-module]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="webModuleExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(string(normalize-space(@default-web-module))) or                   //cluster[@config-ref=current()/ancestor::config/@name]/application-ref[@ref=current()/@default-web-module] |                   //server[not(@name=//server-ref/@ref)][@config-ref=current()/ancestor::config/@name]/application-ref[@ref=current()/@default-web-module]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="webModuleCorrectlyDeployed">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="virtualServerLocation">
<m:param num="0">
<axsl:value-of select="ancestor::config/@name"/>
</m:param>
<m:param num="1">
<axsl:value-of select="@id"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diag-webModuleCorrectlyDeployed">
<m:param num="0">
<axsl:value-of select="@default-web-module"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3907" match="web-container">
<axsl:choose>
<axsl:when test="true()"/>
<axsl:otherwise/>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3906" match="web-container-availability">
<axsl:choose>
<axsl:when test="not(contains('1yestrueon', ../@availability-enabled) and                  (not(string(@availability-enabled)) or                  contains('1yestrueon', @availability-enabled)) and                  not(string(normalize-space(@http-session-store-pool-name))))              or key('jdbc-resources', ../@store-pool-name)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="wca-parentPoolExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="3905" match="web-module">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@name=current()/@name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="namePrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-namePrimaryKey">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M2"/>
</axsl:template>
<axsl:template mode="M2" priority="-1" match="text()"/>
<axsl:template mode="M3" priority="3999" match="applications/*">
<axsl:choose>
<axsl:when test="count(key('applications', @name)) = 1"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="applicationNamespace">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-applicationNamespace">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M3"/>
</axsl:template>
<axsl:template mode="M3" priority="3998" match="resources/*">
<axsl:choose>
<axsl:when test="count(key('resources', @name) |                   key('resources', @jndi-name) | key('resources',                   @resource-adapter-name)) = 1"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="resourceNamespace">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M3"/>
</axsl:template>
<axsl:template mode="M3" priority="3997" match="configs/* | servers/* |               clusters/* | node-agents/* | lb-configs/*">
<axsl:choose>
<axsl:when test="count(key('system-objects', @name)) = 1"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="systemNamespace">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-systemNamespace">
<m:param num="0">
<axsl:value-of select="@name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M3"/>
</axsl:template>
<axsl:template mode="M3" priority="-1" match="text()"/>
<axsl:template mode="M4" priority="4000" match="applications/*">
<axsl:choose>
<axsl:when test="//application-ref[@ref=current()/@name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="everyApplicationIsReferenced">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3999" match="availability-service">
<axsl:choose>
<axsl:when test="not(contains('1yestrueon', @availability-enabled))                   or (ejb-container-availability | web-container-availability)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="asHasNoChildren">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3998" match="config[not(@name='default-config')]">
<axsl:choose>
<axsl:when test="//server[not(@name=//server-ref/@ref)][@config-ref=current()/@name] | //cluster[@config-ref=current()/@name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="everyConfigIsReferenced">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3997" match="ejb-container-availability">
<axsl:choose>
<axsl:when test="not((contains('0noofffalse', ../@availability-enabled) or                    (string(@availability-enabled) and                     contains('0noofffalse', @availability-enabled)))                    and                   (string(normalize-space(../@store-pool-name)) and                    not(string(normalize-space(@sfsb-store-pool-name)))))              or key('jdbc-resources', normalize-space(../@store-pool-name))"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="disabledParentPoolExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not((contains('0noofffalse', ../@availability-enabled) or                    (string(@availability-enabled) and        contains('0noofffalse', @availability-enabled)))       and      string(normalize-space(@sfsb-store-pool-name)))    or    key('jdbc-resources', normalize-space(@sfsb-store-pool-name))"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="disabledPoolExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="unknown-sfsb-store-pool-name">
<m:param num="0">
<axsl:value-of select="@sfsb-store-pool-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3996" match="persistence-manager-factory-resource">
<axsl:choose>
<axsl:when test="not(preceding-sibling::*[name()=name(current())][./@jndi-name=current()/@jndi-name])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jndiPrimaryKey">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="diagnostic-jndiPrimaryKey">
<m:param num="0">
<axsl:value-of select="@jndi-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not(@jdbc-resource-jndi-name) or key('jdbc-resources',@jdbc-resource-jndi-name)"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jdbcResourceExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3995" match="web-container-availability">
<axsl:choose>
<axsl:when test="not((contains('0noofffalse', ../@availability-enabled) or                    (string(@availability-enabled) and                     contains('0noofffalse', @availability-enabled)))                    and                   (string(normalize-space(../@store-pool-name)) and                    not(string(normalize-space(@http-session-store-pool-name)))))              or key('jdbc-resources', normalize-space(../@store-pool-name))"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="wca-disabledParentPoolExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:choose>
<axsl:when test="not((contains('0noofffalse', ../@availability-enabled) or                    (string(@availability-enabled) and                     contains('0noofffalse', @availability-enabled)))                    and                  string(normalize-space(@http-session-store-pool-name)))              or key('jdbc-resources', normalize-space(@http-session-store-pool-name))"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="wca-disabledPoolExists">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
<m:param num="1">
<axsl:value-of select="name(.)"/>
</m:param>
</m:message>
<m:message xmlns:m="messages" id="unknown-http-session-store-pool-name">
<m:param num="0">
<axsl:value-of select="@http-session-store-pool-name"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3994" match="resources/*[not(self::jdbc-connection-pool |        self::connector-connection-pool | self::jdbc-resource) ]">
<axsl:choose>
<axsl:when test="(self::resource-adapter-config and //resource-ref[@ref=current()/@resource-adapter-name])           or (not (self::resource-adapter-config) and //resource-ref[@ref=(current()/@name | current()/@jndi-name)])"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="everyResourceIsReferenced">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3993" match="jdbc-connection-pool">
<axsl:choose>
<axsl:when test="../jdbc-resource[@pool-name=current()/@name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jdbcPoolReferenced">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3992" match="connector-connection-pool">
<axsl:choose>
<axsl:when test="../connector-resource[@pool-name=current()/@name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="connPoolReferenced">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="3991" match="jdbc-resource">
<axsl:choose>
<axsl:when test="//resource-ref[@ref=current()/@jndi-name]     | //persistence-manager-factory[@jdbc-resource-jndi-name=current()/@jndi-name]"/>
<axsl:otherwise>
<m:message xmlns:m="messages" id="jdbcResourceIsReferenced">
<m:param num="0">
<axsl:apply-templates select="." mode="schematron-get-full-path"/>
</m:param>
</m:message>
<axsl:text xmlns:m="messages" xml:space="preserve">
</axsl:text>
</axsl:otherwise>
</axsl:choose>
<axsl:apply-templates mode="M4"/>
</axsl:template>
<axsl:template mode="M4" priority="-1" match="text()"/>
<axsl:template priority="-1" match="text()"/>
</axsl:stylesheet>
