/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.naming;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.naming.AdministeredObjectFactory;
import com.sun.messaging.naming.CorruptedConfigurationPropertiesException;
import com.sun.messaging.naming.MissingVersionNumberException;
import com.sun.messaging.naming.UnsupportedVersionNumberException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;

public abstract class CFObjectFactory
extends AdministeredObjectFactory {
    private static final String REF_SECURITYPORT = "securityPort";
    private static final String REF_JMSXUSERID = "JMSXUserID";
    private static final String REF_JMSXAPPID = "JMSXAppID";
    private static final String REF_JMSXPRODUCERTXID = "JMSXProducerTXID";
    private static final String REF_JMSXCONSUMERTXID = "JMSXConsumerTXID";
    private static final String REF_JMSXRCVTIMESTAMP = "JMSXRcvTimestamp";
    private static final String REF_PARM = "parm";
    private static final String REF_HOST = "host";
    private static final String REF_SUBNET = "subnet";
    private static final String REF_ACKTIMEOUT = "ackTimeout";
    private static final String REF_PARM_CONTENT = "--";
    private static final String JMSXUSERID = "JMSXUserID";
    private static final String JMSXAPPID = "JMSXAppID";
    private static final String JMSXPRODUCERTXID = "JMSXProducerTXID";
    private static final String JMSXCONSUMERTXID = "JMSXConsumerTXID";
    private static final String JMSXRCVTIMESTAMP = "JMSXRcvTimestamp";
    private static final String DEFAULT = "default";
    private static final String PREF_HOST = "-s";
    private static final String PREF_SUBNET = "-n";
    private static final String PREF_ACKTIMEOUT = "-t";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_SUBNET = 0;
    private static final int DEFAULT_SECURITYPORT = 22000;
    private static final int DEFAULT_ACKTIMEOUT = 30000;
    static /* synthetic */ Class class$com$sun$messaging$QueueConnectionFactory;
    static /* synthetic */ Class class$com$sun$messaging$TopicConnectionFactory;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object instanceof Reference) {
            ConnectionFactory connectionFactory;
            Object var5_5 = null;
            Object var6_6 = null;
            Object var7_7 = null;
            Object var8_8 = null;
            Reference reference = (Reference)object;
            String string = reference.getClassName();
            if (string.equals((class$com$sun$messaging$QueueConnectionFactory == null ? (class$com$sun$messaging$QueueConnectionFactory = CFObjectFactory.class$("com.sun.messaging.QueueConnectionFactory")) : class$com$sun$messaging$QueueConnectionFactory).getName())) {
                connectionFactory = new QueueConnectionFactory();
            } else if (string.equals((class$com$sun$messaging$TopicConnectionFactory == null ? (class$com$sun$messaging$TopicConnectionFactory = CFObjectFactory.class$("com.sun.messaging.TopicConnectionFactory")) : class$com$sun$messaging$TopicConnectionFactory).getName())) {
                connectionFactory = new TopicConnectionFactory();
            } else {
                throw new MissingVersionNumberException();
            }
            RefAddr refAddr = reference.get("version");
            if (refAddr == null) {
                throw new MissingVersionNumberException();
            }
            String string2 = null;
            string2 = (String)refAddr.getContent();
            if (!"1.1".equals(string2)) {
                throw new UnsupportedVersionNumberException(string2);
            }
            connectionFactory.storedVersion = string2;
            string2 = DEFAULT;
            RefAddr refAddr2 = reference.get(REF_SECURITYPORT);
            if (refAddr2 == null) {
                throw new CorruptedConfigurationPropertiesException();
            }
            string2 = (String)refAddr2.getContent();
            this.recreateConfigurationObject(connectionFactory, reference);
            this.setJMSXProperties(connectionFactory, reference);
            return connectionFactory;
        }
        return null;
    }

    private void recreateConfigurationObject(ConnectionFactory connectionFactory, Reference reference) throws Exception {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            string = (String)reference.get(REF_PARM).getContent();
            string2 = (String)reference.get(REF_HOST).getContent();
            string3 = (String)reference.get(REF_SUBNET).getContent();
            string4 = (String)reference.get(REF_ACKTIMEOUT).getContent();
        }
        catch (NullPointerException nullPointerException) {
            throw new CorruptedConfigurationPropertiesException();
        }
        if (!REF_PARM_CONTENT.equals(string)) {
            return;
        }
        int n = 1;
        if (!DEFAULT.equals(string2)) {
            ++n;
        }
        if (!DEFAULT.equals(string3)) {
            ++n;
        }
        if (!DEFAULT.equals(string4)) {
            ++n;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 1; i < n; ++i) {
            String string5;
            if (!DEFAULT.equals(string2) && !bl) {
                string5 = string2.substring(string2.indexOf(PREF_HOST, 0) + 2, string2.length()).trim();
                connectionFactory.setProperty("imqBrokerHostName", string5);
                bl = true;
                continue;
            }
            if (!DEFAULT.equals(string3) && !bl2) {
                bl2 = true;
                continue;
            }
            if (DEFAULT.equals(string4) || bl3) continue;
            string5 = string4.substring(string4.indexOf(PREF_ACKTIMEOUT, 0) + 2, string4.length()).trim();
            connectionFactory.setProperty("imqAckTimeout", string5);
            bl3 = true;
        }
    }

    private void setJMSXProperties(ConnectionFactory connectionFactory, Reference reference) throws Exception {
        RefAddr refAddr = null;
        refAddr = reference.get("JMSXUserID");
        if (refAddr != null && "true".equals((String)refAddr.getContent())) {
            connectionFactory.setProperty("imqSetJMSXUserID", "true");
        }
        if ((refAddr = reference.get("JMSXAppID")) != null && "true".equals((String)refAddr.getContent())) {
            connectionFactory.setProperty("imqSetJMSXAppID", "true");
        }
        if ((refAddr = reference.get("JMSXProducerTXID")) != null && "true".equals((String)refAddr.getContent())) {
            connectionFactory.setProperty("imqSetJMSXProducerTXID", "true");
        }
        if ((refAddr = reference.get("JMSXConsumerTXID")) != null && "true".equals((String)refAddr.getContent())) {
            connectionFactory.setProperty("imqSetJMSXConsumerTXID", "true");
        }
        if ((refAddr = reference.get("JMSXRcvTimestamp")) != null && "true".equals((String)refAddr.getContent())) {
            connectionFactory.setProperty("imqSetJMSXRcvTimestamp", "true");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

