/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.OnMessageRunner;
import com.sun.messaging.jms.ra.OnMessageRunnerPool;
import java.lang.reflect.Method;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class MessageListener
implements javax.jms.MessageListener {
    private EndpointConsumer epConsumer = null;
    private MessageEndpointFactory epFactory = null;
    private ActivationSpec spec = null;
    private MessageEndpoint msgEndpoint = null;
    private XAResource xar = null;
    private Method onMessage = null;
    private OnMessageRunnerPool omrPool = null;
    private boolean transactedDelivery = false;
    private boolean noAckDelivery = false;

    public MessageListener(EndpointConsumer endpointConsumer, MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        this(endpointConsumer, messageEndpointFactory, activationSpec, false);
    }

    public MessageListener(EndpointConsumer endpointConsumer, MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec, boolean bl) {
        this.epConsumer = endpointConsumer;
        this.epFactory = messageEndpointFactory;
        this.noAckDelivery = bl;
        this.spec = activationSpec;
        this.onMessage = endpointConsumer.getResourceAdapter().getOnMessageMethod();
        this.xar = endpointConsumer.getXASession().getXAResource();
        try {
            this.transactedDelivery = messageEndpointFactory.isDeliveryTransacted(this.onMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void waitForAllOnMessageRunners() throws JMSException {
        if (this.omrPool != null) {
            this.omrPool.waitForAllOnMessageRunners();
        }
    }

    public void releaseOnMessageRunners() {
        if (this.omrPool != null) {
            this.omrPool.releaseOnMessageRunners();
        }
    }

    public void invalidateOnMessageRunners() {
        if (this.omrPool != null) {
            this.omrPool.invalidateOnMessageRunners();
        }
    }

    public void onMessage(Message message) {
        ((MessageImpl)message)._setConsumerInRA();
        if (this.spec._deliverySerial()) {
            this._onMessage(message);
            return;
        }
        if (this.omrPool == null) {
            this.omrPool = new OnMessageRunnerPool(this.epFactory, this.epConsumer, this.spec);
        }
        try {
            OnMessageRunner onMessageRunner = this.omrPool.getOnMessageRunner();
            onMessageRunner.onMessage(message);
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:ML:onMessage:JMSException on getOnMessageRunner");
            jMSException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void _onMessage(Message message) {
        MessageImpl messageImpl = (MessageImpl)message;
        SessionImpl sessionImpl = (SessionImpl)this.epConsumer.getXASession();
        try {
            this.transactedDelivery = this.epFactory.isDeliveryTransacted(this.onMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Object[] objectArray = new Object[]{message};
        this.msgEndpoint = null;
        for (int i = 1; i < 6; ++i) {
            try {
                if (this.epConsumer.deactivated) continue;
                this.msgEndpoint = this.epFactory.createEndpoint(this.xar);
                break;
            }
            catch (UnavailableException unavailableException) {
                try {
                    Thread.sleep(i * 200);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.msgEndpoint == null) {
            System.err.println("MQRA:ML:Endpoint Unavailable:Shutting down delivery for " + this.spec.toString());
            messageImpl._getSession().closeFromRA();
            return;
        }
        ClassLoader classLoader = this.spec.getContextClassLoader();
        int n = this.spec.getEndpointExceptionRedeliveryAttempts();
        int n2 = this.spec.getEndpointExceptionRedeliveryInterval();
        boolean bl = true;
        while (bl) {
            block29: {
                if (this.transactedDelivery) {
                    this.msgEndpoint.beforeDelivery(this.onMessage);
                }
                try {
                    if (classLoader != null) {
                        try {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                        catch (Exception exception) {
                            System.err.println("MQRA:ML:Exception setting ContextClassLoader:" + exception.getMessage());
                        }
                    }
                    ((javax.jms.MessageListener)this.msgEndpoint).onMessage(message);
                    bl = false;
                    try {
                        sessionImpl.acknowledgeFromRAEndpoint(messageImpl);
                    }
                    catch (JMSException jMSException) {
                        System.err.println("MQRA:ML:JMSException on acknowledge");
                    }
                }
                catch (Exception exception) {
                    System.err.println("MQRA:ML:Caught Exception from onMessage():" + exception.getMessage());
                    if (n > 0) {
                        try {
                            Thread.sleep(n2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        --n;
                    }
                    System.err.println("MQRA:ML:Exhausted redeliveryAttempts-shutting down delivery for " + this.spec.toString());
                    bl = false;
                    messageImpl._getSession().closeFromRA();
                }
                if (!this.transactedDelivery) break block29;
                this.msgEndpoint.afterDelivery();
            }
            Object var12_19 = null;
            if (this.msgEndpoint == null) continue;
            try {
                this.msgEndpoint.release();
            }
            catch (Exception exception) {}
            continue;
            {
                catch (Throwable throwable) {
                    System.err.println("MQRA:ML:onMessage caught Throwable-before/on/afterDelivery:Class=" + throwable.getClass().getName() + "Msg=" + throwable.getMessage());
                    bl = false;
                    messageImpl._getSession().closeFromRA();
                    var12_19 = null;
                    if (this.msgEndpoint == null) continue;
                    try {
                        this.msgEndpoint.release();
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var12_19 = null;
                if (this.msgEndpoint != null) {
                    try {
                        this.msgEndpoint.release();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

