/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.ConnectionAdapter;
import com.sun.messaging.jms.ra.ManagedConnection;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;

public class ManagedConnectionMetaData
implements javax.resource.spi.ManagedConnectionMetaData {
    private ManagedConnection mc = null;

    public ManagedConnectionMetaData(ManagedConnection managedConnection) {
        this.mc = managedConnection;
    }

    public String getEISProductName() throws ResourceException {
        try {
            ConnectionAdapter connectionAdapter = this.mc.getConnectionAdapter();
            return connectionAdapter.getMetaData().getJMSProviderName();
        }
        catch (JMSException jMSException) {
            EISSystemException eISSystemException = new EISSystemException("MQRA:MCMD:Failed to get EISProductName");
            eISSystemException.initCause((Throwable)jMSException);
            throw eISSystemException;
        }
    }

    public String getEISProductVersion() throws ResourceException {
        try {
            ConnectionAdapter connectionAdapter = this.mc.getConnectionAdapter();
            return connectionAdapter.getMetaData().getProviderVersion();
        }
        catch (JMSException jMSException) {
            EISSystemException eISSystemException = new EISSystemException("MQRA:MCMD:Failed to get EISProductVersion");
            eISSystemException.initCause((Throwable)jMSException);
            throw eISSystemException;
        }
    }

    public int getMaxConnections() throws ResourceException {
        return 1;
    }

    public String getUserName() throws ResourceException {
        if (this.mc.isDestroyed()) {
            throw new IllegalStateException("MQRA:MCMD:Failed to get UserName-connection destroyed");
        }
        return this.mc.getPasswordCredential().getUserName();
    }
}

