/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForMC;
import com.sun.messaging.jms.ra.ConnectionAdapter;
import com.sun.messaging.jms.ra.ConnectionEventListener;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.LocalTransaction;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import com.sun.messaging.jms.ra.ManagedConnectionMetaData;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.SessionAdapter;
import com.sun.messaging.jms.ra.Util;
import java.io.PrintWriter;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedConnection
implements javax.resource.spi.ManagedConnection {
    private ResourceAdapter ra = null;
    private ManagedConnectionFactory mcf = null;
    private Subject subject = null;
    private ConnectionRequestInfo crInfo = null;
    private ConnectionAdapter ca = null;
    private XAResourceForMC xar = null;
    private ConnectionEventListener evtlistener = null;
    private LocalTransaction localTransaction = null;
    private boolean ltActive = false;
    private ManagedConnectionMetaData mcMetaData = null;
    private PasswordCredential pwCredential = null;
    private SessionAdapter sa = null;
    private boolean destroyed = false;
    private PrintWriter logWriter = null;
    private transient int mcId = ++idCounter;
    private static int idCounter = 0;

    public ManagedConnection(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo connectionRequestInfo, ResourceAdapter resourceAdapter) throws ResourceException {
        XAConnectionImpl xAConnectionImpl;
        this.mcf = managedConnectionFactory;
        this.subject = subject;
        this.crInfo = connectionRequestInfo;
        this.ra = resourceAdapter;
        this.pwCredential = Util.getPasswordCredential(managedConnectionFactory, subject, connectionRequestInfo);
        if (this.pwCredential != null) {
            try {
                xAConnectionImpl = (XAConnectionImpl)managedConnectionFactory._getXACF().createXAConnection(this.pwCredential.getUserName(), new String(this.pwCredential.getPassword()));
            }
            catch (JMSException jMSException) {
                String string = "MQRA:MC:Constr:Exception on cnxn creation-" + jMSException.getMessage();
                System.err.println(string);
                jMSException.printStackTrace();
                throw new ResourceAdapterInternalException(string, (Throwable)jMSException);
            }
        }
        try {
            xAConnectionImpl = (XAConnectionImpl)managedConnectionFactory._getXACF().createXAConnection(managedConnectionFactory.getUserName(), managedConnectionFactory.getPassword());
        }
        catch (JMSException jMSException) {
            String string = "MQRA:MC:Constr:Exception on cnxn creation-" + jMSException.getMessage();
            System.err.println(string);
            jMSException.printStackTrace();
            throw new ResourceAdapterInternalException(string, (Throwable)jMSException);
        }
        this.evtlistener = new ConnectionEventListener(this);
        try {
            xAConnectionImpl._setExceptionListenerFromRA(this.evtlistener);
        }
        catch (JMSException jMSException) {
            String string = "MQRA:MC:Constr:Exception on setExceptionListener-" + jMSException.getMessage();
            throw new ResourceAdapterInternalException("MQRA:MC:JMSException upon setExceptionListener", (Throwable)jMSException);
        }
        this.ca = new ConnectionAdapter(this, xAConnectionImpl, resourceAdapter);
        try {
            this.xar = new XAResourceForMC(this, xAConnectionImpl, xAConnectionImpl);
        }
        catch (JMSException jMSException) {
            String string = "MQRA:MC:Constr:Exception on xar creation-" + jMSException.getMessage();
            System.err.println(string);
            jMSException.printStackTrace();
            throw new ResourceAdapterInternalException(string, (Throwable)jMSException);
        }
        this.logWriter = null;
        this.mcMetaData = new ManagedConnectionMetaData(this);
        this.localTransaction = new LocalTransaction(this, xAConnectionImpl);
    }

    public void addConnectionEventListener(javax.resource.spi.ConnectionEventListener connectionEventListener) {
        this.evtlistener.addConnectionEventListener(connectionEventListener);
    }

    public void removeConnectionEventListener(javax.resource.spi.ConnectionEventListener connectionEventListener) {
        this.evtlistener.removeConnectionEventListener(connectionEventListener);
    }

    public void cleanup() throws ResourceException {
        this.checkDestroyed();
        if (this.ca != null) {
            this.ca.cleanup();
        }
    }

    public void destroy() throws ResourceException {
        if (this.destroyed) {
            return;
        }
        if (this.ca != null) {
            this.ca.destroy();
        }
        this.destroyed = true;
    }

    public XAResource getXAResource() throws ResourceException {
        this.checkDestroyed();
        return this.xar;
    }

    public javax.resource.spi.LocalTransaction getLocalTransaction() throws ResourceException {
        this.checkDestroyed();
        return this.localTransaction;
    }

    public javax.resource.spi.ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkDestroyed();
        return this.mcMetaData;
    }

    public Object getConnection(Subject subject, javax.resource.spi.ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ConnectionRequestInfo connectionRequestInfo2 = (ConnectionRequestInfo)connectionRequestInfo;
        this.checkDestroyed();
        PasswordCredential passwordCredential = Util.getPasswordCredential(this.mcf, subject, connectionRequestInfo2);
        if (!Util.isPasswordCredentialEqual(passwordCredential, this.pwCredential)) {
            throw new SecurityException("MQRA:MC:getConnection-auth failed for Subject-" + (subject != null ? subject.toString() : "null-subject"));
        }
        String string = this.mcf.getClientId();
        if (string != null) {
            try {
                this.ca.open(string);
            }
            catch (InvalidClientIDException invalidClientIDException) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:MC:InvalidClientIDException-" + invalidClientIDException.getMessage());
                eISSystemException.initCause((Throwable)invalidClientIDException);
                throw eISSystemException;
            }
            catch (JMSException jMSException) {
                EISSystemException eISSystemException = new EISSystemException("MQRA:MC:JMSException-" + jMSException.getMessage());
                eISSystemException.initCause((Throwable)jMSException);
                throw eISSystemException;
            }
        } else {
            this.ca.open();
        }
        return this.ca;
    }

    public void associateConnection(Object object) throws ResourceException {
        this.checkDestroyed();
        if (!(object instanceof ConnectionAdapter)) {
            throw new ResourceException("MQRA:MC:associateConnection-invalid connection:class=" + object.getClass() + ":toString=" + object.toString());
        }
        ConnectionAdapter connectionAdapter = (ConnectionAdapter)object;
        connectionAdapter.associateManagedConnection(this);
        this.ca = connectionAdapter;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public int getMCId() {
        return this.mcId;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public PasswordCredential getPasswordCredential() {
        return this.pwCredential;
    }

    public ConnectionAdapter getConnectionAdapter() {
        return this.ca;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean xaTransactionStarted() {
        if (this.ltActive) {
            return this.localTransaction.started();
        }
        return this.xar.started();
    }

    public boolean xaTransactionActive() {
        if (this.ltActive) {
            return this.localTransaction.isActive();
        }
        return this.xar.isActive();
    }

    public long getTransactionID() {
        if (this.ltActive) {
            return this.localTransaction.getTransactionID();
        }
        return this.xar.getTransactionID();
    }

    public void setLTActive(boolean bl) {
        this.ltActive = bl;
    }

    public void sendEvent(int n, Exception exception) {
        this.evtlistener.sendEvent(n, exception, null);
    }

    public void sendEvent(int n, Exception exception, Object object) {
        this.evtlistener.sendEvent(n, exception, object);
    }

    private void checkDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException("MQRA:MC:Destroyed-Id=" + this.mcId);
        }
    }
}

