/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XAQueueSessionImpl;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.jmsclient.XATopicSessionImpl;
import com.sun.messaging.jms.IllegalStateException;
import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.SessionAdapter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.resource.ResourceException;

public class ConnectionAdapter
implements Connection,
QueueConnection,
TopicConnection {
    private ResourceAdapter ra = null;
    private ManagedConnection mc = null;
    public XAConnectionImpl xac = null;
    private SessionAdapter sa = null;
    private boolean sessions_allowed = true;
    private Set sessions = null;
    private boolean destroyed = false;
    private boolean closed = false;
    private boolean inACC = true;

    public ConnectionAdapter(ManagedConnection managedConnection, XAConnectionImpl xAConnectionImpl, ResourceAdapter resourceAdapter) {
        this.mc = managedConnection;
        this.xac = xAConnectionImpl;
        this.ra = resourceAdapter;
        this.sessions = new HashSet();
        if (resourceAdapter != null) {
            this.inACC = resourceAdapter.getInAppClientContainer();
            if (resourceAdapter.getInClusteredContainer()) {
                xAConnectionImpl.setRANamespaceUID(resourceAdapter._getRAUID());
            }
        }
    }

    public void setClientID(String string) throws javax.jms.JMSException {
        if (!this.inACC) {
            throw new JMSException("MQRA:CA:Unsupported-setClientID()");
        }
        this.checkClosed();
        this.xac.setClientID(string);
    }

    public String getClientID() throws javax.jms.JMSException {
        this.checkClosed();
        return this.xac.getClientID();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws javax.jms.JMSException {
        if (!this.inACC) {
            throw new JMSException("MQRA:CA:Unsupported-setClientID()");
        }
        this.checkClosed();
        this.xac.setExceptionListener(exceptionListener);
    }

    public ExceptionListener getExceptionListener() throws javax.jms.JMSException {
        this.checkClosed();
        return this.xac.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws javax.jms.JMSException {
        this.checkClosed();
        return this.xac.getMetaData();
    }

    public void start() throws javax.jms.JMSException {
        this.checkClosed();
        this.xac.start();
    }

    public void stop() throws javax.jms.JMSException {
        if (!this.inACC) {
            throw new JMSException("MQRA:CA:Unsupported-stop()");
        }
        this.checkClosed();
        this.xac.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws javax.jms.JMSException {
        ConnectionAdapter connectionAdapter = this;
        synchronized (connectionAdapter) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.xac._isClosed()) {
                this.xac.stop();
            }
            Set set = this.sessions;
            synchronized (set) {
                Iterator iterator = this.sessions.iterator();
                while (iterator.hasNext()) {
                    SessionAdapter sessionAdapter = (SessionAdapter)iterator.next();
                    if (sessionAdapter == null) continue;
                    sessionAdapter.closeAdapter();
                }
                this.sessions.clear();
                this.sessions_allowed = true;
                this.sa = null;
            }
            try {
                this.xac._closeForPooling();
            }
            catch (javax.jms.JMSException jMSException) {
                System.err.println("MQRA:CA:close:Got JMSExc during _closeForPooling:ignoring:" + jMSException.getMessage());
                jMSException.printStackTrace();
            }
            this.mc.sendEvent(1, null, this);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws javax.jms.JMSException {
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("createConnectionConsumer");
        String string2 = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createConnectionConsumer", string2, unsupportedOperationException);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws javax.jms.JMSException {
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("createConnectionConsumer");
        String string2 = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createConnectionConsumer", string2, unsupportedOperationException);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws javax.jms.JMSException {
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("createConnectionConsumer");
        String string2 = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createConnectionConsumer", string2, unsupportedOperationException);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws javax.jms.JMSException {
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("createConnectionConsumer");
        String string3 = "2";
        this.checkClosed();
        throw new JMSException("MQRA:CA:Unsupported-createDurableConnectionConsumer", string3, unsupportedOperationException);
    }

    public Session createSession(boolean bl, int n) throws javax.jms.JMSException {
        this.checkClosed();
        if (!this.sessions_allowed) {
            throw new JMSException("MQRA:CA:createSession failed-Only one JMS Session allowed when managed connection is involved in a transaction");
        }
        try {
            if (!this.inACC && this.mc.xaTransactionActive()) {
                this.sessions_allowed = false;
            }
        }
        catch (Exception exception) {
            this.sessions_allowed = false;
        }
        XASessionImpl xASessionImpl = (XASessionImpl)this.xac.createSession(this.mc.xaTransactionStarted() ? true : bl, n, this.inACC ? null : this.mc);
        SessionAdapter sessionAdapter = new SessionAdapter(this, this.xac, xASessionImpl);
        this.addSessionAdapter(sessionAdapter);
        return sessionAdapter;
    }

    public QueueSession createQueueSession(boolean bl, int n) throws javax.jms.JMSException {
        this.checkClosed();
        if (!this.sessions_allowed) {
            throw new JMSException("MQRA:CA:createQueueSession failed-Only one JMS Session allowed when managed connection is involved in a transaction");
        }
        try {
            if (!this.inACC && this.mc.xaTransactionActive()) {
                this.sessions_allowed = false;
            }
        }
        catch (Exception exception) {
            this.sessions_allowed = false;
        }
        XAQueueSessionImpl xAQueueSessionImpl = (XAQueueSessionImpl)this.xac.createQueueSession(this.mc.xaTransactionStarted() ? true : bl, n, this.inACC ? null : this.mc);
        SessionAdapter sessionAdapter = new SessionAdapter(this, this.xac, xAQueueSessionImpl);
        sessionAdapter.setQueueSession();
        this.addSessionAdapter(sessionAdapter);
        return sessionAdapter;
    }

    public TopicSession createTopicSession(boolean bl, int n) throws javax.jms.JMSException {
        this.checkClosed();
        if (!this.sessions_allowed) {
            throw new JMSException("MQRA:CA:createTopicSession failed-Only one JMS Session allowed when managed connection is involved in a transaction");
        }
        try {
            if (!this.inACC && this.mc.xaTransactionActive()) {
                this.sessions_allowed = false;
            }
        }
        catch (Exception exception) {
            this.sessions_allowed = false;
        }
        XATopicSessionImpl xATopicSessionImpl = (XATopicSessionImpl)this.xac.createTopicSession(this.mc.xaTransactionStarted() ? true : bl, n, this.inACC ? null : this.mc);
        SessionAdapter sessionAdapter = new SessionAdapter(this, this.xac, xATopicSessionImpl);
        sessionAdapter.setTopicSession();
        this.addSessionAdapter(sessionAdapter);
        return sessionAdapter;
    }

    void checkClosed() throws javax.jms.JMSException {
        if (this.closed) {
            throw new IllegalStateException("MQRA:CA:Illegal:Connection is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSessionAdapter(SessionAdapter sessionAdapter) {
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.add(sessionAdapter);
            if (this.sa == null) {
                this.sa = sessionAdapter;
            }
            if (!this.inACC) {
                this.sessions_allowed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSessionAdapter(SessionAdapter sessionAdapter) {
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.remove(sessionAdapter);
            if (!this.sessions_allowed && this.sessions.isEmpty()) {
                this.sessions_allowed = true;
                this.sa = null;
            }
        }
    }

    public void associateManagedConnection(ManagedConnection managedConnection) throws ResourceException {
        if (this.destroyed) {
            System.err.println("MQRA:CA:associateMC:cnxn is destroyed. DebugState=" + this.xac.getDebugState(false).toString());
            throw new javax.resource.spi.IllegalStateException("MQRA:CA:unable to associate ManagedConnection - Connection is destoryed");
        }
        if (managedConnection != null) {
            this.mc = managedConnection;
        }
    }

    public void destroy() {
        try {
            this.xac.close();
        }
        catch (javax.jms.JMSException jMSException) {
            System.err.println("MQRA:CA:destroy:Exception on phys cnxn close-ignoring:" + jMSException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Set set = this.sessions;
        synchronized (set) {
            Iterator iterator = this.sessions.iterator();
            while (iterator.hasNext()) {
                SessionAdapter sessionAdapter = (SessionAdapter)iterator.next();
                if (sessionAdapter == null) continue;
                sessionAdapter.closeAdapter();
            }
            this.sessions.clear();
            this.sessions_allowed = true;
            this.sa = null;
        }
    }

    public SessionAdapter getSessionAdapter() {
        return this.sa;
    }

    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string) throws javax.jms.JMSException {
        ConnectionAdapter connectionAdapter = this;
        synchronized (connectionAdapter) {
            this.xac._setClientID(string);
            this.closed = false;
        }
    }

    public void open() {
        this.closed = false;
    }
}

