/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public abstract class MultiColumnPrinter {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    private static final boolean DEFAULT_SORT = true;
    private int numCol = 2;
    private int gap = 4;
    private int align = 1;
    private int titleAlign = 1;
    private String border = null;
    private int indent = 0;
    private Vector table = new Vector();
    private Vector titleTable = new Vector();
    private Vector titleSpanTable = new Vector();
    private int[] curLength;
    private boolean sortNeeded = true;
    private int[] keyCriteria = null;

    public MultiColumnPrinter(int n, int n2, String string, int n3, boolean bl) {
        this.curLength = new int[n];
        this.numCol = n;
        this.gap = n2;
        this.border = string;
        this.align = n3;
        this.titleAlign = 0;
        this.sortNeeded = bl;
    }

    public MultiColumnPrinter(int n, int n2, String string, int n3) {
        this(n, n2, string, n3, true);
    }

    public MultiColumnPrinter(int n, int n2, String string) {
        this(n, n2, string, 0);
    }

    public MultiColumnPrinter(int n, int n2) {
        this(n, n2, null, 0);
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void setSortNeeded(boolean bl) {
        this.sortNeeded = bl;
    }

    public void addTitle(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = 1;
        }
        this.addTitle(stringArray, nArray);
    }

    public void addTitle(String[] stringArray, int[] nArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        this.titleTable.addElement(stringArray2);
        this.titleSpanTable.addElement(nArray);
    }

    public void setTitleAlign(int n) {
        this.titleAlign = n;
    }

    public void add(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        this.table.addElement(objectArray2);
    }

    public void clearTitle() {
        this.titleTable.clear();
        this.titleSpanTable.clear();
    }

    public void clear() {
        this.table.clear();
        if (this.curLength != null) {
            for (int i = 0; i < this.curLength.length; ++i) {
                this.curLength[i] = 0;
            }
        }
    }

    public void print() {
        this.print(true);
    }

    public void print(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object[] objectArray;
        Enumeration enumeration = this.titleTable.elements();
        Enumeration enumeration2 = this.titleSpanTable.elements();
        int n6 = 0;
        while (enumeration.hasMoreElements()) {
            objectArray = (String[])enumeration.nextElement();
            int[] nArray = (int[])enumeration2.nextElement();
            for (n5 = 0; n5 < this.numCol; ++n5) {
                if (objectArray[n5] == null) {
                    objectArray[n5] = "-";
                }
                n4 = this.getItemLength(objectArray[n5]);
                n3 = nArray[n5];
                n2 = 0;
                if (n3 > 1) {
                    n2 = n4 % n3;
                    n4 /= n3;
                }
                if (this.curLength[n5] >= n4) continue;
                this.curLength[n5] = n4;
                if (n3 <= 1 || n5 + n3 > this.numCol) continue;
                for (n = n5 + 1; n < n5 + n3; ++n) {
                    this.curLength[n] = n4;
                }
                int n7 = n5 + n3 - 1;
                this.curLength[n7] = this.curLength[n7] + n2;
            }
            ++n6;
        }
        enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            for (int i = 0; i < this.numCol; ++i) {
                if (objectArray[i] == null) {
                    objectArray[i] = "-";
                }
                if (this.curLength[i] >= (n5 = this.getItemLength(objectArray[i]))) continue;
                this.curLength[i] = n5;
            }
        }
        if (bl) {
            this.printBorder();
            enumeration = this.titleTable.elements();
            enumeration2 = this.titleSpanTable.elements();
            this.printSpaces(this.indent);
            while (enumeration.hasMoreElements()) {
                objectArray = (Object[])enumeration.nextElement();
                int[] nArray = (int[])enumeration2.nextElement();
                for (n5 = 0; n5 < this.numCol; ++n5) {
                    n4 = 0;
                    n3 = nArray[n5];
                    n2 = this.getItemLength(objectArray[n5]);
                    if (n3 == 0) continue;
                    n4 = this.curLength[n5];
                    if (n3 > 1 && n5 + n3 <= this.numCol) {
                        for (n = n5 + 1; n < n5 + n3; ++n) {
                            n4 += this.gap;
                            n4 += this.curLength[n];
                        }
                    }
                    if (this.titleAlign == 1) {
                        n = (n4 - n2) / 2;
                        int n8 = n4 - n2 - n;
                        this.printSpaces(n);
                        this.doPrint(this.getItemString(objectArray[n5]));
                        this.printSpaces(n8);
                        if (n5 >= this.numCol - 1) continue;
                        this.printSpaces(this.gap);
                        continue;
                    }
                    this.doPrint(this.getItemString(objectArray[n5]));
                    if (n5 >= this.numCol - 1) continue;
                    this.printSpaces(n4 - n2 + this.gap);
                }
                this.doPrintln("");
            }
            this.printBorder();
        }
        if (this.sortNeeded) {
            this.printSortedTable();
        } else {
            this.printUnsortedTable();
        }
    }

    private void printSortedTable() {
        Object object;
        Object object2;
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Object[])enumeration.nextElement();
            if (this.keyCriteria != null && this.keyCriteria.length > 0) {
                object = this.getKey((Object[])object2);
                if (object != null) {
                    treeMap.put(object, object2);
                    continue;
                }
                treeMap.put(object2[0], object2);
                continue;
            }
            treeMap.put(object2[0], object2);
        }
        object2 = treeMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            Object[] objectArray = (Object[])object.getValue();
            this.printRow(objectArray);
        }
    }

    private String getKey(Object[] objectArray) {
        String string = "";
        for (int i = 0; i < this.keyCriteria.length; ++i) {
            int n = this.keyCriteria[i];
            try {
                string = string + this.getItemString(objectArray[n]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        return string;
    }

    private void printUnsortedTable() {
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            this.printRow(objectArray);
        }
    }

    private void printRow(Object[] objectArray) {
        int n = 0;
        this.printSpaces(this.indent);
        n += this.indent;
        boolean bl = true;
        for (int i = 0; i < this.numCol; ++i) {
            int n2 = this.getItemLength(objectArray[i]);
            if (this.align == 1) {
                int n3 = (this.curLength[i] - n2) / 2;
                int n4 = this.curLength[i] - n2 - n3;
                this.printSpaces(n3);
                bl = this.printObject(objectArray[i], n += n3);
                n += n2;
                this.printSpaces(n4);
                n += n4;
                if (i >= this.numCol - 1) continue;
                this.printSpaces(this.gap);
                n += this.gap;
                continue;
            }
            bl = this.printObject(objectArray[i], n);
            n += n2;
            if (i >= this.numCol - 1) continue;
            this.printSpaces(this.curLength[i] - n2 + this.gap);
            n += this.curLength[i] - n2 + this.gap;
        }
        if (bl) {
            this.doPrintln("");
        }
    }

    public void println() {
        this.print();
        this.doPrintln("");
    }

    private void printSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            this.doPrint(" ");
        }
    }

    private void printBorder() {
        int n;
        int n2;
        boolean bl = true;
        if (this.border == null) {
            return;
        }
        this.printSpaces(this.indent);
        for (n2 = 0; n2 < this.numCol; ++n2) {
            for (n = 0; n < this.curLength[n2]; ++n) {
                this.doPrint(this.border);
            }
        }
        for (n2 = 0; n2 < this.numCol - 1; ++n2) {
            for (n = 0; n < this.gap; ++n) {
                this.doPrint(this.border);
            }
        }
        this.doPrintln("");
    }

    private String getItemString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        String string = object.getClass().getName();
        return string;
    }

    private int getItemLength(Object object) {
        int n = 0;
        if (object instanceof String) {
            n = ((String)object).length();
        } else {
            String string = object.getClass().getName();
            n = string.length();
        }
        return n;
    }

    public boolean printObject(Object object, int n) {
        if (object instanceof String) {
            this.doPrint((String)object);
        } else {
            String string = object.getClass().getName();
            this.doPrintln(string);
            this.printSpaces(n);
            this.doPrint(object.toString());
        }
        return true;
    }

    public void setKeyCriteria(int[] nArray) {
        this.keyCriteria = nArray;
    }

    public abstract void doPrint(String var1);

    public abstract void doPrintln(String var1);
}

