/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HttpTunnelPacket {
    protected static final short VERSION = 100;
    protected static final int HEADER_SIZE = 24;
    protected short version = (short)100;
    protected short packetType = 0;
    protected int packetSize = 0;
    protected int connId = 0;
    protected int sequence = 0;
    protected short winsize = 0;
    protected short reserved = 0;
    protected int checksum = 0;
    protected byte[] headerBuffer = new byte[24];
    protected byte[] packetBuffer = null;
    protected boolean dirty = false;

    private void parseHeader(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.version = dataInputStream.readShort();
        if (this.version > 100) {
            throw new IllegalStateException("Bad response format. Check the tunnel servlet URL.");
        }
        this.packetType = dataInputStream.readShort();
        this.packetSize = dataInputStream.readInt();
        this.connId = dataInputStream.readInt();
        this.sequence = dataInputStream.readInt();
        this.winsize = dataInputStream.readShort();
        this.reserved = dataInputStream.readShort();
        this.checksum = dataInputStream.readInt();
    }

    private void updateBuffers() throws IOException {
        if (!this.dirty) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(this.version);
        dataOutputStream.writeShort(this.packetType);
        dataOutputStream.writeInt(this.packetSize);
        dataOutputStream.writeInt(this.connId);
        dataOutputStream.writeInt(this.sequence);
        dataOutputStream.writeShort(this.winsize);
        dataOutputStream.writeShort(this.reserved);
        dataOutputStream.writeInt(this.checksum);
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        this.headerBuffer = byteArrayOutputStream.toByteArray();
        this.dirty = false;
    }

    public void readPacket(InputStream inputStream) throws IOException, EOFException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(this.headerBuffer);
        this.parseHeader(new ByteArrayInputStream(this.headerBuffer));
        this.packetBuffer = new byte[this.packetSize - 24];
        dataInputStream.readFully(this.packetBuffer);
    }

    public void writePacket(OutputStream outputStream) throws IOException {
        this.updateBuffers();
        outputStream.write(this.headerBuffer, 0, 24);
        if (this.packetBuffer != null) {
            outputStream.write(this.packetBuffer, 0, this.packetSize - 24);
        }
        outputStream.flush();
    }

    public int getPacketType() {
        return this.packetType;
    }

    public byte[] getPacketBody() {
        return this.packetBuffer;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getPacketDataSize() {
        return this.packetSize - 24;
    }

    public int getConnId() {
        return this.connId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getWinsize() {
        return this.winsize;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setPacketType(int n) {
        this.packetType = (short)n;
        this.dirty = true;
    }

    public void setPacketBody(byte[] byArray) {
        this.packetBuffer = byArray;
        this.packetSize = 24;
        if (this.packetBuffer != null) {
            this.packetSize += this.packetBuffer.length;
        }
        this.dirty = true;
    }

    public void setConnId(int n) {
        this.connId = n;
        this.dirty = true;
    }

    public void setSequence(int n) {
        this.sequence = n;
        this.dirty = true;
    }

    public void setWinsize(int n) {
        this.winsize = (short)n;
        this.dirty = true;
    }

    public void setChecksum(int n) {
        this.checksum = n;
        this.dirty = true;
    }

    public String toString() {
        String string = "\nVersion = " + this.version + "\npacketType = " + this.packetType + "\npacketSize = " + this.packetSize + "\nconnId = " + this.connId + "\nsequence = " + this.sequence + "\nwinsize = " + this.winsize + "\nreserved = " + this.reserved + "\nchecksum = " + this.checksum;
        if (this.packetBuffer != null) {
            string = string + "\nDATA = \"" + new String(this.packetBuffer) + "\"\n";
        }
        return string;
    }
}

