/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.http;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.JMSException;

public class HTTPConnectionHandler
implements ConnectionHandler {
    private HttpTunnelSocket socket = null;
    private String URLString = null;

    public HTTPConnectionHandler(Object object) throws JMSException {
        ConnectionImpl connectionImpl = (ConnectionImpl)object;
        this.URLString = connectionImpl.getProperty("imqConnectionURL");
        if (this.URLString == null) {
            throw new JMSException("imqConnectionURL property not found.");
        }
        try {
            this.socket = new HttpTunnelSocket(this.URLString);
        }
        catch (Exception exception) {
            connectionImpl.getExceptionHandler().handleConnectException(exception, this.URLString);
        }
    }

    public HTTPConnectionHandler(MQAddress mQAddress, ConnectionImpl connectionImpl) throws JMSException {
        ConnectionImpl connectionImpl2 = connectionImpl;
        this.URLString = mQAddress.getURL();
        if (this.URLString == null) {
            throw new JMSException("URL not found.");
        }
        try {
            this.socket = new HttpTunnelSocket(this.URLString);
        }
        catch (Exception exception) {
            connectionImpl2.getExceptionHandler().handleConnectException(exception, this.URLString);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public int getLocalPort() throws IOException {
        return this.socket.getConnId();
    }

    public void close() throws IOException {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            throw iOException;
        }
    }

    public String getBrokerHostName() {
        return this.URLString;
    }

    public String getBrokerAddress() {
        return this.URLString;
    }
}

