/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.BasicQueue;
import com.sun.messaging.BasicTopic;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.QueueBrowserImpl;
import com.sun.messaging.jmq.jmsclient.QueueReceiverImpl;
import com.sun.messaging.jmq.jmsclient.QueueSenderImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryQueueImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryTopicImpl;
import com.sun.messaging.jmq.jmsclient.TopicPublisherImpl;
import com.sun.messaging.jmq.jmsclient.TopicSubscriberImpl;
import com.sun.messaging.jms.Session;
import com.sun.messaging.jms.ra.ManagedConnection;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;

public class UnifiedSessionImpl
extends SessionImpl
implements Session {
    public UnifiedSessionImpl(ConnectionImpl connectionImpl, boolean bl, int n) throws JMSException {
        super(connectionImpl, bl, n);
    }

    public UnifiedSessionImpl(ConnectionImpl connectionImpl, boolean bl, int n, ManagedConnection managedConnection) throws JMSException {
        super(connectionImpl, bl, n, managedConnection);
    }

    public UnifiedSessionImpl(ConnectionImpl connectionImpl, int n) throws JMSException {
        super(connectionImpl, n);
    }

    public Queue createQueue(String string) throws JMSException {
        this.checkSessionState();
        return new BasicQueue(string);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueReceiverImpl((SessionImpl)this, queue);
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        this.checkSessionState();
        return new QueueReceiverImpl(this, queue, string);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueSenderImpl((SessionImpl)this, queue);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkSessionState();
        return new QueueBrowserImpl(this, queue);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        this.checkSessionState();
        return new QueueBrowserImpl(this, queue, string);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkSessionState();
        return new TemporaryQueueImpl(this.connection);
    }

    public Topic createTopic(String string) throws JMSException {
        this.checkSessionState();
        return new BasicTopic(string);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkSessionState();
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        this.checkSessionState();
        return new TopicSubscriberImpl((SessionImpl)this, topic, string, bl);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        this.checkSessionState();
        this.checkTemporaryDestination(topic);
        this.checkClientIDWithBroker();
        return new TopicSubscriberImpl(this, topic, string);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        this.checkSessionState();
        this.checkTemporaryDestination(topic);
        this.checkClientIDWithBroker();
        return new TopicSubscriberImpl(this, topic, string, string2, bl);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkSessionState();
        return new TopicPublisherImpl((SessionImpl)this, topic);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkSessionState();
        return new TemporaryTopicImpl(this.connection);
    }

    public void unsubscribe(String string) throws JMSException {
        MessageConsumerImpl messageConsumerImpl = null;
        boolean bl = false;
        this.checkSessionState();
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            messageConsumerImpl = (MessageConsumerImpl)enumeration.nextElement();
            if (!messageConsumerImpl.getDurable() || !messageConsumerImpl.getDurableName().equals(string)) continue;
            String string2 = AdministeredObject.cr.getKString("C4007", messageConsumerImpl.getDurableName());
            throw new JMSException(string2, "C4007");
        }
        this.checkClientIDWithBroker();
        this.connection.unsubscribe(string);
        bl = true;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination == null) {
            return new MessageProducerImpl(this, destination);
        }
        if (destination instanceof Queue) {
            return this.createSender((Queue)destination);
        }
        if (destination instanceof Topic) {
            return this.createPublisher((Topic)destination);
        }
        String string = AdministeredObject.cr.getKString("C4068", destination.getClass().getName());
        throw new JMSException(string, "C4068");
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        return this.createConsumer(destination, string, false);
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        if (destination == null) {
            String string2 = AdministeredObject.cr.getKString("C4019", "null");
            throw new InvalidDestinationException(string2, "C4019");
        }
        if (destination instanceof Queue) {
            return this.createReceiver((Queue)destination, string);
        }
        if (destination instanceof Topic) {
            return this.createSubscriber((Topic)destination, string, bl);
        }
        String string3 = AdministeredObject.cr.getKString("C4068", destination.getClass().getName());
        throw new JMSException(string3, "C4068");
    }

    protected void checkClientIDWithBroker() throws JMSException {
        String string = this.connection.getClientID();
        if (string == null) {
            String string2 = AdministeredObject.cr.getKString("C4053", "\"\"");
            throw new JMSException(string2, "C4053");
        }
        this.connection.getProtocolHandler().setClientID(string);
    }

    protected void checkTemporaryDestination(Topic topic) throws JMSException {
        if (topic == null || topic instanceof TemporaryTopic) {
            String string = AdministeredObject.cr.getKString("C4050", topic == null ? "" : topic.getTopicName());
            throw new InvalidDestinationException(string, "C4050");
        }
    }
}

