/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.BrowserConsumer;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class QueueBrowserImpl
implements QueueBrowser {
    private SessionImpl session = null;
    private Queue queue = null;
    private String messageSelector = null;
    private Vector consumers = new Vector();
    private boolean isClosed = false;

    public QueueBrowserImpl(SessionImpl sessionImpl, Queue queue) throws JMSException {
        this(sessionImpl, queue, null);
    }

    public QueueBrowserImpl(SessionImpl sessionImpl, Queue queue, String string) throws JMSException {
        if (queue == null) {
            String string2 = AdministeredObject.cr.getKString("C4050", "null");
            throw new InvalidDestinationException(string2, "C4050");
        }
        this.session = sessionImpl;
        this.queue = queue;
        this.messageSelector = string;
        this.init();
    }

    private void init() throws JMSException {
        this.session.checkBrowserCreation();
        this.session.verifyDestination((Destination)this.queue, this.messageSelector, true);
    }

    public Queue getQueue() throws JMSException {
        this.checkState();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.checkState();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkState();
        return new BrowserConsumer(this, (Destination)this.queue, this.messageSelector);
    }

    protected void addBrowserConsumer(BrowserConsumer browserConsumer) {
        this.consumers.addElement(browserConsumer);
    }

    protected void removeBrowserConsumer(BrowserConsumer browserConsumer) {
        this.consumers.removeElement(browserConsumer);
    }

    public void close() throws JMSException {
        BrowserConsumer browserConsumer = null;
        for (int i = this.consumers.size() - 1; i >= 0; --i) {
            browserConsumer = (BrowserConsumer)this.consumers.elementAt(i);
            browserConsumer.close();
        }
        this.isClosed = true;
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected void checkState() throws IllegalStateException {
        if (this.isClosed) {
            String string = AdministeredObject.cr.getKString("C4046");
            throw new IllegalStateException(string, "C4046");
        }
        this.session.checkSessionState();
    }
}

