/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ReceiveQueue;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class MessageConsumerImpl
extends Consumer
implements MessageConsumer,
Traceable {
    protected MessageListener messageListener = null;
    protected SessionImpl session = null;
    protected ReceiveQueue receiveQueue = null;
    private boolean syncReadFlag = true;
    private SysMessageID lastDeliveredID = null;

    public MessageConsumerImpl(SessionImpl sessionImpl, Destination destination, String string, boolean bl) throws JMSException {
        super(sessionImpl.getConnection(), destination, string, bl);
        this.session = sessionImpl;
        this.init();
    }

    public MessageConsumerImpl(SessionImpl sessionImpl, Destination destination) throws JMSException {
        super(sessionImpl.getConnection(), destination);
        this.session = sessionImpl;
    }

    protected void init() throws JMSException {
        this.checkConsumerCreation();
        this.receiveQueue = new ReceiveQueue();
        if (!this.session.getTransacted()) {
            this.acknowledgeMode = this.session.acknowledgeMode;
        }
        this.addInterest();
    }

    private void addInterest() throws JMSException {
        this.session.checkConsumerCreation();
        this.registerInterest();
    }

    private void removeInterest() throws JMSException {
        this.session.removeMessageConsumer(this);
        this.deregisterInterest();
    }

    private synchronized void setSyncReadFlag(boolean bl) {
        this.syncReadFlag = bl;
    }

    protected synchronized boolean getSyncReadFlag() {
        return this.syncReadFlag;
    }

    protected void checkReceive() throws JMSException {
        this.checkState();
        if (!this.getSyncReadFlag()) {
            String string = AdministeredObject.cr.getKString("C4032");
            throw new JMSException(string, "C4032");
        }
    }

    protected void stop() {
        this.receiveQueue.stop();
    }

    protected void start() {
        this.receiveQueue.start();
    }

    protected SessionQueue getReceiveQueue() {
        return this.receiveQueue;
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected Long getReadQueueId() {
        return this.session.getSessionId();
    }

    protected void onMessage(MessageImpl messageImpl) throws JMSException {
        if (this.getSyncReadFlag()) {
            this.receiveQueue.enqueueNotify(messageImpl);
        } else {
            this.onMessageToListenerFromReceiveQueue();
            this.deliverAndAcknowledge(messageImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessageToListenerFromReceiveQueue() throws JMSException {
        if (!this.receiveQueue.isEmpty()) {
            ReceiveQueue receiveQueue = this.receiveQueue;
            synchronized (receiveQueue) {
                int n = this.receiveQueue.size();
                for (int i = 0; i < n; ++i) {
                    MessageImpl messageImpl = (MessageImpl)this.receiveQueue.dequeue();
                    this.deliverAndAcknowledge(messageImpl);
                }
                this.receiveQueue.clear();
                this.session.sessionQueue.setListenerLate(false);
            }
        }
    }

    protected void deliverAndAcknowledge(MessageImpl messageImpl) throws JMSException {
        block5: {
            try {
                this.messageListener.onMessage((Message)messageImpl);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                if (this.session.getTransacted() || this.session.acknowledgeMode == 2) break block5;
                messageImpl.doAcknowledge = false;
                messageImpl.setJMSRedelivered(true);
                try {
                    this.messageListener.onMessage((Message)messageImpl);
                    messageImpl.doAcknowledge = true;
                }
                catch (Exception exception2) {
                    Debug.printStackTrace(exception2);
                }
            }
        }
        if (messageImpl.doAcknowledge && !messageImpl.consumerInRA) {
            this.session.acknowledge(messageImpl);
        }
        this.lastDeliveredID = messageImpl.getMessageID();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkState();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkState();
        this.messageListener = messageListener;
        if (messageListener == null) {
            this.setSyncReadFlag(true);
        } else {
            this.setSyncReadFlag(false);
            if (this.receiveQueue.size() > 0) {
                this.session.sessionQueue.setListenerLateNotify();
            }
        }
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long l) throws JMSException {
        MessageImpl messageImpl = null;
        this.checkReceive();
        try {
            messageImpl = (MessageImpl)this.receiveQueue.dequeueWait(l);
            if (messageImpl != null) {
                this.session.acknowledge(messageImpl);
                this.lastDeliveredID = messageImpl.getMessageID();
            }
        }
        finally {
            this.receiveQueue.setReceiveInProcess(false);
        }
        return messageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait() throws JMSException {
        MessageImpl messageImpl = null;
        this.checkReceive();
        try {
            if (this.receiveQueue.getIsLocked()) {
                Message message = null;
                return message;
            }
            this.receiveQueue.setReceiveInProcess(true);
            messageImpl = (MessageImpl)this.receiveQueue.dequeue();
            if (messageImpl != null) {
                this.session.acknowledge(messageImpl);
                this.lastDeliveredID = messageImpl.getMessageID();
            }
        }
        finally {
            this.receiveQueue.setReceiveInProcess(false);
        }
        return messageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        ReceiveQueue receiveQueue = this.receiveQueue;
        synchronized (receiveQueue) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        if (Thread.currentThread() != this.session.sessionReader.sessionThread) {
            this.session.sessionQueue.stop(true);
        }
        this.stop();
        this.receiveQueue.close();
        if (!this.session.connection.isBroken()) {
            if (this.session.dupsOkAckOnTimeout) {
                this.session.syncedDupsOkCommitAcknowledge();
            }
            this.removeInterest();
        }
        if (this.session.connection.getBrokerProtocolLevel() < 350 && (this.session.isTransacted || this.session.acknowledgeMode == 2 || this.session.acknowledgeMode == 3)) {
            this.session.removeUnAckedMessages(this.interestId);
        }
        this.removeUndeliveredMessages();
        if (Thread.currentThread() == this.session.sessionReader.sessionThread) {
            this.session.sessionReader.currentMessage.doAcknowledge = false;
        } else {
            this.session.sessionQueue.start();
        }
        if (this.debug) {
            Debug.println("message consumer closed ...");
            Debug.println(this);
        }
        this.messageListener = null;
        this.isClosed = true;
    }

    protected void removeUndeliveredMessages() throws JMSException {
        Object[] objectArray = this.session.sessionQueue.toArray();
        int n = objectArray.length;
        if (n > 0) {
            int n2;
            Vector<ReadOnlyPacket> vector = new Vector<ReadOnlyPacket>();
            long l = this.interestId;
            for (n2 = 0; n2 < n; ++n2) {
                ReadOnlyPacket readOnlyPacket = (ReadOnlyPacket)objectArray[n2];
                if (readOnlyPacket == null || readOnlyPacket.getConsumerID() != l) continue;
                vector.addElement(readOnlyPacket);
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (this.debug) {
                    Debug.println("removing msg from sessionq: " + vector.elementAt(n2));
                }
                this.session.sessionQueue.remove(vector.elementAt(n2));
            }
        }
    }

    protected SysMessageID getLastDeliveredID() {
        return this.lastDeliveredID;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ MessageConsumerImpl dump ------");
        printStream.println("Interest ID: " + this.getInterestId());
        printStream.println("is registered: " + this.getIsRegistered());
        printStream.println("is durable: " + this.getDurable());
        if (this.durable) {
            printStream.println("durableName: " + this.getDurableName());
        }
        printStream.println("destination: " + this.getDestination());
        printStream.println("selector: " + this.messageSelector);
        if (this.receiveQueue != null) {
            this.receiveQueue.dump(printStream);
        } else {
            printStream.println("receiveQueue is null.");
        }
    }

    protected Hashtable getDebugState(boolean bl) {
        Hashtable hashtable = super.getDebugState(bl);
        hashtable.put("# pending", String.valueOf(this.receiveQueue.size()));
        hashtable.put("syncReadFlag", String.valueOf(this.syncReadFlag));
        if (bl) {
            hashtable.put("receiveQueue", this.receiveQueue);
        }
        return hashtable;
    }

    public Object TEST_GetAttribute(String string) {
        if (string.startsWith("FlowControl")) {
            return this.session.readChannel.flowControl.TEST_GetAttribute(string, this);
        }
        return null;
    }
}

