/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionFlowControlEntry;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.ConsumerFlowControlEntry;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.FlowControlEntry;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;

public class FlowControl
implements Runnable,
Traceable {
    protected ProtocolHandler protocolHandler = null;
    protected ConnectionImpl connection = null;
    protected boolean isClosed = false;
    protected static final String imqFlowControl = "imqConnectionFlowControl-";
    protected boolean debug = Debug.debug;
    private Hashtable flowControlTable = null;
    private Hashtable readyQueue = null;
    private static boolean FLOWCONTROL_DEBUG = Boolean.getBoolean("imq.flowcontrol.debug");
    private static String FLOWCONTROL_LOG = System.getProperty("imq.flowcontrol.log");
    private static PrintStream fdbg = null;
    private long pingInterval = 30000L;

    private static void initFlowControlDebug() {
        if (!FLOWCONTROL_DEBUG || fdbg != null) {
            return;
        }
        if (FLOWCONTROL_LOG == null) {
            FLOWCONTROL_LOG = "stderr";
        }
        if (FLOWCONTROL_LOG.equals("stdout")) {
            fdbg = System.out;
        } else if (FLOWCONTROL_LOG.equals("stderr")) {
            fdbg = System.err;
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(FLOWCONTROL_LOG, true);
                fdbg = new PrintStream(fileOutputStream);
            }
            catch (IOException iOException) {
                fdbg = System.err;
            }
        }
    }

    public FlowControl(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.pingInterval = connectionImpl.getPingInterval();
        this.protocolHandler = this.connection.getProtocolHandler();
        this.readyQueue = new Hashtable();
        this.flowControlTable = new Hashtable();
        FlowControl.initFlowControlDebug();
        this.addConnectionFlowControl(connectionImpl);
    }

    private void addConnectionFlowControl(ConnectionImpl connectionImpl) {
        ConnectionFlowControlEntry connectionFlowControlEntry = new ConnectionFlowControlEntry(this, connectionImpl.getProtocolHandler(), connectionImpl.protectMode, connectionImpl.flowControlMsgSize, connectionImpl.flowControlWaterMark);
        this.flowControlTable.put(connectionImpl, connectionFlowControlEntry);
        if (FLOWCONTROL_DEBUG) {
            fdbg.println("Added connection flow control entry : " + connectionImpl);
        }
    }

    public void requestConnectionFlowResume() {
        this.requestResume(this.connection);
    }

    public void messageReceived() {
        this.messageReceived(this.connection);
    }

    public void messageDelivered() {
        this.messageDelivered(this.connection);
    }

    public void addConsumerFlowControl(Consumer consumer) {
        ConsumerFlowControlEntry consumerFlowControlEntry = new ConsumerFlowControlEntry(this, consumer.getConnection().getProtocolHandler(), consumer);
        this.flowControlTable.put(consumer, consumerFlowControlEntry);
        if (FLOWCONTROL_DEBUG) {
            fdbg.println("Added flow control entry : " + consumerFlowControlEntry);
        }
    }

    public void removeConsumerFlowControl(Consumer consumer) {
        FlowControlEntry flowControlEntry = (FlowControlEntry)this.flowControlTable.remove(consumer);
        if (FLOWCONTROL_DEBUG) {
            fdbg.println("Removed flow control entry : " + flowControlEntry);
        }
    }

    public void requestResume(Object object) {
        if (this.debug) {
            Debug.println("**** In requestResume. key = " + object);
        }
        FlowControlEntry flowControlEntry = this.getFlowControlEntry(object);
        if (FLOWCONTROL_DEBUG) {
            fdbg.println("PAUSED MESSAGE DELIVERY FOR : " + flowControlEntry);
        }
        flowControlEntry.setResumeRequested(true);
    }

    public void messageReceived(Object object) {
        FlowControlEntry flowControlEntry = this.findFlowControlEntry(object);
        if (flowControlEntry != null) {
            flowControlEntry.messageReceived();
        }
    }

    public void messageDelivered(Object object) {
        FlowControlEntry flowControlEntry = this.findFlowControlEntry(object);
        if (flowControlEntry != null) {
            flowControlEntry.messageDelivered();
        }
    }

    public void resetFlowControl(Object object) {
        FlowControlEntry flowControlEntry = this.findFlowControlEntry(object);
        if (flowControlEntry != null) {
            flowControlEntry.resetFlowControl();
        }
    }

    public Hashtable getDebugState(Object object) {
        FlowControlEntry flowControlEntry = this.findFlowControlEntry(object);
        if (flowControlEntry != null) {
            return flowControlEntry.getDebugState();
        }
        return null;
    }

    public Object TEST_GetAttribute(String string, Object object) {
        FlowControlEntry flowControlEntry = this.findFlowControlEntry(object);
        return flowControlEntry.TEST_GetAttribute(string);
    }

    private FlowControlEntry getFlowControlEntry(Object object) {
        FlowControlEntry flowControlEntry = (FlowControlEntry)this.flowControlTable.get(object);
        if (flowControlEntry == null) {
            if (!(object instanceof Consumer) && !(object instanceof ConnectionImpl)) {
                throw new IllegalArgumentException("getFlowControlEntry: Bad key type. key = " + object);
            }
            throw new IllegalStateException("FlowControlEntry not found. key = " + object);
        }
        return flowControlEntry;
    }

    private FlowControlEntry findFlowControlEntry(Object object) {
        if (object == null) {
            return null;
        }
        FlowControlEntry flowControlEntry = (FlowControlEntry)this.flowControlTable.get(object);
        return flowControlEntry;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            thread.setDaemon(true);
        }
        thread.setName(imqFlowControl + this.connection.getLocalID());
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = 0L;
        block7: while (true) {
            FlowControlEntry[] flowControlEntryArray = null;
            FlowControl flowControl = this;
            synchronized (flowControl) {
                while (!this.isClosed && this.readyQueue.size() == 0) {
                    block15: {
                        try {
                            this.wait(this.pingInterval);
                            if (!this.isClosed && this.readyQueue.size() == 0) {
                                if (this.protocolHandler.getTimeToPing()) {
                                    this.pingBroker();
                                }
                                this.protocolHandler.setTimeToPing(true);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (!this.debug) break block15;
                            Debug.printStackTrace(interruptedException);
                        }
                    }
                    if (!FLOWCONTROL_DEBUG || System.currentTimeMillis() - l <= this.pingInterval) continue;
                    this.status_report();
                    l = System.currentTimeMillis();
                }
                if (this.isClosed) {
                    break;
                }
                flowControlEntryArray = this.readyQueue.values().toArray(new FlowControlEntry[0]);
            }
            try {
                int n = 0;
                while (true) {
                    if (n >= flowControlEntryArray.length) continue block7;
                    flowControlEntryArray[n].sendResumeFlow();
                    if (FLOWCONTROL_DEBUG) {
                        fdbg.println("SENDING RESUME_FLOW FOR : " + flowControlEntryArray[n]);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                if (this.connection.isClosed) {
                    this.isClosed = true;
                    break;
                }
                Debug.printStackTrace(exception);
                continue;
            }
            break;
        }
    }

    private void pingBroker() {
        block2: {
            try {
                this.protocolHandler.ping();
            }
            catch (JMSException jMSException) {
                if (!this.debug) break block2;
                Debug.printStackTrace((Exception)((Object)jMSException));
            }
        }
    }

    private void status_report() {
        fdbg.println("debug_interval = " + this.pingInterval);
        fdbg.println("\n-------------------------------- " + this + " : " + new Date());
        Enumeration enumeration = this.flowControlTable.elements();
        while (enumeration.hasMoreElements()) {
            FlowControlEntry flowControlEntry = (FlowControlEntry)enumeration.nextElement();
            flowControlEntry.status_report(fdbg);
        }
    }

    protected synchronized void addToReadyQueue(FlowControlEntry flowControlEntry) {
        if (this.debug) {
            Debug.println("In addToReadyQueue : " + flowControlEntry);
        }
        this.readyQueue.put(flowControlEntry, flowControlEntry);
        this.notifyAll();
    }

    protected synchronized void removeFromReadyQueue(FlowControlEntry flowControlEntry) {
        if (this.debug) {
            Debug.println("In addToReadyQueue : " + flowControlEntry);
        }
        this.readyQueue.remove(flowControlEntry);
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
    }

    public void dump(PrintStream printStream) {
    }
}

