/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;

public class Debug {
    public static boolean debug;
    private static boolean debugAll;
    private static boolean debugVerbose;
    private static boolean silentMode;
    private static PrintStream ps;
    private static final String READ_ONLY_PACKET = "ReadOnlyPacket";
    private static final String READ_WRITE_PACKET = "ReadWritePacket";
    private static final String PACKET_TYPE = "imq.packetType";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String string) {
        if (debugVerbose) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(string);
                ps.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String string) {
        if (!silentMode) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(string);
                ps.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printReadPacket(ReadOnlyPacket readOnlyPacket) {
        String string = System.getProperty(READ_ONLY_PACKET);
        String string2 = System.getProperty(PACKET_TYPE);
        boolean bl = Debug.matchPacketType(readOnlyPacket);
        if (debugAll || string != null || bl) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(new Date().toString() + "<-----Reading packet----");
                readOnlyPacket.dump(ps);
                ps.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printWritePacket(ReadOnlyPacket readOnlyPacket) {
        String string = System.getProperty(READ_WRITE_PACKET);
        String string2 = System.getProperty(PACKET_TYPE);
        boolean bl = Debug.matchPacketType(readOnlyPacket);
        if (debugAll || string != null || bl) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(new Date().toString() + " -------writing packet----->");
                readOnlyPacket.dump(ps);
                ps.flush();
            }
        }
    }

    public static boolean matchPacketType(ReadOnlyPacket readOnlyPacket) {
        String string = System.getProperty(PACKET_TYPE);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (readOnlyPacket.getPacketType() != Integer.parseInt(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(Traceable traceable) {
        String string;
        String string2 = string = traceable.getClass().getName();
        String string3 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        string3 = System.getProperty(string2);
        if (debugAll || string3 != null) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println("-------- begin dump class: " + traceable.getClass().getName());
                traceable.dump(ps);
                ps.println("^^^^^^^^ end dump class: " + traceable.getClass().getName());
                ps.flush();
            }
        }
    }

    public static synchronized void printStackTrace(Exception exception) {
        if (silentMode) {
            return;
        }
        exception.printStackTrace(ps);
    }

    public static PrintStream getPrintStream() {
        return ps;
    }

    static {
        String string;
        debug = false;
        debugAll = false;
        debugVerbose = false;
        silentMode = false;
        ps = System.out;
        if (System.getProperty("imq.debug") != null) {
            debug = true;
        }
        if (System.getProperty("imq.debug.all") != null) {
            debug = true;
            debugVerbose = true;
            debugAll = true;
        }
        if (System.getProperty("imq.debug.verbose") != null) {
            debug = true;
            debugVerbose = true;
        }
        if ((string = System.getProperty("imq.debug.file")) != null) {
            debug = true;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, false);
                ps = new PrintStream(fileOutputStream, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (System.getProperty("imq.silent") != null) {
            silentMode = true;
        }
    }
}

