/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.FlowControlEntry;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import java.io.PrintStream;
import java.util.Hashtable;

class ConsumerFlowControlEntry
extends FlowControlEntry {
    protected Consumer consumer;
    protected int maxMsgCount;
    protected int thresholdCount;
    protected boolean resumeRequested = false;
    protected int inQueueCounter = 0;
    protected int TEST_peakCount = 0;
    protected int TEST_pauseCount = 0;
    protected int TEST_resumeCount = 0;
    protected int TEST_minResumeCount = Integer.MAX_VALUE;
    protected int TEST_lastResumeCount = -1;
    private static boolean sendResumeOnRecover = true;

    public ConsumerFlowControlEntry(FlowControl flowControl, ProtocolHandler protocolHandler, Consumer consumer) {
        super(flowControl, protocolHandler);
        this.consumer = consumer;
        int n = consumer.getPrefetchMaxMsgCount();
        int n2 = consumer.getPrefetchThresholdPercent();
        this.maxMsgCount = n;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 100) {
            n2 = 100;
        }
        this.thresholdCount = (int)((double)((float)this.maxMsgCount * (float)n2) / 100.0);
        if (this.thresholdCount >= this.maxMsgCount) {
            this.thresholdCount = this.maxMsgCount - 1;
        }
    }

    public synchronized void messageReceived() {
        ++this.inQueueCounter;
        if (this.inQueueCounter > this.TEST_peakCount) {
            this.TEST_peakCount = this.inQueueCounter;
        }
    }

    public synchronized void messageDelivered() {
        --this.inQueueCounter;
        this.checkAndResumeFlow();
    }

    public synchronized void resetFlowControl() {
        this.inQueueCounter = 0;
        if (sendResumeOnRecover) {
            this.checkAndResumeFlow();
        }
    }

    public synchronized void setResumeRequested(boolean bl) {
        if (this.debug) {
            Debug.println("setResumeRequsted[" + this + "] : " + bl);
        }
        this.resumeRequested = bl;
        if (bl) {
            ++this.TEST_pauseCount;
            this.checkAndResumeFlow();
        }
    }

    protected synchronized void sendResumeFlow() throws Exception {
        int n = -1;
        if (this.maxMsgCount > 0) {
            n = this.maxMsgCount - this.inQueueCounter;
        }
        this.setResumeRequested(false);
        this.protocolHandler.resumeConsumerFlow(this.consumer, n);
        this.fc.removeFromReadyQueue(this);
        if (n < this.TEST_minResumeCount) {
            this.TEST_minResumeCount = n;
        }
        this.TEST_lastResumeCount = n;
        ++this.TEST_resumeCount;
    }

    private void checkAndResumeFlow() {
        if (this.debug) {
            Debug.println("In checkAndResumeFlow : " + this + "\n\tresumeRequested = " + this.resumeRequested + ", maxMsgCount = " + this.maxMsgCount + ", inQueueCounter = " + this.inQueueCounter + ", thresholdCount = " + this.thresholdCount);
        }
        if (this.resumeRequested && (this.maxMsgCount <= 0 || this.inQueueCounter <= this.thresholdCount)) {
            this.fc.addToReadyQueue(this);
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("maxMsgCount", String.valueOf(this.maxMsgCount));
        hashtable.put("thresholdCount", String.valueOf(this.thresholdCount));
        hashtable.put("inQueueCounter", String.valueOf(this.inQueueCounter));
        hashtable.put("peakCount", String.valueOf(this.TEST_peakCount));
        hashtable.put("isFlowPaused", String.valueOf(this.resumeRequested));
        hashtable.put("pauseCount", String.valueOf(this.TEST_pauseCount));
        hashtable.put("resumeCount", String.valueOf(this.TEST_resumeCount));
        hashtable.put("lastResumeCount", String.valueOf(this.TEST_minResumeCount));
        hashtable.put("minResumeCount", this.TEST_lastResumeCount == -1 ? "---" : Integer.toString(this.TEST_lastResumeCount));
        return hashtable;
    }

    protected Object TEST_GetAttribute(String string) {
        if (string.equals("FlowControl.Count")) {
            return new Integer(this.inQueueCounter);
        }
        if (string.equals("FlowControl.PeakCount")) {
            return new Integer(this.TEST_peakCount);
        }
        if (string.equals("FlowControl.IsFlowPaused")) {
            return new Boolean(this.resumeRequested);
        }
        if (string.equals("FlowControl.PauseCount")) {
            return new Integer(this.TEST_pauseCount);
        }
        if (string.equals("FlowControl.MinResumeCount")) {
            return new Integer(this.TEST_minResumeCount);
        }
        return null;
    }

    public String toString() {
        return "ConsumerFlowControlEntry[" + this.consumer + "]";
    }

    protected void status_report(PrintStream printStream) {
        printStream.println("FlowControlState for : " + this);
        printStream.println("\t# pending messages : " + this.inQueueCounter);
        printStream.println("\t# resumeRequested : " + this.resumeRequested);
        printStream.println("\t# threshodCount : " + this.thresholdCount);
        printStream.println("\t# lastResumeCount : " + (this.TEST_lastResumeCount == -1 ? "---" : Integer.toString(this.TEST_lastResumeCount)));
    }

    static {
        if (System.getProperty("imq.resume_on_recover") != null) {
            sendResumeOnRecover = Boolean.getBoolean("imq.resume_on_recover");
        }
    }
}

