/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;

public class ReadWritePacket
extends ReadOnlyPacket {
    static int sequenceNumber = 0;
    protected boolean headerBufferDirty = false;
    protected boolean ropBufferDirty = false;
    protected byte[] messageBody = null;
    protected int messageBodyOffset = 0;
    protected int messageBodyLength = 0;
    private boolean genTimestamp = true;
    private boolean genSequenceNumber = true;

    public ReadWritePacket() {
        this.reset();
    }

    public synchronized void readPacket(InputStream inputStream) throws IOException, EOFException {
        super.readPacket(inputStream);
    }

    public synchronized void writePacket(OutputStream outputStream) throws IOException {
        if (this.genSequenceNumber) {
            this.updateSequenceNumber();
        }
        if (this.genTimestamp) {
            this.updateTimestamp();
        }
        this.updateBuffers();
        super.writePacket(outputStream);
    }

    public synchronized void writePacket(OutputStream outputStream, int n) throws IOException {
        this.setVersion(n);
        super.writePacket(outputStream);
    }

    public synchronized void updateTimestamp() {
        this.setTimestamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateSequenceNumber() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.setSequence(++sequenceNumber);
        }
    }

    public void writePacket(OutputStream outputStream, long l, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.writePacket(outputStream, this.version, l, bl, bl2, bl3);
    }

    public void writePacket(OutputStream outputStream, int n, long l, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.setVersion(n);
        this.setRedelivered(bl2);
        this.setConsumerID(l);
        this.setIsLast(bl3);
        this.setFlowPaused(bl);
        this.writePacket(outputStream);
    }

    public void updateBuffers() throws IOException {
        if (this.ropBuffer == null || this.ropBufferDirty) {
            this.updateRopBuffer();
            this.updateHeaderBuffer();
        } else if (this.headerBufferDirty) {
            this.updateHeaderBuffer();
        }
    }

    private void updateHeaderBuffer() throws IOException {
        JMQByteArrayOutputStream jMQByteArrayOutputStream = new JMQByteArrayOutputStream(this.headerBuffer);
        DataOutputStream dataOutputStream = new DataOutputStream(jMQByteArrayOutputStream);
        dataOutputStream.writeInt(469754818);
        dataOutputStream.writeShort(this.version);
        dataOutputStream.writeShort(this.packetType);
        dataOutputStream.writeInt(this.packetSize);
        if (this.version == 103) {
            dataOutputStream.writeInt((int)this.transactionID);
        }
        dataOutputStream.writeLong(this.expiration);
        this.sysMessageID.writeID(dataOutputStream);
        dataOutputStream.writeInt(this.propertyOffset);
        dataOutputStream.writeInt(this.propertySize);
        dataOutputStream.writeByte(this.priority);
        dataOutputStream.writeByte(this.encryption);
        dataOutputStream.writeShort(this.bitFlags);
        if (this.version == 103) {
            dataOutputStream.writeInt((int)this.consumerID);
        } else {
            dataOutputStream.writeLong(this.consumerID);
        }
        dataOutputStream.flush();
        jMQByteArrayOutputStream.flush();
        this.headerBuffer = jMQByteArrayOutputStream.getBuf();
        this.headerBufferDirty = false;
    }

    private void updateRopBuffer() throws IOException {
        byte[] byArray = new byte[4];
        try {
            this.getProperties();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.getMessageBody();
        if (this.ropBuffer == null) {
            int n = 1024;
            if (this.messageBody != null) {
                n += this.messageBodyLength;
            }
            this.ropBuffer = new byte[n];
        }
        JMQByteArrayOutputStream jMQByteArrayOutputStream = new JMQByteArrayOutputStream(this.ropBuffer);
        DataOutputStream dataOutputStream = new DataOutputStream(jMQByteArrayOutputStream);
        if (this.version >= 200 && this.transactionID != 0L) {
            this.writeLong(dataOutputStream, 8, this.transactionID);
        }
        if (this.producerID != 0L) {
            this.writeLong(dataOutputStream, 9, this.producerID);
        }
        this.writeString(dataOutputStream, 1, this.destination);
        this.writeString(dataOutputStream, 6, this.destinationClass);
        this.writeString(dataOutputStream, 2, this.messageID);
        this.writeString(dataOutputStream, 3, this.correlationID);
        this.writeString(dataOutputStream, 4, this.replyTo);
        this.writeString(dataOutputStream, 7, this.replyToClass);
        this.writeString(dataOutputStream, 5, this.messageType);
        dataOutputStream.writeShort(0);
        dataOutputStream.flush();
        int n = 4 - jMQByteArrayOutputStream.getCount() % 4;
        jMQByteArrayOutputStream.write(byArray, 0, n);
        jMQByteArrayOutputStream.flush();
        this.propertyOffset = jMQByteArrayOutputStream.getCount() + 72;
        if (this.properties != null) {
            if (this.version == 301) {
                PacketProperties.write(this.properties, jMQByteArrayOutputStream);
            } else {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(jMQByteArrayOutputStream);
                objectOutputStream.writeObject(this.properties);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
        }
        this.propertySize = jMQByteArrayOutputStream.getCount() - (this.propertyOffset - 72);
        if (this.messageBody != null) {
            jMQByteArrayOutputStream.write(this.messageBody, this.messageBodyOffset, this.messageBodyLength);
        }
        this.ropLength = jMQByteArrayOutputStream.getCount();
        this.packetSize = this.ropLength + 72;
        jMQByteArrayOutputStream.flush();
        this.ropBuffer = jMQByteArrayOutputStream.getBuf();
        this.ropBufferDirty = false;
        jMQByteArrayOutputStream.close();
    }

    private void writeString(DataOutputStream dataOutputStream, int n, String string) throws IOException {
        if (string != null) {
            dataOutputStream.writeShort(n);
            dataOutputStream.writeUTF(string);
        }
    }

    private void writeLong(DataOutputStream dataOutputStream, int n, long l) throws IOException {
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(8);
        dataOutputStream.writeLong(l);
    }

    public void generateSequenceNumber(boolean bl) {
        this.genSequenceNumber = bl;
    }

    public void generateTimestamp(boolean bl) {
        this.genTimestamp = bl;
    }

    public synchronized void setPacketType(int n) {
        this.packetType = n;
        this.headerBufferDirty = true;
    }

    public synchronized void setTimestamp(long l) {
        this.sysMessageID.timestamp = l;
        this.headerBufferDirty = true;
    }

    public synchronized void setExpiration(long l) {
        this.expiration = l;
        this.headerBufferDirty = true;
    }

    public synchronized void setPort(int n) {
        this.sysMessageID.port = n;
        this.headerBufferDirty = true;
    }

    public synchronized void setIP(byte[] byArray) {
        this.sysMessageID.setIPAddress(byArray);
        this.headerBufferDirty = true;
    }

    public synchronized void setIP(byte[] byArray, byte[] byArray2) {
        this.sysMessageID.setIPAddress(byArray, byArray2);
        this.headerBufferDirty = true;
    }

    public synchronized void setSequence(int n) {
        this.sysMessageID.sequence = n;
        this.headerBufferDirty = true;
    }

    public synchronized void setVersion(int n) {
        if (this.version != n) {
            this.version = n;
            this.headerBufferDirty = true;
        }
    }

    public synchronized void setTransactionID(long l) {
        this.transactionID = l;
        this.headerBufferDirty = true;
    }

    public synchronized void setEncryption(int n) {
        this.encryption = n;
        this.headerBufferDirty = true;
    }

    public synchronized void setPriority(int n) {
        this.priority = n;
        this.headerBufferDirty = true;
    }

    public void setConsumerID(long l) {
        this.consumerID = l;
        this.headerBufferDirty = true;
    }

    public void setInterestID(int n) {
        this.setConsumerID(n);
    }

    public void setPersistent(boolean bl) {
        this.setFlag(4, bl);
    }

    public void setRedelivered(boolean bl) {
        this.setFlag(2, bl);
    }

    public void setIsQueue(boolean bl) {
        this.setFlag(1, bl);
    }

    public void setSelectorsProcessed(boolean bl) {
        this.setFlag(8, bl);
    }

    public void setSendAcknowledge(boolean bl) {
        this.setFlag(16, bl);
    }

    public void setIsLast(boolean bl) {
        this.setFlag(32, bl);
    }

    public void setFlowPaused(boolean bl) {
        this.setFlag(64, bl);
    }

    public void setIsTransacted(boolean bl) {
        this.setFlag(128, bl);
    }

    public void setConsumerFlow(boolean bl) {
        this.setFlag(256, bl);
    }

    public synchronized void setFlag(int n, boolean bl) {
        this.bitFlags = bl ? (this.bitFlags |= n) : (this.bitFlags &= ~n);
        this.headerBufferDirty = true;
    }

    public synchronized void setProducerID(long l) {
        this.producerID = l;
        this.ropBufferDirty = true;
    }

    public synchronized void setDestination(String string) {
        this.destination = string;
        this.ropBufferDirty = true;
    }

    public synchronized void setDestinationClass(String string) {
        this.destinationClass = string;
        this.ropBufferDirty = true;
    }

    public synchronized void setMessageID(String string) {
        this.messageID = string;
        this.ropBufferDirty = true;
    }

    public synchronized void setCorrelationID(String string) {
        this.correlationID = string;
        this.ropBufferDirty = true;
    }

    public synchronized void setReplyTo(String string) {
        this.replyTo = string;
        this.ropBufferDirty = true;
    }

    public synchronized void setReplyToClass(String string) {
        this.replyToClass = string;
        this.ropBufferDirty = true;
    }

    public synchronized void setMessageType(String string) {
        this.messageType = string;
        this.ropBufferDirty = true;
    }

    public synchronized void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
        this.ropBufferDirty = true;
    }

    public synchronized void setMessageBody(byte[] byArray) {
        this.messageBody = byArray;
        this.messageBodyOffset = 0;
        this.messageBodyLength = byArray != null ? byArray.length : 0;
        this.ropBufferDirty = true;
    }

    public synchronized void setMessageBody(byte[] byArray, int n, int n2) {
        this.messageBody = byArray;
        this.messageBodyOffset = n;
        this.messageBodyLength = n2;
        this.ropBufferDirty = true;
    }

    public synchronized int getMessageBodyLength() {
        return this.messageBodyLength;
    }

    public synchronized int getMessageBodySize() {
        return this.getMessageBodyLength();
    }

    public synchronized int getMessageBodyOffset() {
        return this.messageBodyOffset;
    }

    public synchronized byte[] getMessageBody() {
        if (this.messageBody == null) {
            InputStream inputStream = super.getMessageBodyStream();
            if (inputStream == null) {
                return null;
            }
            try {
                int n = inputStream.available();
                this.messageBody = new byte[n];
                inputStream.read(this.messageBody, 0, n);
                this.messageBodyOffset = 0;
                this.messageBodyLength = n;
            }
            catch (IOException iOException) {
                System.err.println("Could not get message body: " + iOException);
                this.messageBody = null;
            }
        }
        return this.messageBody;
    }

    public Object cloneShallow() {
        return super.cloneShallow();
    }

    public Object clone() {
        ReadWritePacket readWritePacket = (ReadWritePacket)super.clone();
        if (this.messageBody != null) {
            byte[] byArray = new byte[this.messageBodyLength];
            System.arraycopy(this.messageBody, this.messageBodyOffset, byArray, 0, this.messageBodyLength);
            readWritePacket.messageBody = byArray;
            readWritePacket.messageBodyOffset = 0;
            readWritePacket.messageBodyLength = byArray.length;
        }
        return readWritePacket;
    }

    public synchronized void reset() {
        super.reset();
        this.headerBufferDirty = false;
        this.ropBufferDirty = false;
        this.messageBody = null;
        this.messageBodyOffset = 0;
        this.messageBodyLength = 0;
    }

    public void dump(PrintStream printStream) {
        super.dump(printStream);
        if (this.messageBody == null) {
            printStream.println("    messageBodyBuffer: null");
        } else {
            printStream.println("    messageBodyBuffer: " + this.messageBody + " " + this.messageBodyLength + " bytes");
        }
        printStream.println("    headerBufferDirty: " + this.headerBufferDirty + "    ropBufferDirty: " + this.ropBufferDirty);
        printStream.println("         genTimestamp: " + this.genTimestamp + "  genSequenceNumber: " + this.genSequenceNumber);
    }
}

