/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Properties;

public class MQAddress {
    public static final String isHostTrusted = "isHostTrusted";
    private static final String DEFAULT_SCHEME_NAME = "mq";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORTMAPPER_PORT = 7676;
    private static final String DEFAULT_SERVICENAME = "jms";
    private static HashMap handlers = new HashMap();
    private static final String TCP_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.tcp.TCPStreamHandler";
    private static final String SSL_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.ssl.SSLStreamHandler";
    private static final String HTTP_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.http.HTTPStreamHandler";
    private String addr = null;
    private String schemeName = null;
    private String hostName = null;
    private int port = -1;
    private String serviceName = null;
    private boolean isHTTP = false;
    private Properties props = new Properties();
    private boolean isSSLHostTrustedSet = false;

    private MQAddress() {
    }

    public static MQAddress createMQAddress(String string) throws MalformedURLException {
        MQAddress mQAddress = new MQAddress();
        mQAddress.addr = string;
        mQAddress.init();
        mQAddress.parseAndValidate();
        return mQAddress;
    }

    private void init() {
        this.props.setProperty(isHostTrusted, "true");
    }

    private void parseAndValidate() throws MalformedURLException {
        String string = new String(this.addr);
        this.schemeName = DEFAULT_SCHEME_NAME;
        int n = string.indexOf("://");
        if (n > 0) {
            this.schemeName = string.substring(0, n);
            string = string.substring(n + 3);
        }
        if (this.schemeName.equalsIgnoreCase(DEFAULT_SCHEME_NAME)) {
            n = string.indexOf(63);
            if (n >= 0) {
                String string2 = string.substring(n + 1);
                this.parseQueryString(string2);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(47)) >= 0) {
                this.serviceName = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(58)) >= 0) {
                this.port = Integer.parseInt(string.substring(n + 1));
                string = string.substring(0, n);
            }
            this.hostName = string;
            if (this.hostName == null || this.hostName.equals("")) {
                this.hostName = DEFAULT_HOSTNAME;
            }
            if (this.port == -1) {
                this.port = 7676;
            }
            if (this.serviceName == null || this.serviceName.equals("")) {
                this.serviceName = DEFAULT_SERVICENAME;
            }
        } else if (this.schemeName.equalsIgnoreCase("mqssl") || this.schemeName.equalsIgnoreCase("mqtcp")) {
            n = string.indexOf(63);
            if (n >= 0) {
                String string3 = string.substring(n + 1);
                this.parseQueryString(string3);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(47)) >= 0) {
                this.serviceName = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(58)) >= 0) {
                this.port = Integer.parseInt(string.substring(n + 1));
                string = string.substring(0, n);
            }
            this.hostName = string;
            if (this.hostName == null || this.hostName.equals("")) {
                throw new MalformedURLException("Illegal address. Hostname missing : " + this.addr);
            }
            if (this.port == -1) {
                throw new MalformedURLException("Illegal address. Port missing : " + this.addr);
            }
        } else {
            if (this.schemeName.equalsIgnoreCase("http") || this.schemeName.equalsIgnoreCase("https")) {
                this.isHTTP = true;
                return;
            }
            throw new MalformedURLException("Illegal address. Unknown address scheme : " + this.addr);
        }
    }

    private void parseQueryString(String string) throws MalformedURLException {
        String string2 = new String(string);
        while (string2.length() > 0) {
            String string3 = string2;
            int n = string2.indexOf(38);
            if (n >= 0) {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            } else {
                string2 = "";
            }
            int n2 = string3.indexOf(61);
            if (n2 <= 0) {
                throw new MalformedURLException("Illegal address. Bad query string : " + this.addr);
            }
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + 1);
            this.props.setProperty(string4, string5);
            if (!isHostTrusted.equals(string4)) continue;
            this.isSSLHostTrustedSet = true;
        }
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean getIsHTTP() {
        return this.isHTTP;
    }

    public String getURL() {
        return this.addr;
    }

    public String getHandlerClass() {
        if (this.isHTTP) {
            return HTTP_HANDLER;
        }
        if (this.schemeName.equalsIgnoreCase("mqtcp")) {
            return TCP_HANDLER;
        }
        if (this.schemeName.equalsIgnoreCase("mqssl")) {
            return SSL_HANDLER;
        }
        String string = (String)handlers.get(this.serviceName);
        return string;
    }

    public boolean isServicePortFinal() {
        return this.isHTTP || this.schemeName.equalsIgnoreCase("mqtcp") || this.schemeName.equalsIgnoreCase("mqssl");
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public boolean getIsSSLHostTrustedSet() {
        return this.isSSLHostTrustedSet;
    }

    public String toString() {
        if (this.isHTTP) {
            return this.addr;
        }
        return this.schemeName + "://" + this.hostName + ":" + this.port + "/" + this.serviceName;
    }

    public static void main(String[] stringArray) throws Exception {
        MQAddress mQAddress = MQAddress.createMQAddress(stringArray[0]);
        System.out.println("schemeName = " + mQAddress.getSchemeName());
        if (mQAddress.getIsHTTP()) {
            System.out.println("URL = " + mQAddress.getURL());
        } else {
            System.out.println("host = " + mQAddress.getHostName());
            System.out.println("port = " + mQAddress.getPort());
        }
        System.out.println("serviceName = " + mQAddress.getServiceName());
        System.out.println("handlerClass = " + mQAddress.getHandlerClass());
        System.out.println("isFinal = " + mQAddress.isServicePortFinal());
        System.out.println("properties = " + mQAddress.props);
    }

    static {
        handlers.put(DEFAULT_SERVICENAME, TCP_HANDLER);
        handlers.put("ssljms", SSL_HANDLER);
        handlers.put("httpjms", HTTP_HANDLER);
        handlers.put("httpsjms", HTTP_HANDLER);
        handlers.put("admin", TCP_HANDLER);
        handlers.put("ssladmin", SSL_HANDLER);
        handlers.put("httpadmin", HTTP_HANDLER);
        handlers.put("httpsadmin", HTTP_HANDLER);
    }
}

