/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.ClusterDiscoveryProtocol;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.io.ServiceTable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClusterDiscovery {
    public static final long RETRY_SLEEP_INTERVAL = 5000L;
    private long retrySleepInterval = 5000L;
    private ServiceTable st = null;
    private Vector addrList = null;
    private Hashtable failsafeAddrList = null;
    private int nextBroker = 0;

    public void ClusterDiscovery() {
        this.addrList = null;
        this.st = null;
    }

    public long getRetrySleepInterval() {
        return this.retrySleepInterval;
    }

    public void setRetrySleepInterval(long l) {
        this.retrySleepInterval = l;
    }

    public void addBrokerAddress(String string) throws IOException {
        this.addBrokerAddress(string, false);
    }

    private void addBrokerAddress(String string, boolean bl) throws IOException {
        if (!this.validateAddress(string)) {
            throw new IOException("Invalid broker address : " + string);
        }
        if (this.addrList == null) {
            this.addrList = new Vector();
            this.nextBroker = 0;
        }
        if (!bl) {
            if (this.failsafeAddrList == null) {
                this.failsafeAddrList = new Hashtable();
            }
            this.failsafeAddrList.put(string, string);
        }
        if (!this.addrList.contains(string)) {
            this.addrList.add(string);
        }
    }

    public String findService(String string, String string2, long l) throws IOException {
        if (this.addrList == null || this.addrList.size() == 0) {
            throw new IOException("Broker address list empty");
        }
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        do {
            this.nextBroker %= this.addrList.size();
            String string3 = (String)this.addrList.elementAt(this.nextBroker);
            try {
                this.discover(string3);
                String string4 = this.st.getServiceAddress(string, string2);
                if (string4 != null) {
                    return string4;
                }
                String string5 = this.st.getActiveBroker();
                if (string5 != null) {
                    this.discover(this.st.getActiveBroker());
                    string4 = this.st.getServiceAddress(string, string2);
                    if (string4 != null) {
                        return string4;
                    }
                    bl2 = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++this.nextBroker;
            if (!bl2 && this.nextBroker < this.addrList.size()) continue;
            try {
                Thread.sleep(this.retrySleepInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl2 = false;
        } while (System.currentTimeMillis() - l2 <= l);
        return null;
    }

    private void discover(String string) throws IOException {
        String string2 = ClusterDiscovery.getProtocol(string);
        String string3 = ClusterDiscovery.getHost(string);
        int n = ClusterDiscovery.getPort(string);
        if (string2.equals("portmapper")) {
            int n2 = this.doPortmapper(string3, n);
            if (n2 > 0) {
                n = n2;
                string2 = "cluster_discovery";
            } else {
                throw new IOException("Could not find cluster discovery service at " + string);
            }
        }
        if (string2.equals("cluster_discovery")) {
            this.st = this.doClusterDiscovery(string3, n);
            return;
        }
    }

    private int doPortmapper(String string, int n) throws IOException {
        String string2 = String.valueOf(101) + "\n";
        PortMapperTable portMapperTable = new PortMapperTable();
        Socket socket = new Socket(string, n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            outputStream.write(string2.getBytes());
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        portMapperTable.read(inputStream);
        inputStream.close();
        outputStream.close();
        socket.close();
        return portMapperTable.getPortForService("cluster_discovery");
    }

    private ServiceTable doClusterDiscovery(String string, int n) throws IOException {
        String string2;
        int n2;
        Socket socket = new Socket(string, n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        ClusterDiscoveryProtocol.sendRequest(outputStream);
        ServiceTable serviceTable = ClusterDiscoveryProtocol.receiveResponse(inputStream);
        Hashtable hashtable = serviceTable.getRemoteServices();
        Vector<String> vector = new Vector<String>();
        for (n2 = 0; n2 < this.addrList.size(); ++n2) {
            string2 = (String)this.addrList.elementAt(n2);
            if (hashtable.contains(string2) || this.failsafeAddrList.contains(string2)) continue;
            vector.add(string2);
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            this.addrList.remove(vector.elementAt(n2));
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            this.addBrokerAddress(string2, true);
        }
        return serviceTable;
    }

    private boolean validateAddress(String string) {
        if (ClusterDiscovery.getProtocol(string) == null) {
            return false;
        }
        if (ClusterDiscovery.getHost(string) == null) {
            return false;
        }
        return ClusterDiscovery.getPort(string) != -1;
    }

    public static String getProtocol(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getAddress(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String getHost(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return null;
        }
        return string.substring(n + 1, n2);
    }

    public static int getPort(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return -1;
        }
        String string2 = string.substring(n + 1);
        try {
            return Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        String string = properties.getProperty("brokers");
        String string2 = properties.getProperty("type");
        String string3 = properties.getProperty("protocol");
        long l = 30000L;
        long l2 = 10000L;
        int n = 1;
        try {
            l = Long.parseLong(properties.getProperty("timeout"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            l2 = Long.parseLong(properties.getProperty("repeat_interval"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(properties.getProperty("repeat_count"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClusterDiscovery clusterDiscovery = new ClusterDiscovery();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            clusterDiscovery.addBrokerAddress(string4);
            vector.add(string4);
        }
        for (int i = 0; n < 0 || i < n; ++i) {
            if (string2 == null) {
                for (int j = 0; j < vector.size(); ++j) {
                    try {
                        clusterDiscovery.discover((String)vector.elementAt(j));
                    }
                    catch (ConnectException connectException) {
                        System.out.println("Broker [" + (String)vector.elementAt(j) + "] is down.");
                        continue;
                    }
                    System.out.println("\n---------------------------------------------");
                    System.out.println((String)vector.elementAt(j) + " :");
                    clusterDiscovery.st.dumpServiceTable();
                }
                System.out.println();
            } else {
                String string5 = clusterDiscovery.findService(string2, string3, l);
                System.out.println("Address = " + string5);
            }
            try {
                Thread.sleep(l2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

