/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerCObj;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.util.BytesField;
import com.sun.messaging.jmq.admin.apps.console.util.IntegerField;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.apps.console.util.SpecialValueField;
import com.sun.messaging.jmq.admin.apps.console.util.TimeField;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.SizeString;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class BrokerQueryDialog
extends AdminDialog
implements BrokerConstants,
ActionListener {
    private static final String UNLIMITED_VALUE_0 = "0";
    private static final String UNLIMITED_VALUE_NEG1 = "-1";
    private static final String OFF_VALUE = "0";
    private static AdminResources ar = Globals.getAdminResources();
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private Properties savedBkrProps;
    private JTabbedPane tabbedPane;
    private JLabel versionLbl;
    private JLabel instanceNameLbl;
    private IntegerField portTF;
    private JCheckBox autoCreateTopicCkb;
    private JCheckBox autoCreateQueueCkb;
    private IntegerField activeConsumerIF;
    private LabelledComponent activeConsumerLabelC;
    private SpecialValueField activeConsumerSF;
    private IntegerField failoverConsumerIF;
    private LabelledComponent failoverConsumerLabelC;
    private SpecialValueField failoverConsumerSF;
    private JComboBox logLevelCb;
    private BytesField logRolloverSizeBF;
    private SpecialValueField logRolloverSizeSF;
    private TimeField logRolloverIntervalTF;
    private SpecialValueField logRolloverIntervalSF;
    private IntegerField maxNumMsgsInMemDskTF;
    private SpecialValueField maxNumMsgsInMemDskSF;
    private BytesField maxTtlSizeMsgsInMemDskBF;
    private SpecialValueField maxTtlSizeMsgsInMemDskSF;
    private BytesField maxMsgSizeBF;
    private SpecialValueField maxMsgSizeSF;

    public BrokerQueryDialog(Frame frame) {
        super(frame, acr.getString("A1159"), 81);
        this.setHelpId("broker_configuration");
    }

    public void doCancel() {
        this.hide();
    }

    public void doOK() {
        Properties properties = new Properties();
        String string = this.portTF.getText();
        this.setIfNotModified(properties, "imq.portmapper.port", string);
        string = this.autoCreateTopicCkb.isSelected() ? "true" : "false";
        this.setIfNotModified(properties, "imq.autocreate.topic", string);
        string = this.autoCreateQueueCkb.isSelected() ? "true" : "false";
        this.setIfNotModified(properties, "imq.autocreate.queue", string);
        string = this.activeConsumerSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.activeConsumerIF.getText();
        this.setIfNotModified(properties, "imq.autocreate.queue.maxNumActiveConsumers", string);
        string = this.failoverConsumerSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.failoverConsumerIF.getText();
        this.setIfNotModified(properties, "imq.autocreate.queue.maxNumBackupConsumers", string);
        string = (String)this.logLevelCb.getSelectedItem();
        this.setIfNotModified(properties, "imq.log.level", string);
        string = this.logRolloverSizeSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : Long.toString(this.logRolloverSizeBF.getValue());
        this.setIfNotModified(properties, "imq.log.file.rolloverbytes", string);
        string = this.logRolloverIntervalSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : Long.toString(this.logRolloverIntervalTF.getValue() / 1000L);
        this.setIfNotModified(properties, "imq.log.file.rolloversecs", string);
        string = this.maxNumMsgsInMemDskSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.maxNumMsgsInMemDskTF.getText();
        this.setIfNotModified(properties, "imq.system.max_count", string);
        string = this.maxTtlSizeMsgsInMemDskSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.maxTtlSizeMsgsInMemDskBF.getSizeString();
        this.setIfNotModified(properties, "imq.system.max_size", string);
        string = this.maxMsgSizeSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.maxMsgSizeBF.getSizeString();
        this.setIfNotModified(properties, "imq.message.max_size", string);
        BrokerAdminEvent brokerAdminEvent = new BrokerAdminEvent(this, 4);
        brokerAdminEvent.setBrokerProps(properties);
        brokerAdminEvent.setOKAction(true);
        this.fireAdminEventDispatched(brokerAdminEvent);
    }

    private void setIfNotModified(Properties properties, String string, String string2) {
        String string3 = this.savedBkrProps.getProperty(string, "");
        if (!string3.equals(string2)) {
            properties.setProperty(string, string2);
        }
    }

    public void doClose() {
    }

    public void doApply() {
    }

    public void doReset() {
    }

    public void doClear() {
    }

    public JPanel createWorkPanel() {
        JPanel jPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        JPanel jPanel2 = this.makeBasicTab();
        this.tabbedPane.addTab(acr.getString("A1454"), jPanel2);
        jPanel2 = this.makeLogTab();
        this.tabbedPane.addTab(acr.getString("A1455"), jPanel2);
        jPanel2 = this.makeMsgTab();
        this.tabbedPane.addTab(acr.getString("A1456"), jPanel2);
        jPanel.add(this.tabbedPane);
        return jPanel;
    }

    public JPanel makeBasicTab() {
        LabelledComponent labelledComponent;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        LabelledComponent[] labelledComponentArray = new LabelledComponent[7];
        this.versionLbl = new JLabel();
        labelledComponentArray[0] = labelledComponent = new LabelledComponent(acr.getString("A1457"), this.versionLbl);
        this.instanceNameLbl = new JLabel();
        labelledComponentArray[1] = labelledComponent = new LabelledComponent(acr.getString("A1411"), this.instanceNameLbl);
        this.portTF = new IntegerField(0L, Integer.MAX_VALUE, 10);
        labelledComponentArray[2] = labelledComponent = new LabelledComponent(acr.getString("A1404"), this.portTF);
        this.autoCreateTopicCkb = new JCheckBox();
        labelledComponentArray[3] = labelledComponent = new LabelledComponent(acr.getString("A1412"), this.autoCreateTopicCkb);
        this.autoCreateQueueCkb = new JCheckBox();
        this.autoCreateQueueCkb.addActionListener(this);
        labelledComponentArray[4] = labelledComponent = new LabelledComponent(acr.getString("A1413"), this.autoCreateQueueCkb);
        this.activeConsumerIF = new IntegerField(0L, Integer.MAX_VALUE, 10);
        this.activeConsumerSF = new SpecialValueField(this.activeConsumerIF, acr.getString("A1433"));
        labelledComponentArray[5] = this.activeConsumerLabelC = new LabelledComponent(acr.getString("A1461"), (JComponent)this.activeConsumerSF, 0);
        this.failoverConsumerIF = new IntegerField(0L, Integer.MAX_VALUE, 10);
        this.failoverConsumerSF = new SpecialValueField(this.failoverConsumerIF, acr.getString("A1433"));
        labelledComponentArray[6] = this.failoverConsumerLabelC = new LabelledComponent(acr.getString("A1462"), (JComponent)this.failoverConsumerSF, 0);
        LabelValuePanel labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 5);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        return jPanel;
    }

    public JPanel makeLogTab() {
        LabelledComponent labelledComponent;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        LabelledComponent[] labelledComponentArray = new LabelledComponent[3];
        this.logLevelCb = new JComboBox<String>(BrokerConstants.BKR_LOG_LEVEL_VALID_VALUES);
        labelledComponentArray[0] = labelledComponent = new LabelledComponent(acr.getString("A1414"), this.logLevelCb);
        this.logRolloverSizeBF = new BytesField(0L, Integer.MAX_VALUE, "0", 10);
        this.logRolloverSizeSF = new SpecialValueField(this.logRolloverSizeBF, acr.getString("A1433"));
        labelledComponentArray[1] = labelledComponent = new LabelledComponent(acr.getString("A1415"), (JComponent)this.logRolloverSizeSF, 0);
        this.logRolloverIntervalTF = new TimeField(Integer.MAX_VALUE, "0", 10);
        this.logRolloverIntervalSF = new SpecialValueField(this.logRolloverIntervalTF, acr.getString("A1433"));
        labelledComponentArray[2] = labelledComponent = new LabelledComponent(acr.getString("A1416"), (JComponent)this.logRolloverIntervalSF, 0);
        LabelValuePanel labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 5);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        return jPanel;
    }

    public JPanel makeMsgTab() {
        LabelledComponent labelledComponent;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        LabelledComponent[] labelledComponentArray = new LabelledComponent[3];
        this.maxNumMsgsInMemDskTF = new IntegerField(0L, Integer.MAX_VALUE, 10);
        this.maxNumMsgsInMemDskSF = new SpecialValueField(this.maxNumMsgsInMemDskTF, acr.getString("A1433"));
        labelledComponentArray[0] = labelledComponent = new LabelledComponent(acr.getString("A1420"), (JComponent)this.maxNumMsgsInMemDskSF, 0);
        this.maxTtlSizeMsgsInMemDskBF = new BytesField(0L, Integer.MAX_VALUE, "0", 10);
        this.maxTtlSizeMsgsInMemDskSF = new SpecialValueField(this.maxTtlSizeMsgsInMemDskBF, acr.getString("A1433"));
        labelledComponentArray[1] = labelledComponent = new LabelledComponent(acr.getString("A1421"), (JComponent)this.maxTtlSizeMsgsInMemDskSF, 0);
        this.maxMsgSizeBF = new BytesField(0L, Integer.MAX_VALUE, "0", 10);
        this.maxMsgSizeSF = new SpecialValueField(this.maxMsgSizeBF, acr.getString("A1433"));
        labelledComponentArray[2] = labelledComponent = new LabelledComponent(acr.getString("A1422"), (JComponent)this.maxMsgSizeSF, 0);
        LabelValuePanel labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 5);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        return jPanel;
    }

    private void makeReadOnly() {
        this.portTF.setEditable(false);
    }

    public void show(BrokerCObj brokerCObj) {
        this.reset();
        this.setBrokerProps(brokerCObj.getBrokerProps());
        this.tabbedPane.setSelectedIndex(0);
        this.pack();
        super.show();
    }

    private void setBrokerProps(Properties properties) {
        this.savedBkrProps = properties;
        if (properties == null) {
            return;
        }
        String string = properties.getProperty("imq.product.version", "");
        if (string.equals("")) {
            string = acr.getString("A1458");
        }
        this.versionLbl.setText(string);
        string = properties.getProperty("imq.instancename", "");
        this.instanceNameLbl.setText(string);
        string = properties.getProperty("imq.portmapper.port", "");
        this.portTF.setText(string);
        string = properties.getProperty("imq.autocreate.topic", "");
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t")) {
            this.autoCreateTopicCkb.setSelected(true);
        } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f")) {
            this.autoCreateTopicCkb.setSelected(false);
        }
        string = properties.getProperty("imq.autocreate.queue", "");
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t")) {
            this.autoCreateQueueCkb.setSelected(true);
            this.showQueueDeliveryPolicy();
        } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f")) {
            this.autoCreateQueueCkb.setSelected(false);
            this.hideQueueDeliveryPolicy();
        }
        string = properties.getProperty("imq.autocreate.queue.maxNumActiveConsumers", "");
        this.activeConsumerIF.setText("0");
        if (!string.equals(UNLIMITED_VALUE_NEG1)) {
            this.activeConsumerIF.setText(string);
        }
        this.checkUnlimitedNeg1(this.activeConsumerSF, string);
        string = properties.getProperty("imq.autocreate.queue.maxNumBackupConsumers", "");
        this.failoverConsumerIF.setText("0");
        if (!string.equals(UNLIMITED_VALUE_NEG1)) {
            this.failoverConsumerIF.setText(string);
        }
        this.checkUnlimitedNeg1(this.failoverConsumerSF, string);
        string = properties.getProperty("imq.log.level", "");
        this.logLevelCb.setSelectedItem(string);
        string = properties.getProperty("imq.log.file.rolloverbytes", "");
        if (!string.equals(UNLIMITED_VALUE_NEG1) && !string.equals("0")) {
            this.logRolloverSizeBF.setSizeString(string);
        }
        this.checkBothUnlimited(this.logRolloverSizeSF, string);
        string = properties.getProperty("imq.log.file.rolloversecs", "");
        if (!string.equals(UNLIMITED_VALUE_NEG1) && !string.equals("0")) {
            this.logRolloverIntervalTF.setText(string);
        }
        this.checkBothUnlimited(this.logRolloverIntervalSF, string);
        string = properties.getProperty("imq.system.max_count", "");
        if (!string.equals(UNLIMITED_VALUE_NEG1) && !string.equals("0")) {
            this.maxNumMsgsInMemDskTF.setText(string);
        }
        this.checkBothUnlimited(this.maxNumMsgsInMemDskSF, string);
        string = properties.getProperty("imq.system.max_size", "");
        if (!string.equals(UNLIMITED_VALUE_NEG1) && !string.equals("0")) {
            this.maxTtlSizeMsgsInMemDskBF.setSizeString(string);
        }
        this.checkBothUnlimited(this.maxTtlSizeMsgsInMemDskSF, string);
        string = properties.getProperty("imq.message.max_size", "");
        if (!string.equals(UNLIMITED_VALUE_NEG1) && !string.equals("0")) {
            this.maxMsgSizeBF.setSizeString(string);
        }
        this.checkBothUnlimited(this.maxMsgSizeSF, string);
    }

    private void checkUnlimited0(SpecialValueField specialValueField, String string) {
        if (this.valueIsUnlimited0(string)) {
            specialValueField.setSpecialValueSet(true);
        } else {
            specialValueField.setSpecialValueSet(false);
        }
    }

    private boolean valueIsUnlimited0(String string) {
        SizeString sizeString;
        try {
            sizeString = new SizeString(string);
        }
        catch (Exception exception) {
            return false;
        }
        return sizeString.getBytes() == 0L;
    }

    private void checkUnlimitedNeg1(SpecialValueField specialValueField, String string) {
        if (this.valueIsUnlimitedNeg1(string)) {
            specialValueField.setSpecialValueSet(true);
        } else {
            specialValueField.setSpecialValueSet(false);
        }
    }

    private boolean valueIsUnlimitedNeg1(String string) {
        return string.equals(UNLIMITED_VALUE_NEG1);
    }

    private void checkBothUnlimited(SpecialValueField specialValueField, String string) {
        if (this.valueIsUnlimited0(string) || this.valueIsUnlimitedNeg1(string)) {
            specialValueField.setSpecialValueSet(true);
        } else {
            specialValueField.setSpecialValueSet(false);
        }
    }

    private void checkOff(SpecialValueField specialValueField, String string) {
        if (this.valueIsOff(string)) {
            specialValueField.setSpecialValueSet(true);
        } else {
            specialValueField.setSpecialValueSet(false);
        }
    }

    private boolean valueIsOff(String string) {
        return string.equals("0");
    }

    private void reset() {
        this.instanceNameLbl.setText("");
        this.portTF.setText("");
        this.autoCreateTopicCkb.setSelected(true);
        this.autoCreateQueueCkb.setSelected(true);
        this.logLevelCb.setSelectedItem("INFO");
        this.logRolloverSizeBF.setText("0");
        this.logRolloverSizeBF.setUnit(0);
        this.logRolloverIntervalTF.setText("");
        this.logRolloverIntervalTF.setUnit(1);
        this.maxNumMsgsInMemDskTF.setText("");
        this.maxTtlSizeMsgsInMemDskBF.setText("0");
        this.maxTtlSizeMsgsInMemDskBF.setUnit(0);
        this.maxMsgSizeBF.setText("0");
        this.maxMsgSizeBF.setUnit(0);
    }

    private void showQueueDeliveryPolicy() {
        this.activeConsumerLabelC.setEnabled(true);
        this.activeConsumerIF.setEnabled(true);
        this.activeConsumerSF.setEnabled(true);
        this.failoverConsumerLabelC.setEnabled(true);
        this.failoverConsumerIF.setEnabled(true);
        this.failoverConsumerSF.setEnabled(true);
    }

    private void hideQueueDeliveryPolicy() {
        this.activeConsumerLabelC.setEnabled(false);
        this.activeConsumerIF.setEnabled(false);
        this.activeConsumerSF.setEnabled(false);
        this.failoverConsumerLabelC.setEnabled(false);
        this.failoverConsumerIF.setEnabled(false);
        this.failoverConsumerSF.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.autoCreateQueueCkb) {
            if (this.autoCreateQueueCkb.isSelected()) {
                this.showQueueDeliveryPolicy();
            } else {
                this.hideQueueDeliveryPolicy();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

