/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Vector;

public class LocalStringsManagerFactory {
    private static HashMap stringManagers = new HashMap();
    private static String PROPERTY_FILE = "LocalStrings";
    private static final String FRAMEWORK_BASE_PACKAGE = "com.sun.enterprise.cli.framework";
    private static LocalStringsManager commandLocalStringsManager = null;

    protected LocalStringsManagerFactory() {
    }

    public static void setInstance(String packageName, LocalStringsManager stringsManager) {
        stringManagers.put(packageName, stringsManager);
    }

    public static LocalStringsManager getLocalStringsManager(String packageName, String propertiesFileName) throws CommandValidationException {
        LocalStringsManager stringsManager = (LocalStringsManager)stringManagers.get(packageName);
        if (stringsManager == null || !stringsManager.getPropertiesFile().equals(propertiesFileName)) {
            try {
                stringsManager = new LocalStringsManager(packageName, propertiesFileName);
                stringManagers.put(packageName, stringsManager);
            }
            catch (MissingResourceException mre) {
                throw new CommandValidationException(mre.getLocalizedMessage(), mre);
            }
        }
        return stringsManager;
    }

    public static LocalStringsManager getFrameworkLocalStringsManager() throws CommandValidationException {
        return LocalStringsManagerFactory.getLocalStringsManager(FRAMEWORK_BASE_PACKAGE, PROPERTY_FILE);
    }

    public static void setCommandLocalStringsManagerProperties(Iterator propertiesIter) throws CommandValidationException {
        Vector<Properties> localizePropertiesList = new Vector<Properties>();
        while (propertiesIter.hasNext()) {
            Properties localizeProperties = new Properties();
            Properties properties = (Properties)propertiesIter.next();
            String basePackage = properties.getProperty("base-package");
            String propertyFile = properties.getProperty("property-file-name", PROPERTY_FILE);
            if (basePackage == null || basePackage.equals("")) continue;
            CLILogger.getInstance().printDebugMessage("basePackage: " + basePackage);
            CLILogger.getInstance().printDebugMessage("propertyFile: " + propertyFile);
            localizeProperties.setProperty("base-package", basePackage);
            localizeProperties.setProperty("property-file-name", propertyFile);
            localizePropertiesList.add(localizeProperties);
        }
        if (localizePropertiesList.size() > 0) {
            commandLocalStringsManager = new LocalStringsManager(localizePropertiesList);
        }
    }

    public static LocalStringsManager getCommandLocalStringsManager() throws CommandValidationException {
        if (commandLocalStringsManager == null) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(lsm.getString("CouldNotFindLocalStringsProperties"));
        }
        return commandLocalStringsManager;
    }
}

