/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.config.serverbeans.validation.DomainXmlVerifier;
import java.io.File;

public class VerifyDomainXmlCommand
extends BaseLifeCycleCommand {
    private static final String VERBOSE = "verbose";
    private static final String DOMAINDIR = "domaindir";
    private static final String CONFIG = "config";
    private static final String DOMAIN_XML = "domain.xml";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        boolean verbose = this.getBooleanOption(VERBOSE);
        String domainXMLFile = this.getDomainXMLFile();
        File f = new File(domainXMLFile);
        if (!f.exists()) {
            throw new CommandException(this.getLocalizedString("DomainXMLDoesNotExist", new Object[]{this.getDomainName()}));
        }
        try {
            DomainXmlVerifier validator = new DomainXmlVerifier(domainXMLFile);
            validator.setDebug(verbose);
            validator.invokeConfigValidator();
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    private String getDomainXMLFile() throws CommandException {
        String domainDir = this.getDomainsRoot();
        String domainName = this.getDomainName();
        String domainXMLFile = domainDir + File.separator + domainName + File.separator + CONFIG + File.separator + DOMAIN_XML;
        CLILogger.getInstance().printDebugMessage("Domain XML file = " + domainXMLFile);
        return domainXMLFile;
    }
}

