/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.NameClassPair;

public class ListJNDIEntriesCommand
extends GenericCommand {
    private static final String CONTEXT_OPTION = "context";

    public void displayExceptionMessage(Exception e) throws CommandException {
        Throwable t = e.getCause();
        if (t != null) {
            CLILogger.getInstance().printDetailMessage(t.getMessage());
        } else if (e != null) {
            CLILogger.getInstance().printDetailMessage(e.getMessage());
        }
        throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
    }

    protected void handleReturnValue(Object retVal) {
        ArrayList list = (ArrayList)retVal;
        if (!list.isEmpty()) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JndiEntries", new Object[]{(String)this.getOperands().get(0), this.getOption(CONTEXT_OPTION) == null ? "root" : this.getOption(CONTEXT_OPTION)}));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NameClassPair nameClassPair = (NameClassPair)iterator.next();
                CLILogger.getInstance().printMessage(this.getLocalizedString("NameClassPair", new Object[]{nameClassPair.getName(), nameClassPair.getClassName()}));
            }
        }
    }
}

