/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class GenericCommand
extends S1ASCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        try {
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            this.handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    public void displayExceptionMessage(Exception e) throws CommandException {
        if (e.getLocalizedMessage() != null) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
        }
        throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
    }

    private void printDebug(MBeanServerConnection mbsc, String objectName) throws Exception {
        CLILogger.getInstance().printDebugMessage("********** queryNames **********");
        CLILogger.getInstance().printDebugMessage("LIST OF ALL REGISTERED MBEANS:");
        Set<ObjectName> allMBeans = mbsc.queryNames(null, null);
        int jj = 1;
        Iterator<ObjectName> ii = allMBeans.iterator();
        while (ii.hasNext()) {
            ObjectName name = ii.next();
            CLILogger.getInstance().printDebugMessage("(" + jj++ + ")  " + name.toString());
        }
        CLILogger.getInstance().printDebugMessage("********** getMBeanInfo **********");
        MBeanInfo mbinfo = mbsc.getMBeanInfo(new ObjectName(objectName));
        CLILogger.getInstance().printDebugMessage("Description = " + mbinfo.getDescription());
        CLILogger.getInstance().printDebugMessage("Classname = " + mbinfo.getClassName());
        MBeanOperationInfo[] mboinfo = mbinfo.getOperations();
        for (int ii2 = 0; ii2 < mboinfo.length; ++ii2) {
            CLILogger.getInstance().printDebugMessage("(" + ii2 + ") Description = " + mboinfo[ii2].getDescription());
            CLILogger.getInstance().printDebugMessage("(" + ii2 + ") Name = " + mboinfo[ii2].getName());
        }
    }
}

