/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import [Ljavax.management.Attribute;;
import com.sun.enterprise.admin.util.ArrayConversion;
import com.sun.enterprise.admin.util.ClassUtil;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class DottedNamesCommand
extends S1ASCommand {
    private static final String GET_COMMAND = "get";
    private static final String SET_COMMAND = "set";
    private static final String LIST_COMMAND = "list";
    private static final String GET_OPERATION = "dottedNameGet";
    private static final String LIST_OPERATION = "dottedNameList";
    private static final String GET_MONITORING_OPERATION = "dottedNameMonitoringGet";
    private static final String LIST_MONITORING_OPERATION = "dottedNameMonitoringList";
    private static final String SET_OPERATION = "dottedNameSet";
    private static final String MONITOR_OPTION = "monitor";
    private static final String OBJECT_NAME = "com.sun.appserv:name=dotted-name-get-set,type=dotted-name-support";
    private static final String INTERVAL_OPTION = "interval";
    private static final String ITERATIONS_OPTION = "iterations";
    private static final String PROPERTY_STRING = "property|system-property";
    private static String INNER_ARRAY_DELIM;
    private static String OUTER_ARRAY_DELIM;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean validateOptions() throws CommandValidationException {
        if (!(!this.getOperation().equals(GET_MONITORING_OPERATION) || this.isIntervalValid() && this.isIterationValid())) {
            return false;
        }
        return super.validateOptions();
    }

    private boolean isIntervalValid() {
        String interval = this.getOption(INTERVAL_OPTION);
        if (interval == null) {
            return true;
        }
        if (interval != null && Integer.parseInt(interval) > 0) {
            return true;
        }
        this.printMessage(this.getLocalizedString("InvalidInterval", new Object[]{interval}));
        return false;
    }

    private boolean isIterationValid() {
        String iterations = this.getOption(ITERATIONS_OPTION);
        if (iterations == null) {
            return true;
        }
        if (iterations != null && Integer.parseInt(iterations) > 0) {
            return true;
        }
        this.printMessage(this.getLocalizedString("InvalidIterations", new Object[]{iterations}));
        return false;
    }

    private Attribute[] collectAllAttributes(Object[] results) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (int i = 0; i < results.length; ++i) {
            Object result = results[i];
            if (result instanceof Attribute) {
                attrs.put(((Attribute)result).getName(), result);
                continue;
            }
            if (result instanceof Attribute[]) {
                Attribute[] list = (Attribute[])result;
                for (int attrIndex = 0; attrIndex < list.length; ++attrIndex) {
                    Attribute attr = list[attrIndex];
                    attrs.put(attr.getName(), attr);
                }
                continue;
            }
            if (!$assertionsDisabled && !(result instanceof Exception)) {
                throw new AssertionError();
            }
        }
        Attribute[] attrsArray = new Attribute[attrs.size()];
        attrs.values().toArray(attrsArray);
        Arrays.sort(attrsArray, new AttributeComparator());
        return attrsArray;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        Object[] params = this.getDottedNamesParam(!this.getName().equals(LIST_COMMAND));
        String[] types = new String[]{STRING_ARRAY};
        String operationName = this.getOperation();
        String interval = this.getOption(INTERVAL_OPTION);
        String iterations = this.getOption(ITERATIONS_OPTION);
        try {
            Object[] returnValues = (Object[])mbsc.invoke(new ObjectName(OBJECT_NAME), operationName, params, types);
            if (operationName.indexOf("List") >= 0) {
                this.displayResultFromList((String[])returnValues);
            } else if (operationName.equals(GET_MONITORING_OPERATION) && interval != null && iterations != null) {
                String[] userArgs = (String[])params[0];
                this.displayResultFromGetOrSet(userArgs, returnValues);
                long interval_millis = Integer.parseInt(interval) * 1000;
                int counter = Integer.parseInt(iterations);
                int i = 1;
                do {
                    this.printMessage("\n");
                    if (i >= counter) continue;
                    try {
                        Thread.currentThread();
                        Thread.sleep(interval_millis);
                        Object[] retVals = (Object[])mbsc.invoke(new ObjectName(OBJECT_NAME), operationName, params, types);
                        userArgs = (String[])params[0];
                        this.displayResultFromGetOrSet(userArgs, retVals);
                        ++i;
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                } while (i < counter);
            } else {
                String[] userArgs = (String[])params[0];
                this.displayResultFromGetOrSet(userArgs, returnValues);
            }
        }
        catch (Exception e) {
            String msg = this.getExceptionMessage(e);
            if (msg != null) {
                CLILogger.getInstance().printDetailMessage(msg);
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
    }

    private Object[] getDottedNamesParam(boolean convertUnderscore) {
        Vector dottedNames = this.getOperands();
        String[] dottedNamesArray = new String[dottedNames.size()];
        for (int ii = 0; ii < dottedNames.size(); ++ii) {
            dottedNamesArray[ii] = convertUnderscore ? this.convertUnderscoreToHyphen((String)dottedNames.get(ii)) : (String)dottedNames.get(ii);
        }
        return new Object[]{dottedNamesArray};
    }

    private String getOperation() {
        if (this.getName().equals(SET_COMMAND)) {
            return SET_OPERATION;
        }
        if (this.getName().equals(GET_COMMAND)) {
            if (this.getBooleanOption(MONITOR_OPTION)) {
                return GET_MONITORING_OPERATION;
            }
            return GET_OPERATION;
        }
        if (this.getName().equals(LIST_COMMAND)) {
            if (this.getBooleanOption(MONITOR_OPTION)) {
                return LIST_MONITORING_OPERATION;
            }
            return LIST_OPERATION;
        }
        return null;
    }

    private void printMessage(String msg) {
        CLILogger.getInstance().printMessage(msg);
    }

    private String getExceptionMessage(Exception e) {
        String msg = null;
        if (e instanceof RuntimeMBeanException) {
            RuntimeMBeanException rmbe = (RuntimeMBeanException)e;
            msg = rmbe.getTargetException().getLocalizedMessage();
        } else if (e instanceof RuntimeOperationsException) {
            RuntimeOperationsException roe = (RuntimeOperationsException)e;
            msg = roe.getTargetException().getLocalizedMessage();
        } else {
            msg = e.getLocalizedMessage();
        }
        if (msg == null || msg.length() == 0) {
            msg = e.getMessage();
        }
        if (msg == null || msg.length() == 0) {
            msg = e.getClass().getName();
        }
        return msg;
    }

    private void displayResultFromGetOrSet(String[] inputs, Object[] returnValues) throws Exception {
        if (returnValues.length == 1) {
            Object result = returnValues[0];
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            if (result.getClass() == Attribute;.class) {
                Attribute[] attrs = (Attribute[])result;
                if (attrs.length == 0) {
                    throw new AttributeNotFoundException(this.getLocalizedString("NoWildcardMatches"));
                }
                this.printMessage(this.stringify(attrs, OUTER_ARRAY_DELIM));
            } else {
                this.printMessage(this.stringify(result, OUTER_ARRAY_DELIM));
            }
        } else {
            Attribute[] attrs = this.collectAllAttributes(returnValues);
            this.printMessage(this.stringify(attrs, OUTER_ARRAY_DELIM));
            for (int i = 0; i < returnValues.length; ++i) {
                if (!(returnValues[i] instanceof Exception)) continue;
                Exception e = (Exception)returnValues[i];
                String msg = this.getLocalizedString("ErrorInGetSet", new Object[]{inputs[i], this.getExceptionMessage(e)});
                this.printMessage(msg);
            }
        }
    }

    private String stringifyArray(Object[] a, String delim) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            buf.append(this.stringify(a[i], INNER_ARRAY_DELIM));
            if (i == a.length - 1) continue;
            buf.append(delim);
        }
        return buf.toString();
    }

    private String stringify(Object o) {
        return this.stringify(o, "\n");
    }

    private String stringify(Object o, String delim) {
        String result = null;
        if (o == null) {
            result = "";
        } else if (o instanceof Attribute) {
            Attribute attr = (Attribute)o;
            result = attr.getName() + " = " + this.stringify(attr.getValue(), INNER_ARRAY_DELIM);
        } else if (ClassUtil.objectIsPrimitiveArray((Object)o)) {
            Object[] objectList = ArrayConversion.toAppropriateType((Object)o);
            result = this.stringifyArray(objectList, delim);
        } else if (ClassUtil.objectIsArray((Object)o)) {
            result = this.stringifyArray((Object[])o, delim);
        } else if (o instanceof Exception) {
            Exception e = (Exception)o;
            result = this.getExceptionMessage(e);
        } else {
            result = o.toString();
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return result;
    }

    private void displayResultFromList(String[] result) {
        if (result.length == 0) {
            String displayOperands = this.stringify(this.getDottedNamesParam(true), INNER_ARRAY_DELIM);
            this.printMessage(this.getLocalizedString("EmptyList", new Object[]{displayOperands}));
        } else {
            this.printMessage(this.stringify(result, OUTER_ARRAY_DELIM));
        }
    }

    public String convertUnderscoreToHyphen(String param) {
        int begIndex;
        int endIndex = param.indexOf(61);
        int n = begIndex = endIndex > 0 ? param.lastIndexOf(46, endIndex) : param.lastIndexOf(46);
        if (begIndex < 1 || this.checkPropertyToConvert(param.substring(0, begIndex))) {
            return param;
        }
        if (endIndex > 0) {
            return param.substring(0, begIndex) + param.substring(begIndex, endIndex).replace('_', '-') + param.substring(endIndex);
        }
        return param.substring(0, begIndex) + param.substring(begIndex).replace('_', '-');
    }

    public boolean checkPropertyToConvert(String param) {
        int index = param.lastIndexOf(46);
        if (index < 0) {
            return false;
        }
        String elementName = param.substring(index + 1);
        return elementName.matches(PROPERTY_STRING);
    }

    static {
        $assertionsDisabled = !DottedNamesCommand.class.desiredAssertionStatus();
        INNER_ARRAY_DELIM = ",";
        OUTER_ARRAY_DELIM = System.getProperty("line.separator");
    }

    private final class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Attribute attr1 = (Attribute)o1;
            Attribute attr2 = (Attribute)o2;
            return attr1.getName().compareTo(attr2.getName());
        }

        public boolean equals(Object other) {
            return other instanceof AttributeComparator;
        }
    }
}

