/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.ArchiveFactory;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.Target;

public class DeployCommand
extends S1ASCommand {
    private static final String TARGET_OPTION = "target";
    private static final String CONTEXT_ROOT_OPTION = "contextroot";
    private static final String FORCE_OPTION = "force";
    private static final String PRECOMPILE_JSP_OPTION = "precompilejsp";
    private static final String VERIFY_OPTION = "verify";
    private static final String UPLOAD_OPTION = "upload";
    private static final String ENABLED_OPTION = "enabled";
    private static final String COMPONENT_NAME = "name";
    private static final String RETRIEVE_DIR = "retrieve";
    private static final String VIRTUALSERVERS_OPTION = "virtualservers";
    private static final String DB_VENDOR_NAME_OPTION = "dbvendorname";
    private static final String CREATE_TABLES_OPTION = "createtables";
    private static final String DROP_AND_CREATE_TABLES_OPTION = "dropandcreatetables";
    private static final String UNIQUE_TABLENAMES_OPTION = "uniquetablenames";
    private static final String DEPLOYMENTPLAN_OPTION = "deploymentplan";
    private static final String AVAILABILITY_ENABLED_OPTION = "availabilityenabled";
    private static final String GENERATE_RMI_STUBS_OPTION = "generatermistubs";
    private String filePath = null;
    private String serverFilePath = null;
    private boolean isUpload = false;
    private String componentName = null;

    public void runCommand() throws CommandException, CommandValidationException {
        String retrievePath;
        this.validateOptions();
        DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
        ServerConnectionIdentifier conn = this.createServerConnectionIdentifier(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        df.connect(conn);
        String targetName = this.getOption(TARGET_OPTION);
        String deploymentPlan = this.getOption(DEPLOYMENTPLAN_OPTION);
        JESProgressObject progressObject = null;
        try {
            AbstractArchive arch = new ArchiveFactory().openArchive(this.filespecToJarURI(this.filePath));
            AbstractArchive plan = null;
            if (deploymentPlan != null) {
                plan = new ArchiveFactory().openArchive(this.filespecToJarURI(deploymentPlan));
            }
            Map deployOptions = this.createDeploymentProperties();
            if (df.isConnected()) {
                Target[] targets = df.createTargets(new String[]{targetName});
                if (targets == null) {
                    throw new CommandException(this.getLocalizedString("InvalidTarget", new Object[]{targetName}));
                }
                progressObject = df.deploy(targets, (Archive)arch, (Archive)plan, deployOptions);
            } else {
                CLILogger.getInstance().printError(this.getLocalizedString("CouldNotConnectToDAS"));
            }
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
        DeploymentStatus status = df.waitFor(progressObject);
        String statusString = status.getStageStatusMessage();
        if (status != null && status.getStatus() == 0) {
            this.checkDeployStatus(status, statusString);
        }
        if ((retrievePath = this.getOption(RETRIEVE_DIR)) != null) {
            try {
                CLILogger.getInstance().printDebugMessage("componentName = " + this.componentName + " retrievePath = " + retrievePath);
                String fileName = df.downloadFile(new File(retrievePath), this.componentName, null);
                CLILogger.getInstance().printDebugMessage("downloaded stubs to  : " + fileName);
            }
            catch (Exception e) {
                throw new CommandException(this.getLocalizedString("InvalidValueInOption", new Object[]{RETRIEVE_DIR, retrievePath}) + "\n" + e.getLocalizedMessage());
            }
        }
        if (status != null && status.getStatus() == 1) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessfulWithMsg", new Object[]{this.name, statusString}));
        } else {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
    }

    private URI filespecToJarURI(String fileSpec) throws URISyntaxException {
        File archiveFile = new File(fileSpec);
        String prefix = archiveFile.isDirectory() ? "file" : "jar";
        URI archiveFileURI = archiveFile.toURI();
        URI archiveJarURI = new URI(prefix, "", archiveFileURI.getSchemeSpecificPart(), null, null);
        return archiveJarURI;
    }

    private Map createDeploymentProperties() {
        String virtualServers = this.getOption(VIRTUALSERVERS_OPTION);
        String contextRoot = this.getContextRoot();
        String dbVendorName = this.getOption(DB_VENDOR_NAME_OPTION);
        String createTable = this.getOption(CREATE_TABLES_OPTION);
        String dropCreateTable = this.getOption(DROP_AND_CREATE_TABLES_OPTION);
        String uniqueTableNames = this.getOption(UNIQUE_TABLENAMES_OPTION);
        String target = this.getOption(TARGET_OPTION);
        Properties props = new Properties();
        if (props != null) {
            props.put(TARGET_OPTION, target);
        }
        if (this.serverFilePath != null && this.isUpload) {
            props.put("archiveName", this.serverFilePath);
        } else if (this.filePath != null) {
            props.put("archiveName", this.filePath);
        }
        if (contextRoot != null) {
            props.put("contextRoot", contextRoot);
        }
        if (virtualServers != null) {
            props.put(VIRTUALSERVERS_OPTION, virtualServers);
        }
        if (dbVendorName != null) {
            props.put("CmpInfo.dbVendorName", dbVendorName);
        }
        if (createTable != null) {
            props.put("CmpInfo.CREATE_TABLES", createTable);
        }
        if (dropCreateTable != null) {
            props.put("CmpInfo.DROP_AND_CREATE_TABLES", dropCreateTable);
        }
        if (uniqueTableNames != null) {
            props.put("CmpInfo.uniqueTableNames", uniqueTableNames);
        }
        props.put(COMPONENT_NAME, this.componentName);
        props.put(VERIFY_OPTION, this.getOption(VERIFY_OPTION));
        props.put(PRECOMPILE_JSP_OPTION, this.getOption(PRECOMPILE_JSP_OPTION));
        props.put("enable", this.getOption(ENABLED_OPTION));
        props.put(FORCE_OPTION, this.getOption(FORCE_OPTION));
        props.put(AVAILABILITY_ENABLED_OPTION, this.getOption(AVAILABILITY_ENABLED_OPTION));
        props.put(GENERATE_RMI_STUBS_OPTION, this.getOption(GENERATE_RMI_STUBS_OPTION));
        String retrievePath = this.getOption(RETRIEVE_DIR);
        if (retrievePath != null) {
            props.put("clientJarRequested", "true");
        }
        return props;
    }

    private void checkDeployStatus(DeploymentStatus status, String statusString) throws CommandException {
        if (status != null && status.getStatus() == 0) {
            throw new CommandException(this.getLocalizedString("CommandUnSuccessfulWithMsg", new Object[]{this.name, statusString}));
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        if (this.getOption(CREATE_TABLES_OPTION) != null && this.getOption(DROP_AND_CREATE_TABLES_OPTION) != null) {
            throw new CommandValidationException(this.getLocalizedString("MutuallyExclusiveOption", new Object[]{CREATE_TABLES_OPTION, DROP_AND_CREATE_TABLES_OPTION}));
        }
        this.filePath = (String)this.getOperands().get(0);
        this.isUpload = this.getOption(UPLOAD_OPTION) == null ? false : this.getBooleanOption(UPLOAD_OPTION);
        this.componentName = this.getComponentName();
        return true;
    }

    private String getContextRoot() {
        String contextRoot = this.getOption(CONTEXT_ROOT_OPTION);
        return contextRoot;
    }

    private String getComponentName() throws CommandValidationException {
        String name = this.getOption(COMPONENT_NAME);
        if (name == null) {
            name = this.getNameFromFilePath();
        }
        if (name == null || name.equals("")) {
            throw new CommandValidationException(this.getLocalizedString("ComponentNameNull"));
        }
        return name;
    }

    private String getNameFromFilePath() {
        String fileNameOperand = (String)this.getOperands().get(0);
        String fileName = new File(fileNameOperand).getName();
        int toIndex = fileName.lastIndexOf(46);
        if (toIndex < 0) {
            toIndex = fileName.length();
        }
        return fileName.substring(0, toIndex);
    }
}

