/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.pluggable.ClientPluggableFeatureFactory;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.BackupManager;
import com.sun.enterprise.config.backup.BackupRequest;
import com.sun.enterprise.config.backup.BackupWarningException;
import com.sun.enterprise.config.backup.ListManager;
import com.sun.enterprise.config.backup.RestoreManager;
import com.sun.enterprise.util.diagnostics.ObjectAnalyzer;
import java.io.File;

public class BackupCommands
extends BaseLifeCycleCommand {
    private static final String DOMAINSDIR = "domaindir";
    private static final String FILENAME = "filename";
    private static final String DESCRIPTION = "description";
    private BackupRequest request;
    private String domainName;
    private String domainsDir;
    private String backupFilename;
    private String description;
    private CmdType command;
    private boolean terse = false;
    private boolean verbose = false;

    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString((Object)this);
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        this.setOptions();
        this.checkOptions();
        this.prepareRequest();
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        block6: {
            this.validateOptions();
            try {
                if (this.command == CmdType.BACKUP) {
                    BackupManager mgr = new BackupManager(this.request);
                    CLILogger.getInstance().printMessage(mgr.backup());
                    break block6;
                }
                if (this.command == CmdType.RESTORE) {
                    RestoreManager mgr = new RestoreManager(this.request);
                    CLILogger.getInstance().printMessage(mgr.restore());
                    break block6;
                }
                if (this.command == CmdType.LIST) {
                    ListManager mgr = new ListManager(this.request);
                    CLILogger.getInstance().printMessage(mgr.list());
                    break block6;
                }
                throw new CommandException("Internal Error");
            }
            catch (BackupWarningException bwe) {
                CLILogger.getInstance().printMessage(bwe.getMessage());
            }
            catch (BackupException be) {
                throw new CommandException(be);
            }
        }
    }

    private void setOptions() throws CommandValidationException {
        this.setCommand();
        this.setDomainsDir();
        this.setDomainName();
        this.setBackupFilename();
        this.setDescription();
        this.setVerbosity();
    }

    private void setCommand() throws CommandValidationException {
        String cmd = this.getName();
        this.command = CmdType.valueOf(cmd);
        if (this.command == null) {
            throw new CommandValidationException(this.getLocalizedString("NoUsageText", new String[]{cmd}));
        }
    }

    private void setDomainName() throws CommandValidationException {
        try {
            this.domainName = this.getDomainName();
        }
        catch (CommandException ce) {
            throw new CommandValidationException(ce);
        }
    }

    private void setDomainsDir() throws CommandValidationException {
        this.domainsDir = this.getOption(DOMAINSDIR);
        if (this.domainsDir == null || this.domainsDir.length() <= 0) {
            this.domainsDir = System.getProperty("com.sun.aas.domainsRoot");
        }
    }

    private void setBackupFilename() {
        this.backupFilename = this.getOption(FILENAME);
    }

    private void setVerbosity() throws CommandValidationException {
        if (this.getBooleanOption("terse")) {
            this.terse = true;
        }
        if (this.getBooleanOption("verbose")) {
            this.verbose = true;
        }
        if (this.verbose && this.terse) {
            throw new CommandValidationException(this.getLocalizedString("NoVerboseAndTerseAtTheSameTime"));
        }
    }

    private void setDescription() {
        this.description = this.getOption(DESCRIPTION);
    }

    private void checkOptions() throws CommandValidationException {
        File f;
        boolean domainDirDoesNotHaveToExist;
        if (!(this.command != CmdType.BACKUP && this.command != CmdType.RESTORE || this.isNotRunning())) {
            throw new CommandValidationException(this.getLocalizedString("DomainIsNotStopped", new String[]{this.command.name}));
        }
        if (this.domainsDir == null || this.domainsDir.length() <= 0) {
            throw new CommandValidationException(this.getLocalizedString("InvalidDomainPath", new String[]{this.domainsDir}));
        }
        File domainsDirFile = new File(this.domainsDir);
        if (!domainsDirFile.isDirectory()) {
            throw new CommandValidationException(this.getLocalizedString("InvalidDomainPath", new String[]{this.domainsDir}));
        }
        File domainFile = new File(domainsDirFile, this.domainName);
        boolean bl = domainDirDoesNotHaveToExist = this.command == CmdType.RESTORE && this.backupFilename != null;
        if (!(domainDirDoesNotHaveToExist || domainFile.isDirectory() && domainFile.canWrite())) {
            throw new CommandValidationException(this.getLocalizedString("InvalidDirectory", new String[]{domainFile.getPath()}));
        }
        if (!(this.backupFilename == null || (f = new File(this.backupFilename)).exists() && f.canRead())) {
            throw new CommandValidationException(this.getLocalizedString("FileDoesNotExist", new String[]{this.backupFilename}));
        }
    }

    private void prepareRequest() throws CommandValidationException {
        this.request = this.backupFilename == null ? new BackupRequest(this.domainsDir, this.domainName, this.description) : new BackupRequest(this.domainsDir, this.domainName, this.description, this.backupFilename);
        this.request.setTerse(this.terse);
        this.request.setVerbose(this.verbose);
    }

    private boolean isNotRunning() throws CommandValidationException {
        try {
            ClientPluggableFeatureFactory cpff = this.getFeatureFactory();
            DomainsManager dm = cpff.getDomainsManager();
            DomainConfig dc = this.getDomainConfig(this.domainName);
            InstancesManager im = dm.getInstancesManager((RepositoryConfig)dc);
            int state = im.getInstanceStatus();
            return state == 3;
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
    }

    private static class CmdType {
        private static final CmdType BACKUP = new CmdType("backup-domain");
        private static final CmdType RESTORE = new CmdType("restore-domain");
        private static final CmdType LIST = new CmdType("list-backups");
        private final String name;

        private CmdType(String name) {
            this.name = name;
        }

        private static CmdType valueOf(String aName) {
            if (aName.equals(CmdType.BACKUP.name)) {
                return BACKUP;
            }
            if (aName.equals(CmdType.RESTORE.name)) {
                return RESTORE;
            }
            if (aName.equals(CmdType.LIST.name)) {
                return LIST;
            }
            return null;
        }
    }
}

