/*
 * Decompiled with CFR 0.152.
 */
package samples.jms.soaptojms;

import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import samples.jms.soaptojms.ServiceLocatorException;

public class ServiceLocator {
    private InitialContext ic;

    public ServiceLocator() throws ServiceLocatorException {
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException namingException) {
            throw new ServiceLocatorException(namingException);
        }
        catch (Exception exception) {
            throw new ServiceLocatorException(exception);
        }
    }

    public TopicConnectionFactory getTopicConnectionFactory(String string) throws ServiceLocatorException {
        TopicConnectionFactory topicConnectionFactory = null;
        try {
            topicConnectionFactory = (TopicConnectionFactory)this.ic.lookup(string);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            throw new ServiceLocatorException(namingException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ServiceLocatorException(exception);
        }
        return topicConnectionFactory;
    }

    public Topic getTopic(String string) throws ServiceLocatorException {
        Topic topic = null;
        try {
            topic = (Topic)this.ic.lookup(string);
        }
        catch (NamingException namingException) {
            throw new ServiceLocatorException(namingException);
        }
        catch (Exception exception) {
            throw new ServiceLocatorException(exception);
        }
        return topic;
    }
}

