/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.WeakListener;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public abstract class CloneableOpenSupport {
    protected Env env;
    protected CloneableTopComponent.Ref allEditors;
    private static Container container;

    public CloneableOpenSupport(Env env) {
        this.env = env;
        Listener l = new Listener(env);
        this.allEditors = l;
        env.addPropertyChangeListener(WeakListener.propertyChange(l, env));
        env.addVetoableChangeListener(WeakListener.vetoableChange(l, env));
    }

    public void open() {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                CloneableTopComponent editor = CloneableOpenSupport.this.openCloneableTopComponent();
                editor.requestFocus();
            }
        });
    }

    public void view() {
        this.open();
    }

    public void edit() {
        this.open();
    }

    public boolean close() {
        return this.close(true);
    }

    protected boolean close(final boolean ask) {
        if (this.allEditors.isEmpty()) {
            return true;
        }
        Boolean ret = (Boolean)Mutex.EVENT.writeAccess(new Mutex.Action(){

            public Object run() {
                Object object = CloneableOpenSupport.this.getLock();
                synchronized (object) {
                    if (ask && !CloneableOpenSupport.this.canClose()) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    Enumeration en = CloneableOpenSupport.this.allEditors.getComponents();
                    while (en.hasMoreElements()) {
                        TopComponent c = (TopComponent)en.nextElement();
                        if (c.close()) continue;
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                }
                return Boolean.TRUE;
            }
        });
        return ret;
    }

    protected boolean canClose() {
        return true;
    }

    protected final CloneableTopComponent openCloneableTopComponent() {
        Object object = this.getLock();
        synchronized (object) {
            CloneableTopComponent ret = this.allEditors.getArbitraryComponent();
            if (ret != null) {
                ret.open();
                CloneableTopComponent cloneableTopComponent = ret;
                return cloneableTopComponent;
            }
            String msg = this.messageOpening();
            if (msg != null) {
                StatusDisplayer.getDefault().setStatusText(msg);
            }
            CloneableTopComponent editor = this.createCloneableTopComponent();
            editor.setReference(this.allEditors);
            editor.open();
            msg = this.messageOpened();
            if (msg == null) {
                msg = "";
            }
            StatusDisplayer.getDefault().setStatusText(msg);
            CloneableTopComponent cloneableTopComponent = editor;
            return cloneableTopComponent;
        }
    }

    private Object getLock() {
        if (container == null) {
            container = new Container();
        }
        return container.getTreeLock();
    }

    protected abstract CloneableTopComponent createCloneableTopComponent();

    protected abstract String messageOpening();

    protected abstract String messageOpened();

    private static final class Listener
    extends CloneableTopComponent.Ref
    implements PropertyChangeListener,
    VetoableChangeListener,
    Runnable {
        static final long serialVersionUID = -1934890789745432531L;
        private Env env;

        public Listener(Env env) {
            this.env = env;
        }

        private CloneableOpenSupport support() {
            return this.env.findCloneableOpenSupport();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("valid".equals(ev.getPropertyName())) {
                if (Boolean.FALSE.equals(ev.getOldValue())) {
                    return;
                }
                Mutex.EVENT.readAccess(this);
            }
        }

        public void run() {
            CloneableOpenSupport os = this.support();
            if (os != null) {
                this.env.unmarkModified();
                os.close(false);
            }
        }

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            if ("valid".equals(ev.getPropertyName())) {
                CloneableOpenSupport os;
                if (Boolean.FALSE.equals(ev.getOldValue())) {
                    return;
                }
                if (this.env.isModified() && (os = this.support()) != null && !os.canClose()) {
                    throw new PropertyVetoException("", ev);
                }
            }
        }

        public Object readResolve() {
            CloneableOpenSupport os = this.support();
            if (os == null) {
                return this;
            }
            return os.allEditors;
        }
    }

    public static interface Env
    extends Serializable {
        public static final String PROP_VALID = "valid";
        public static final String PROP_MODIFIED = "modified";

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public void addVetoableChangeListener(VetoableChangeListener var1);

        public void removeVetoableChangeListener(VetoableChangeListener var1);

        public boolean isValid();

        public boolean isModified();

        public void markModified() throws IOException;

        public void unmarkModified();

        public CloneableOpenSupport findCloneableOpenSupport();
    }
}

