/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.util.actions.NodeAction;

public abstract class CookieAction
extends NodeAction {
    private static final String PROP_COOKIES = "cookies";
    public static final int MODE_ONE = 1;
    public static final int MODE_SOME = 2;
    public static final int MODE_ALL = 4;
    public static final int MODE_EXACTLY_ONE = 8;
    public static final int MODE_ANY = 7;
    private static final long serialVersionUID = 6031319415908298424L;
    private CookiesChangeListener listener = new CookiesChangeListener(this);

    protected abstract int mode();

    protected abstract Class[] cookieClasses();

    private Class[] getCookies() {
        Class[] ret = (Class[])this.getProperty(PROP_COOKIES);
        if (ret != null) {
            return ret;
        }
        ret = this.cookieClasses();
        this.putProperty(PROP_COOKIES, ret);
        return ret;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        this.listener.setNodes(activatedNodes);
        return this.doEnable(activatedNodes);
    }

    boolean doEnable(Node[] activatedNodes) {
        int supported = this.resolveSupported(activatedNodes);
        if (supported == 0) {
            return false;
        }
        int mode = this.mode();
        return (mode & 1) != 0 || (mode & 4) != 0 && supported == activatedNodes.length || (mode & 8) != 0 && activatedNodes.length == 1 || (mode & 2) != 0 && supported < activatedNodes.length;
    }

    private int resolveSupported(Node[] activatedNodes) {
        int total = activatedNodes.length;
        int ret = 0;
        Class[] cookies = this.getCookies();
        int i = 0;
        while (i < total) {
            int j = 0;
            while (j < cookies.length) {
                if (activatedNodes[i].getCookie(cookies[j]) != null) {
                    ++ret;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private static final class CookiesChangeListener
    extends NodeAdapter {
        private List nodes;
        private Reference action;

        public CookiesChangeListener(CookieAction a) {
            this.action = new WeakReference<CookieAction>(a);
        }

        void setNodes(Node[] newNodes) {
            List nodes2 = this.nodes;
            if (nodes2 != null) {
                this.detachListeners(nodes2);
            }
            this.nodes = null;
            if (newNodes != null) {
                this.nodes = new ArrayList(newNodes.length);
                int i = 0;
                while (i < newNodes.length) {
                    this.nodes.add(new WeakReference<Node>(newNodes[i]));
                    ++i;
                }
                this.attachListeners(this.nodes);
            }
        }

        void detachListeners(List nodes) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)((Reference)it.next()).get();
                if (node == null) continue;
                node.removeNodeListener(this);
            }
        }

        void attachListeners(List nodes) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)((Reference)it.next()).get();
                if (node == null) continue;
                node.addNodeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!"cookie".equals(ev.getPropertyName())) {
                return;
            }
            CookieAction a = (CookieAction)this.action.get();
            if (a == null) {
                return;
            }
            List _nodes = this.nodes;
            if (_nodes != null) {
                ArrayList<Node> nonNullNodes = new ArrayList<Node>(_nodes.size());
                Iterator it = _nodes.iterator();
                while (it.hasNext()) {
                    Node node = (Node)((Reference)it.next()).get();
                    if (node != null) {
                        nonNullNodes.add(node);
                        continue;
                    }
                    return;
                }
                Node[] nodes2 = new Node[nonNullNodes.size()];
                nonNullNodes.toArray(nodes2);
                a.setEnabled(a.enable(nodes2));
            }
        }
    }
}

