/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.ErrorManager;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.AsyncGUIJob;
import org.openide.util.AsyncInitSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.IconManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RE13;
import org.openide.util.TopologicalSortException;
import org.openide.util.UtilitiesCompositeActionMap;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public final class Utilities {
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_DEC = 512;
    public static final int OS_OS2 = 1024;
    public static final int OS_MAC = 2048;
    public static final int OS_WIN2000 = 4096;
    public static final int OS_VMS = 8192;
    public static final int OS_WIN_OTHER = 16384;
    public static final int OS_OTHER = 65536;
    public static final int OS_WINDOWS_MASK = 20487;
    public static final int OS_UNIX_MASK = 3064;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static final int TYPICAL_MACOSX_MENU_HEIGHT = 24;
    private static ReferenceQueue activeReferenceQueue;
    private static Reference namesAndValues;
    private static int operatingSystem;
    private static Reference keywords;
    private static Timer clearIntrospector;
    private static ActionListener doClear;
    private static final String TRANS_LOCK = "TRANS_LOCK";
    private static Object transLoader;
    private static RE transExp;
    private static Object actionClassForPopupMenu;
    private static FileURLConvertor convertor;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$Cursor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;
    static /* synthetic */ Class class$java$awt$GraphicsConfiguration;
    static /* synthetic */ Class class$java$awt$Toolkit;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    private Utilities() {
    }

    public static synchronized ReferenceQueue activeReferenceQueue() {
        if (activeReferenceQueue == null) {
            activeReferenceQueue = new ActiveQueue(false);
        }
        return activeReferenceQueue;
    }

    public static final int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 4096 : (osName.startsWith("Windows ") ? 16384 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : (osName.endsWith("Linux") ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/2".equals(osName) ? 1024 : ("OpenVMS".equals(osName) ? 8192 : (osName.equals("Mac OS X") ? 2048 : (osName.startsWith("Darwin") ? 2048 : 65536))))))))))))))));
        }
        return operatingSystem;
    }

    public static final boolean isWindows() {
        return (Utilities.getOperatingSystem() & 0x5007) != 0;
    }

    public static final boolean isUnix() {
        return (Utilities.getOperatingSystem() & 0xBF8) != 0;
    }

    private static synchronized HashMap keywords() {
        HashMap map;
        if (keywords != null && (map = (HashMap)keywords.get()) != null) {
            return map;
        }
        HashMap<String, String> keywords = new HashMap<String, String>(71);
        keywords.put("abstract", "abstract");
        keywords.put("default", "default");
        keywords.put("if", "if");
        keywords.put("private", "private");
        keywords.put("throw", "throw");
        keywords.put("boolean", "boolean");
        keywords.put("do", "do");
        keywords.put("implements", "implements");
        keywords.put("protected", "protected");
        keywords.put("throws", "throws");
        keywords.put("break", "break");
        keywords.put("double", "double");
        keywords.put("import", "import");
        keywords.put("public", "public");
        keywords.put("transient", "transient");
        keywords.put("byte", "byte");
        keywords.put("else", "else");
        keywords.put("instanceof", "instanceof");
        keywords.put("return", "return");
        keywords.put("try", "try");
        keywords.put("case", "case");
        keywords.put("extends", "extends");
        keywords.put("int", "int");
        keywords.put("short", "short");
        keywords.put("void", "void");
        keywords.put("catch", "catch");
        keywords.put("final", "final");
        keywords.put("interface", "interface");
        keywords.put("static", "static");
        keywords.put("volatile", "volatile");
        keywords.put("char", "char");
        keywords.put("finally", "finally");
        keywords.put("long", "long");
        keywords.put("class", "class");
        keywords.put("while", "while");
        keywords.put("super", "super");
        keywords.put("float", "float");
        keywords.put("native", "native");
        keywords.put("switch", "switch");
        keywords.put("const", "const");
        keywords.put("for", "for");
        keywords.put("new", "new");
        keywords.put("synchronized", "synchronized");
        keywords.put("continue", "continue");
        keywords.put("continue", "continue");
        keywords.put("goto", "goto");
        keywords.put("package", "package");
        keywords.put("this", "this");
        keywords.put("null", "null");
        keywords.put("true", "true");
        keywords.put("false", "false");
        keywords.put("assert", "assert");
        Utilities.keywords = new SoftReference(keywords);
        return keywords;
    }

    public static final boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < id.length()) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return !Utilities.keywords().containsKey(id);
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ie) {
            ErrorManager.getDefault().annotate(ie, 0, "Encountered while introspecting " + clazz.getName(), null, null, null);
            throw ie;
        }
        catch (Error e) {
            ErrorManager.getDefault().annotate(e, 0, "Encountered while introspecting " + clazz.getName(), null, null, null);
            throw e;
        }
        if ((class$java$awt$Component == null ? (class$java$awt$Component = Utilities.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(clazz)) {
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                if (pds[i].getName().equals("cursor")) {
                    try {
                        Method getter = (class$java$awt$Component == null ? (class$java$awt$Component = Utilities.class$("java.awt.Component")) : class$java$awt$Component).getDeclaredMethod("getCursor", new Class[0]);
                        Method setter = (class$java$awt$Component == null ? (class$java$awt$Component = Utilities.class$("java.awt.Component")) : class$java$awt$Component).getDeclaredMethod("setCursor", class$java$awt$Cursor == null ? (class$java$awt$Cursor = Utilities.class$("java.awt.Cursor")) : class$java$awt$Cursor);
                        pds[i] = new PropertyDescriptor("cursor", getter, setter);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++i;
            }
        }
        if (bi != null) {
            if (clearIntrospector == null) {
                doClear = new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        Introspector.flushCaches();
                    }
                };
                clearIntrospector = new Timer(15000, doClear);
                clearIntrospector.setRepeats(false);
            }
            clearIntrospector.restart();
        }
        return bi;
    }

    public static BeanInfo getBeanInfo(Class clazz, Class stopClass) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, stopClass);
    }

    public static String[] wrapStringToArray(String original, int width, boolean wrapWords, boolean removeNewLines) {
        BreakIterator bi = wrapWords ? BreakIterator.getWordInstance() : BreakIterator.getCharacterInstance();
        return Utilities.wrapStringToArray(original, width, bi, removeNewLines);
    }

    public static String[] wrapStringToArray(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        int i;
        String[] workingSet;
        block15: {
            if (original.length() == 0) {
                return new String[]{original};
            }
            if (removeNewLines) {
                original = Utilities.trimString(original);
                original = original.replace('\n', ' ');
                workingSet = new String[]{original};
            } else {
                StringTokenizer tokens = new StringTokenizer(original, "\n");
                int len = tokens.countTokens();
                workingSet = new String[len];
                i = 0;
                while (i < len) {
                    workingSet[i] = tokens.nextToken();
                    ++i;
                }
            }
            if (width < 1) {
                width = 1;
            }
            if (original.length() <= width) {
                return workingSet;
            }
            boolean ok = true;
            int i2 = 0;
            while (i2 < workingSet.length) {
                boolean bl = ok = ok && workingSet[i2].length() < width;
                if (ok) {
                    ++i2;
                    continue;
                }
                break block15;
            }
            return workingSet;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int lineStart = 0;
        i = 0;
        while (i < workingSet.length) {
            if (workingSet[i].length() < width) {
                lines.add(workingSet[i]);
            } else {
                breakIterator.setText(workingSet[i]);
                int nextStart = breakIterator.next();
                int prevStart = 0;
                while (true) {
                    if (nextStart - lineStart < width && nextStart != -1) {
                        prevStart = nextStart;
                        nextStart = breakIterator.next();
                        continue;
                    }
                    if (nextStart == -1) {
                        nextStart = prevStart = workingSet[i].length();
                    }
                    if (prevStart == 0) {
                        prevStart = nextStart;
                    }
                    lines.add(workingSet[i].substring(lineStart, prevStart));
                    lineStart = prevStart;
                    prevStart = 0;
                    if (lineStart >= workingSet[i].length()) break;
                }
                lineStart = 0;
            }
            ++i;
        }
        String[] s = new String[lines.size()];
        return lines.toArray(s);
    }

    private static String trimString(String s) {
        char c;
        int idx = 0;
        int slen = s.length();
        if (slen == 0) {
            return s;
        }
        while (((c = s.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s = s.substring(idx)).length() - 1) < 0) {
            return s;
        }
        while (((c = s.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s.substring(0, idx + 2);
    }

    public static String wrapString(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        String[] sarray = Utilities.wrapStringToArray(original, width, breakIterator, removeNewLines);
        StringBuffer retBuf = new StringBuffer();
        int i = 0;
        while (i < sarray.length) {
            retBuf.append(sarray[i]);
            retBuf.append('\n');
            ++i;
        }
        return retBuf.toString();
    }

    public static String wrapString(String original, int width, boolean wrapWords, boolean removeNewLines) {
        if (removeNewLines) {
            while (original.startsWith("\n")) {
                original = original.substring(1);
            }
            while (original.endsWith("\n")) {
                original = original.substring(0, original.length() - 1);
            }
            original = original.replace('\n', ' ');
        }
        if (width < 1) {
            width = 1;
        }
        if (original.length() <= width) {
            return original;
        }
        Vector<String> lines = new Vector<String>();
        int lineStart = 0;
        int lastSpacePos = -1;
        int i = 0;
        while (i < original.length()) {
            if (lineStart >= original.length() - 1) break;
            if (original.charAt(i) == '\n') {
                lines.addElement(original.substring(lineStart, i));
                lineStart = i + 1;
                lastSpacePos = -1;
            } else {
                if (Character.isSpaceChar(original.charAt(i))) {
                    lastSpacePos = i;
                }
                if (i == original.length() - 1) {
                    lines.addElement(original.substring(lineStart));
                    break;
                }
                if (i - lineStart == width) {
                    if (wrapWords && lastSpacePos != -1) {
                        lines.addElement(original.substring(lineStart, lastSpacePos));
                        lineStart = lastSpacePos + 1;
                        lastSpacePos = -1;
                    } else {
                        lines.addElement(original.substring(lineStart, i));
                        lineStart = i;
                        lastSpacePos = -1;
                    }
                }
            }
            ++i;
        }
        StringBuffer retBuf = new StringBuffer();
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            retBuf.append((String)e.nextElement());
            retBuf.append('\n');
        }
        return retBuf.toString();
    }

    public static String replaceString(String original, String replaceFrom, String replaceTo) {
        int pos;
        int index = 0;
        if ("".equals(replaceFrom)) {
            return original;
        }
        StringBuffer buf = new StringBuffer();
        do {
            if ((pos = original.indexOf(replaceFrom, index)) == -1) {
                buf.append(original.substring(index));
                return buf.toString();
            }
            buf.append(original.substring(index, pos));
            buf.append(replaceTo);
        } while ((index = pos + replaceFrom.length()) != original.length());
        return buf.toString();
    }

    public static final String pureClassName(String fullName) {
        int index = fullName.indexOf(36);
        if (index >= 0 && index < fullName.length()) {
            return fullName.substring(index + 1, fullName.length());
        }
        return fullName;
    }

    public static final boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    public static int arrayHashCode(Object[] arr) {
        int c = 0;
        int len = arr.length;
        int i = 0;
        while (i < len) {
            Object o = arr[i];
            int v = o == null ? 1 : o.hashCode();
            c += v ^ i;
            ++i;
        }
        return c;
    }

    public static boolean compareObjects(Object o1, Object o2) {
        return Utilities.compareObjectsImpl(o1, o2, 1);
    }

    public static boolean compareObjectsImpl(Object o1, Object o2, int checkArraysDepth) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (checkArraysDepth > 0) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                Object[] o1a = (Object[])o1;
                int l1 = o1a.length;
                Object[] o2a = (Object[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (!Utilities.compareObjectsImpl(o1a[i], o2a[i], checkArraysDepth - 1)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                byte[] o1a = (byte[])o1;
                int l1 = o1a.length;
                byte[] o2a = (byte[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (o1a[i] != o2a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                short[] o1a = (short[])o1;
                int l1 = o1a.length;
                short[] o2a = (short[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (o1a[i] != o2a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                int[] o1a = (int[])o1;
                int l1 = o1a.length;
                int[] o2a = (int[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (o1a[i] != o2a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                long[] o1a = (long[])o1;
                int l1 = o1a.length;
                long[] o2a = (long[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (o1a[i] != o2a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                float[] o1a = (float[])o1;
                int l1 = o1a.length;
                float[] o2a = (float[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (o1a[i] != o2a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                double[] o1a = (double[])o1;
                int l1 = o1a.length;
                double[] o2a = (double[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (o1a[i] != o2a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                char[] o1a = (char[])o1;
                int l1 = o1a.length;
                char[] o2a = (char[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (o1a[i] != o2a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                boolean[] o1a = (boolean[])o1;
                int l1 = o1a.length;
                boolean[] o2a = (boolean[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                int i = 0;
                while (i < l1) {
                    if (o1a[i] != o2a[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return o1.equals(o2);
    }

    public static String getClassName(Class clazz) {
        if (clazz.isArray()) {
            return Utilities.getClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getShortClassName(Class clazz) {
        if (clazz.isArray()) {
            return Utilities.getShortClassName(clazz.getComponentType()) + "[]";
        }
        String name = clazz.getName().replace('$', '.');
        return name.substring(name.lastIndexOf(".") + 1, name.length());
    }

    public static Object toPrimitiveArray(Object[] array) {
        if (array instanceof Integer[]) {
            int[] r = new int[array.length];
            int k = array.length;
            int i = 0;
            while (i < k) {
                r[i] = (Integer)array[i] == null ? 0 : (Integer)array[i];
                ++i;
            }
            return r;
        }
        if (array instanceof Boolean[]) {
            boolean[] r = new boolean[array.length];
            int k = array.length;
            int i = 0;
            while (i < k) {
                r[i] = (Boolean)array[i] == null ? false : (Boolean)array[i];
                ++i;
            }
            return r;
        }
        if (array instanceof Byte[]) {
            byte[] r = new byte[array.length];
            int k = array.length;
            int i = 0;
            while (i < k) {
                r[i] = (Byte)array[i] == null ? (byte)0 : (Byte)array[i];
                ++i;
            }
            return r;
        }
        if (array instanceof Character[]) {
            char[] r = new char[array.length];
            int k = array.length;
            int i = 0;
            while (i < k) {
                r[i] = (Character)array[i] == null ? (char)'\u0000' : ((Character)array[i]).charValue();
                ++i;
            }
            return r;
        }
        if (array instanceof Double[]) {
            double[] r = new double[array.length];
            int k = array.length;
            int i = 0;
            while (i < k) {
                r[i] = (Double)array[i] == null ? 0.0 : (Double)array[i];
                ++i;
            }
            return r;
        }
        if (array instanceof Float[]) {
            float[] r = new float[array.length];
            int k = array.length;
            int i = 0;
            while (i < k) {
                r[i] = (Float)array[i] == null ? 0.0f : ((Float)array[i]).floatValue();
                ++i;
            }
            return r;
        }
        if (array instanceof Long[]) {
            long[] r = new long[array.length];
            int k = array.length;
            int i = 0;
            while (i < k) {
                r[i] = (Long)array[i] == null ? 0L : (Long)array[i];
                ++i;
            }
            return r;
        }
        if (array instanceof Short[]) {
            short[] r = new short[array.length];
            int k = array.length;
            int i = 0;
            while (i < k) {
                r[i] = (Short)array[i] == null ? (short)0 : (Short)array[i];
                ++i;
            }
            return r;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof int[]) {
            int k = ((int[])array).length;
            Object[] r = new Integer[k];
            int i = 0;
            while (i < k) {
                r[i] = new Integer(((int[])array)[i]);
                ++i;
            }
            return r;
        }
        if (array instanceof boolean[]) {
            int k = ((boolean[])array).length;
            Object[] r = new Boolean[k];
            int i = 0;
            while (i < k) {
                r[i] = ((boolean[])array)[i] ? Boolean.TRUE : Boolean.FALSE;
                ++i;
            }
            return r;
        }
        if (array instanceof byte[]) {
            int k = ((byte[])array).length;
            Object[] r = new Byte[k];
            int i = 0;
            while (i < k) {
                r[i] = new Byte(((byte[])array)[i]);
                ++i;
            }
            return r;
        }
        if (array instanceof char[]) {
            int k = ((char[])array).length;
            Object[] r = new Character[k];
            int i = 0;
            while (i < k) {
                r[i] = new Character(((char[])array)[i]);
                ++i;
            }
            return r;
        }
        if (array instanceof double[]) {
            int k = ((double[])array).length;
            Object[] r = new Double[k];
            int i = 0;
            while (i < k) {
                r[i] = new Double(((double[])array)[i]);
                ++i;
            }
            return r;
        }
        if (array instanceof float[]) {
            int k = ((float[])array).length;
            Object[] r = new Float[k];
            int i = 0;
            while (i < k) {
                r[i] = new Float(((float[])array)[i]);
                ++i;
            }
            return r;
        }
        if (array instanceof long[]) {
            int k = ((long[])array).length;
            Object[] r = new Long[k];
            int i = 0;
            while (i < k) {
                r[i] = new Long(((long[])array)[i]);
                ++i;
            }
            return r;
        }
        if (array instanceof short[]) {
            int k = ((short[])array).length;
            Object[] r = new Short[k];
            int i = 0;
            while (i < k) {
                r[i] = new Short(((short[])array)[i]);
                ++i;
            }
            return r;
        }
        throw new IllegalArgumentException();
    }

    public static Class getObjectType(Class c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = Utilities.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (c == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = Utilities.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (c == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = Utilities.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (c == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = Utilities.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (c == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = Utilities.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (c == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = Utilities.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (c == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = Utilities.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (c == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = Utilities.class$("java.lang.Short")) : class$java$lang$Short;
        }
        throw new IllegalArgumentException();
    }

    public static Class getPrimitiveType(Class c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = Utilities.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Utilities.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (c == (class$java$lang$Byte == null ? (class$java$lang$Byte = Utilities.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (c == (class$java$lang$Character == null ? (class$java$lang$Character = Utilities.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        if (c == (class$java$lang$Double == null ? (class$java$lang$Double = Utilities.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (c == (class$java$lang$Float == null ? (class$java$lang$Float = Utilities.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (c == (class$java$lang$Long == null ? (class$java$lang$Long = Utilities.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (c == (class$java$lang$Short == null ? (class$java$lang$Short = Utilities.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static Component getFocusTraversableComponent(Component c) {
        if (c.isFocusTraversable()) {
            return c;
        }
        if (!(c instanceof Container)) {
            return null;
        }
        int k = ((Container)c).getComponentCount();
        int i = 0;
        while (i < k) {
            Component v = ((Container)c).getComponent(i);
            if (v != null) {
                return v;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] parseParameters(String s) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        Vector<String> params = new Vector<String>(5, 5);
        int state = NULL;
        StringBuffer buff = new StringBuffer(20);
        int slength = s.length();
        int i = 0;
        while (i < slength) {
            block25: {
                char c;
                block34: {
                    block36: {
                        block35: {
                            block29: {
                                block33: {
                                    block32: {
                                        block30: {
                                            block31: {
                                                block26: {
                                                    block28: {
                                                        block27: {
                                                            c = s.charAt(i);
                                                            if (!Character.isWhitespace(c)) break block26;
                                                            if (state != NULL) break block27;
                                                            if (buff.length() > 0) {
                                                                params.addElement(buff.toString());
                                                                buff.setLength(0);
                                                            }
                                                            break block25;
                                                        }
                                                        if (state != STICK) break block28;
                                                        params.addElement(buff.toString());
                                                        buff.setLength(0);
                                                        state = NULL;
                                                        break block25;
                                                    }
                                                    if (state == STICKPENDING) {
                                                        buff.append('\\');
                                                        params.addElement(buff.toString());
                                                        buff.setLength(0);
                                                        state = NULL;
                                                        break block25;
                                                    } else if (state == INPARAMPENDING) {
                                                        state = INPARAM;
                                                        buff.append('\\');
                                                        buff.append(c);
                                                        break block25;
                                                    } else {
                                                        buff.append(c);
                                                    }
                                                    break block25;
                                                }
                                                if (c != '\\') break block29;
                                                if (state != NULL) break block30;
                                                if (++i >= slength) break block31;
                                                char cc = s.charAt(i);
                                                if (cc == '\"' || cc == '\\') {
                                                    buff.append(cc);
                                                    break block25;
                                                } else if (Character.isWhitespace(cc)) {
                                                    buff.append(c);
                                                    --i;
                                                    break block25;
                                                } else {
                                                    buff.append(c);
                                                    buff.append(cc);
                                                }
                                                break block25;
                                            }
                                            buff.append('\\');
                                            break;
                                        }
                                        if (state != INPARAM) break block32;
                                        state = INPARAMPENDING;
                                        break block25;
                                    }
                                    if (state != INPARAMPENDING) break block33;
                                    buff.append('\\');
                                    state = INPARAM;
                                    break block25;
                                }
                                if (state == STICK) {
                                    state = STICKPENDING;
                                    break block25;
                                } else if (state == STICKPENDING) {
                                    buff.append('\\');
                                    state = STICK;
                                }
                                break block25;
                            }
                            if (c != '\"') break block34;
                            if (state != NULL) break block35;
                            state = INPARAM;
                            break block25;
                        }
                        if (state != INPARAM) break block36;
                        state = STICK;
                        break block25;
                    }
                    if (state == STICK) {
                        state = INPARAM;
                        break block25;
                    } else if (state == STICKPENDING) {
                        buff.append('\"');
                        state = STICK;
                        break block25;
                    } else {
                        buff.append('\"');
                        state = INPARAM;
                    }
                    break block25;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                } else if (state == STICKPENDING) {
                    buff.append('\\');
                    state = STICK;
                }
                buff.append(c);
            }
            ++i;
        }
        if (state == INPARAM) {
            params.addElement(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.addElement(buff.toString());
        } else if (buff.length() != 0) {
            params.addElement(buff.toString());
        }
        Object[] ret = new String[params.size()];
        params.copyInto(ret);
        return ret;
    }

    public static String escapeParameters(String[] params) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < params.length) {
            Utilities.escapeString(params[i], sb);
            sb.append(' ');
            ++i;
        }
        int len = sb.length();
        if (len > 0) {
            sb.setLength(len - 1);
        }
        return sb.toString().trim();
    }

    private static void escapeString(String s, StringBuffer sb) {
        if (s.length() == 0) {
            sb.append("\"\"");
            return;
        }
        boolean hasSpace = false;
        int sz = sb.length();
        int slen = s.length();
        int i = 0;
        while (i < slen) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                hasSpace = true;
                sb.append(c);
            } else if (c == '\\') {
                sb.append('\\').append('\\');
            } else if (c == '\"') {
                sb.append('\\').append('\"');
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (hasSpace) {
            sb.insert(sz, '\"');
            sb.append('\"');
        }
    }

    private static synchronized HashMap[] initNameAndValues() {
        HashMap[] arr;
        if (namesAndValues != null && (arr = (HashMap[])namesAndValues.get()) != null) {
            return arr;
        }
        Field[] fields = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = Utilities.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredFields();
        HashMap<String, Integer> names = new HashMap<String, Integer>(fields.length * 4 / 3 + 1, 0.75f);
        HashMap<Integer, String> values = new HashMap<Integer, String>(fields.length * 4 / 3 + 1, 0.75f);
        int i = 0;
        while (i < fields.length) {
            String name;
            if (Modifier.isStatic(fields[i].getModifiers()) && (name = fields[i].getName()).startsWith("VK_")) {
                name = name.substring(3);
                try {
                    int numb = fields[i].getInt(null);
                    Integer value = new Integer(numb);
                    names.put(name, value);
                    values.put(value, name);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (IllegalAccessException ex) {
                    // empty catch block
                }
            }
            ++i;
        }
        HashMap[] arr2 = new HashMap[]{names, values};
        namesAndValues = new SoftReference<HashMap[]>(arr2);
        return arr2;
    }

    public static String keyToString(KeyStroke stroke) {
        HashMap[] namesAndValues;
        String c;
        StringBuffer sb = new StringBuffer();
        if (Utilities.addModifiers(sb, stroke.getModifiers())) {
            sb.append('-');
        }
        if ((c = (String)(namesAndValues = Utilities.initNameAndValues())[1].get(new Integer(stroke.getKeyCode()))) == null) {
            sb.append(stroke.getKeyChar());
        } else {
            sb.append(c);
        }
        return sb.toString();
    }

    public static KeyStroke stringToKey(String s) {
        StringTokenizer st = new StringTokenizer(s.toUpperCase(), "-", true);
        int needed = 0;
        HashMap names = Utilities.initNameAndValues()[0];
        int lastModif = -1;
        try {
            String el;
            while (true) {
                if ((el = st.nextToken()).equals("-")) {
                    if (lastModif == -1) continue;
                    needed |= lastModif;
                    lastModif = -1;
                    continue;
                }
                if (!st.hasMoreElements()) break;
                lastModif = Utilities.readModifiers(el);
            }
            Integer i = (Integer)names.get(el);
            if (i != null) {
                return KeyStroke.getKeyStroke(i, needed);
            }
            return null;
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public static KeyStroke[] stringToKeys(String s) {
        StringTokenizer st = new StringTokenizer(s.toUpperCase(), " ");
        ArrayList<KeyStroke> arr = new ArrayList<KeyStroke>();
        while (st.hasMoreElements()) {
            s = st.nextToken();
            KeyStroke k = Utilities.stringToKey(s);
            if (k == null) {
                return null;
            }
            arr.add(k);
        }
        return arr.toArray(new KeyStroke[arr.size()]);
    }

    private static boolean addModifiers(StringBuffer buf, int modif) {
        boolean b = false;
        if ((modif & 2) != 0) {
            buf.append("C");
            b = true;
        }
        if ((modif & 8) != 0) {
            buf.append("A");
            b = true;
        }
        if ((modif & 1) != 0) {
            buf.append("S");
            b = true;
        }
        if ((modif & 4) != 0) {
            buf.append("M");
            b = true;
        }
        return b;
    }

    private static int readModifiers(String s) throws NoSuchElementException {
        int m = 0;
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case 'C': {
                    m |= 2;
                    break;
                }
                case 'A': {
                    m |= 8;
                    break;
                }
                case 'M': {
                    m |= 4;
                    break;
                }
                case 'S': {
                    m |= 1;
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            ++i;
        }
        return m;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (SwingUtilities.findFocusOwner(frames[i]) != null) {
                return frames[i].getGraphicsConfiguration();
            }
            ++i;
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration gconf) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = new Rectangle(gconf.getBounds());
        String str = System.getProperty("netbeans.screen.insets");
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ", ");
            if (st.countTokens() == 4) {
                try {
                    bounds.y = Integer.parseInt(st.nextToken());
                    bounds.x = Integer.parseInt(st.nextToken());
                    bounds.height -= bounds.y + Integer.parseInt(st.nextToken());
                    bounds.width -= bounds.x + Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException ex) {
                    ErrorManager.getDefault().notify(16, ex);
                }
            }
            return bounds;
        }
        str = System.getProperty("netbeans.taskbar.height");
        if (str != null) {
            bounds.height -= Integer.getInteger(str, 0).intValue();
            return bounds;
        }
        if (Dependency.JAVA_SPEC.compareTo(new SpecificationVersion("1.4")) >= 0) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Method m = (class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = Utilities.class$("java.awt.Toolkit")) : class$java$awt$Toolkit).getMethod("getScreenInsets", class$java$awt$GraphicsConfiguration == null ? (class$java$awt$GraphicsConfiguration = Utilities.class$("java.awt.GraphicsConfiguration")) : class$java$awt$GraphicsConfiguration);
                if (m == null) {
                    return bounds;
                }
                Insets insets = (Insets)m.invoke((Object)toolkit, gconf);
                bounds.y += insets.top;
                bounds.x += insets.left;
                bounds.height -= insets.top + insets.bottom;
                bounds.width -= insets.left + insets.right;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(16, ex);
            }
            return bounds;
        }
        if (Utilities.isWindows()) {
            bounds.height -= 27;
            return bounds;
        }
        if ((Utilities.getOperatingSystem() & 0x800) != 0) {
            bounds.height -= 24;
            bounds.y += 24;
            return bounds;
        }
        return bounds;
    }

    public static Rectangle findCenterBounds(Dimension componentSize) {
        return Utilities.findCenterBounds(Utilities.getCurrentGraphicsConfiguration(), componentSize);
    }

    private static Rectangle findCenterBounds(GraphicsConfiguration gconf, Dimension componentSize) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = gconf.getBounds();
        return new Rectangle(bounds.x + (bounds.width - componentSize.width) / 2, bounds.y + (bounds.height - componentSize.height) / 2, componentSize.width, componentSize.height);
    }

    public static final Dimension getScreenSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (Utilities.isWindows() && !Boolean.getBoolean("netbeans.no.taskbar")) {
            screenSize.height -= 27;
        } else if ((Utilities.getOperatingSystem() & 0x800) != 0) {
            screenSize.height -= 24;
        }
        return screenSize;
    }

    public static final int showJFileChooser(JFileChooser chooser, Component parent, String approveButtonText) {
        if (approveButtonText != null) {
            chooser.setApproveButtonText(approveButtonText);
            chooser.setDialogType(2);
        }
        Frame frame = null;
        Dialog parentDlg = null;
        if (parent instanceof Dialog) {
            parentDlg = (Dialog)parent;
        } else {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = Utilities.class$("java.awt.Frame")) : class$java$awt$Frame, parent);
        }
        String title = chooser.getDialogTitle();
        if (title == null) {
            title = chooser.getUI().getDialogTitle(chooser);
        }
        final JDialog dialog = parentDlg != null ? new JDialog(parentDlg, title, true) : new JDialog(frame, title, true);
        dialog.setDefaultCloseOperation(2);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooser, "Center");
        dialog.pack();
        ((Component)dialog).setBounds(Utilities.findCenterBounds(parent.getGraphicsConfiguration(), dialog.getSize()));
        chooser.rescanCurrentDirectory();
        final int[] retValue = new int[]{1};
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getActionCommand() == "ApproveSelection") {
                    retValue[0] = 0;
                }
                ((Component)dialog).setVisible(false);
                dialog.dispose();
            }
        };
        chooser.addActionListener(l);
        dialog.show();
        return retValue[0];
    }

    public static List partialSort(List l, Comparator c, boolean stable) throws UnorderableException {
        HashMap deps = new HashMap();
        int size = l.size();
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                int cmp = c.compare(l.get(i), l.get(j));
                if (cmp != 0) {
                    Object earlier = l.get(cmp < 0 ? i : j);
                    Object later = l.get(cmp > 0 ? i : j);
                    HashSet s = (HashSet)deps.get(later);
                    if (s == null) {
                        s = new HashSet();
                        deps.put(later, s);
                    }
                    s.add(earlier);
                }
                ++j;
            }
            ++i;
        }
        LinkedList left = new LinkedList(l);
        ArrayList sorted = new ArrayList(size);
        while (left.size() > 0) {
            Iterator it2;
            boolean stillGoing = false;
            Iterator<Object> it = left.iterator();
            while (it.hasNext()) {
                Object elt = it.next();
                Set eltDeps = (Set)deps.get(elt);
                if (eltDeps != null && eltDeps.size() != 0) continue;
                it.remove();
                stillGoing = true;
                sorted.add(elt);
                it2 = left.iterator();
                while (it2.hasNext()) {
                    Object elt2 = it2.next();
                    Set eltDeps2 = (Set)deps.get(elt2);
                    if (eltDeps2 == null) continue;
                    eltDeps2.remove(elt);
                }
                if (stable) break;
            }
            if (stillGoing) continue;
            it = deps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = (Map.Entry)it.next();
                if (!left.contains(me.getKey())) {
                    it.remove();
                    continue;
                }
                Set s = (Set)me.getValue();
                it2 = s.iterator();
                while (it2.hasNext()) {
                    if (left.contains(it2.next())) continue;
                    it2.remove();
                }
                if (!s.isEmpty()) continue;
                it.remove();
            }
            throw new UnorderableException(left, deps);
        }
        return sorted;
    }

    public static List topologicalSort(Collection c, Map edges) throws TopologicalSortException {
        HashMap finished = new HashMap();
        ArrayList r = new ArrayList(Math.max(c.size(), 1));
        ArrayList cRev = new ArrayList(c);
        Collections.reverse(cRev);
        Iterator it = cRev.iterator();
        while (it.hasNext()) {
            List cycle = Utilities.visit(it.next(), edges, finished, r);
            if (cycle == null) continue;
            throw new TopologicalSortException(cRev, edges);
        }
        Collections.reverse(r);
        return r;
    }

    static List visit(Object node, Map edges, Map finished, List r) {
        Boolean b = (Boolean)finished.get(node);
        if (b != null) {
            if (b.booleanValue()) {
                return null;
            }
            ArrayList<Object> cycle = new ArrayList<Object>();
            cycle.add(node);
            finished.put(node, null);
            return cycle;
        }
        Collection e = (Collection)edges.get(node);
        if (e != null) {
            finished.put(node, Boolean.FALSE);
            Iterator it = e.iterator();
            while (it.hasNext()) {
                List cycle = Utilities.visit(it.next(), edges, finished, r);
                if (cycle == null) continue;
                if (cycle instanceof ArrayList) {
                    if (Boolean.FALSE == finished.get(node)) {
                        cycle.add(node);
                    } else {
                        Collections.reverse(cycle);
                        cycle = Collections.unmodifiableList(cycle);
                    }
                }
                finished.put(node, Boolean.TRUE);
                return cycle;
            }
        }
        finished.put(node, Boolean.TRUE);
        r.add(node);
        return null;
    }

    public static String translate(String className) {
        RE exp;
        Utilities.checkMapping();
        String string = TRANS_LOCK;
        synchronized (string) {
            exp = transExp;
        }
        if (exp == null) {
            return className;
        }
        RE rE = exp;
        synchronized (rE) {
            String string2 = exp.convert(className);
            return string2;
        }
    }

    private static void checkMapping() {
        if (transLoader == TRANS_LOCK) {
            return;
        }
        ClassLoader current = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Utilities.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        if (current == null) {
            current = ClassLoader.getSystemClassLoader();
        }
        if (transLoader == current) {
            return;
        }
        Utilities.initForLoader(current, current);
    }

    static void initForLoader(ClassLoader current, Object set) {
        Enumeration<URL> en;
        if (set == null) {
            set = TRANS_LOCK;
        }
        try {
            en = current.getResources("META-INF/netbeans/translate.names");
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, ex);
            en = null;
        }
        if (en == null || !en.hasMoreElements()) {
            String ex = TRANS_LOCK;
            synchronized (ex) {
                transLoader = set;
                transExp = null;
            }
            return;
        }
        RE13 re = null;
        if (re == null) {
            re = new RE13();
        }
        TreeSet list = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                int i2;
                String s1 = ((String[])o1)[0];
                String s2 = ((String[])o2)[0];
                int i1 = s1.length();
                if (i1 != (i2 = s2.length())) {
                    return i2 - i1;
                }
                return s2.compareTo(s1);
            }
        });
        while (en.hasMoreElements()) {
            URL u = en.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream(), "UTF8"));
                Utilities.loadTranslationFile(re, reader, list);
                reader.close();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().annotate(ex, 0, "Problematic file: " + u, null, null, null);
                ErrorManager.getDefault().notify(1, ex);
            }
        }
        String[] arr = new String[list.size()];
        String[] pattern = new String[arr.length];
        int i = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String[] pair = (String[])it.next();
            arr[i] = pair[1].intern();
            pattern[i] = pair[0];
            ++i;
        }
        String string = TRANS_LOCK;
        synchronized (string) {
            if (arr.length == 0) {
                transExp = null;
            } else {
                transExp = re;
                transExp.init(pattern, arr);
            }
            transLoader = set;
        }
    }

    private static void loadTranslationFile(RE re, BufferedReader reader, Set results) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            String[] pair = re.readPair(line);
            if (pair == null) {
                throw new InvalidObjectException("Line is invalid: " + line);
            }
            results.add(pair);
        }
    }

    public static final Image mergeImages(Image image1, Image image2, int x, int y) {
        return IconManager.mergeImages(image1, image2, x, y);
    }

    public static final Image loadImage(String resourceID) {
        return IconManager.getIcon(resourceID);
    }

    public static JPopupMenu actionsToPopup(Action[] actions, Lookup context) {
        JPopupMenu menu = null;
        try {
            if (actionClassForPopupMenu == null) {
                actionClassForPopupMenu = Class.forName("org.openide.awt.JPopupMenuPlus");
            }
            if (actionClassForPopupMenu instanceof Class) {
                menu = (JPopupMenu)((Class)actionClassForPopupMenu).newInstance();
            }
        }
        catch (IllegalAccessException ex) {
            actionClassForPopupMenu = new Object();
        }
        catch (InstantiationException ex) {
            actionClassForPopupMenu = new Object();
        }
        catch (ClassNotFoundException ex) {
            actionClassForPopupMenu = new Object();
        }
        if (menu == null) {
            menu = new JPopupMenu();
        }
        HashSet<Action> counted = new HashSet<Action>();
        boolean canSep = false;
        int i = 0;
        while (i < actions.length) {
            block18: {
                boolean addSep;
                block17: {
                    addSep = true;
                    Action action = actions[i];
                    if (action == null) break block17;
                    if (counted.contains(action)) break block18;
                    counted.add(action);
                    if (action instanceof ContextAwareAction) {
                        action = ((ContextAwareAction)action).createContextAwareInstance(context);
                    }
                    addSep = false;
                    canSep = true;
                    if (action instanceof Presenter.Popup) {
                        JMenuItem item = ((Presenter.Popup)((Object)action)).getPopupPresenter();
                        if (item == null) {
                            NullPointerException npe = new NullPointerException("findContextMenuImpl, getPopupPresenter returning null for " + action);
                            ErrorManager.getDefault().notify(1, npe);
                        }
                        menu.add(item);
                    } else {
                        menu.add(action);
                    }
                }
                if (addSep && canSep) {
                    menu.addSeparator();
                    canSep = false;
                }
            }
            ++i;
        }
        return menu;
    }

    public static JPopupMenu actionsToPopup(Action[] actions, Component component) {
        Lookup lookup = null;
        Component c = component;
        while (c != null) {
            if (c instanceof Lookup.Provider && (lookup = ((Lookup.Provider)((Object)c)).getLookup()) != null) break;
            c = c.getParent();
        }
        if (lookup == null) {
            UtilitiesCompositeActionMap map = new UtilitiesCompositeActionMap(component);
            lookup = Lookups.singleton(map);
        }
        return Utilities.actionsToPopup(actions, lookup);
    }

    public static final Image loadImage(String resource, boolean localized) {
        if (localized) {
            String ext;
            String base;
            int idx = resource.lastIndexOf(46);
            if (idx != -1 && idx > resource.lastIndexOf(47)) {
                base = resource.substring(0, idx);
                ext = resource.substring(idx);
            } else {
                base = resource;
                ext = "";
            }
            Image baseVariant = Utilities.loadImage(base + ext);
            Iterator it = NbBundle.getLocalizingSuffixes();
            while (it.hasNext()) {
                String suffix = (String)it.next();
                Image i = suffix.length() == 0 ? baseVariant : Utilities.loadImage(base + suffix + ext);
                if (i == null) continue;
                return i;
            }
            return null;
        }
        return Utilities.loadImage(resource);
    }

    public static final Cursor createProgressCursor(Component component) {
        if (component == null) {
            throw new NullPointerException("Given component is null");
        }
        Image image = null;
        image = Utilities.getOperatingSystem() == 2048 ? Utilities.loadImage("org/openide/resources/progress-cursor-mac.gif") : (Utilities.isUnix() ? Utilities.loadImage("org/openide/resources/progress-cursor-motif.gif") : Utilities.loadImage("org/openide/resources/progress-cursor-win.gif"));
        return Utilities.createCustomCursor(component, image, "PROGRESS_CURSOR");
    }

    private static Cursor createCustomCursor(Component component, Image icon, String name) {
        Toolkit t = component.getToolkit();
        Dimension d = t.getBestCursorSize(16, 16);
        Image i = icon;
        if (d.width != icon.getWidth(null)) {
            if (d.width == 0 && d.height == 0) {
                return Cursor.getPredefinedCursor(3);
            }
            BufferedImage empty = IconManager.createBufferedImage(d.width, d.height);
            i = Utilities.mergeImages(icon, empty, 0, 0);
        }
        return t.createCustomCursor(i, new Point(1, 1), name);
    }

    public static final void attachInitJob(Component comp4Init, AsyncGUIJob initJob) {
        new AsyncInitSupport(comp4Init, initJob);
    }

    public static URL toURL(File f) throws MalformedURLException {
        if (f == null) {
            throw new NullPointerException();
        }
        if (!f.isAbsolute()) {
            throw new IllegalArgumentException("Relative path: " + f);
        }
        if (convertor == null) {
            try {
                Class<?> clazz = Class.forName("org.openide.util.FileURLConvertor14");
                FileURLConvertor c = (FileURLConvertor)clazz.newInstance();
                try {
                    URL u = c.toURL(f);
                    convertor = c;
                    return u;
                }
                catch (MalformedURLException mfue) {
                    convertor = c;
                    throw mfue;
                }
            }
            catch (Exception e) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            convertor = new FileURLConvertor13();
        }
        return convertor.toURL(f);
    }

    public static File toFile(URL u) {
        if (u == null) {
            throw new NullPointerException();
        }
        if (convertor == null) {
            try {
                Class<?> clazz = Class.forName("org.openide.util.FileURLConvertor14");
                FileURLConvertor c = (FileURLConvertor)clazz.newInstance();
                File f = c.toFile(u);
                convertor = c;
                return f;
            }
            catch (Exception e) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            convertor = new FileURLConvertor13();
        }
        return convertor.toFile(u);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        operatingSystem = -1;
        convertor = null;
    }

    private static class FileURLConvertor13
    implements FileURLConvertor {
        FileURLConvertor13() {
        }

        /*
         * WARNING - void declaration
         */
        public URL toURL(File f) throws MalformedURLException {
            URL u = f.toURL();
            String u2 = u.toExternalForm();
            if (u2.indexOf(35) != -1) {
                int i;
                while ((i = u2.indexOf(35)) != -1) {
                    void var4_4;
                    u2 = u2.substring(0, (int)var4_4) + "%23" + u2.substring((int)(var4_4 + true));
                }
                u = new URL(u2);
            }
            return u;
        }

        /*
         * WARNING - void declaration
         */
        public File toFile(URL u) {
            int i;
            if (!"file".equals(u.getProtocol())) {
                return null;
            }
            String path = u.getPath();
            while ((i = path.indexOf("%23")) != -1) {
                void var3_3;
                path = path.substring(0, (int)var3_3) + '#' + path.substring((int)(var3_3 + 3));
            }
            return new File(path.replace('/', File.separatorChar));
        }
    }

    static interface FileURLConvertor {
        public URL toURL(File var1) throws MalformedURLException;

        public File toFile(URL var1);
    }

    private static final class ActiveQueue
    extends ReferenceQueue
    implements Runnable {
        private boolean running;
        private boolean deprecated;

        public ActiveQueue(boolean deprecated) {
            this.deprecated = deprecated;
            Thread t = new Thread((Runnable)this, "Active Reference Queue Daemon");
            t.setPriority(1);
            t.setDaemon(true);
            t.start();
        }

        public Reference poll() {
            throw new UnsupportedOperationException();
        }

        public Reference remove(long timeout) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        public Reference remove() throws InterruptedException {
            throw new InterruptedException();
        }

        public void run() {
            ActiveQueue activeQueue = this;
            synchronized (activeQueue) {
                if (this.running) {
                    return;
                }
                this.running = true;
            }
            while (true) {
                try {
                    Reference ref;
                    while (!((ref = super.remove(0L)) instanceof Runnable)) {
                        ErrorManager.getDefault().log(65536, "A reference not implementing runnable has been added to the Utilities.activeReferenceQueue (): " + ref.getClass());
                    }
                    if (this.deprecated) {
                        ErrorManager.getDefault().log(16, "Utilities.ACTIVE_REFERENCE_QUEUE has been deprecated for " + ref.getClass() + " use Utilities.activeReferenceQueue");
                    }
                    try {
                        ((Runnable)((Object)ref)).run();
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        ErrorManager.getDefault().notify(t);
                        continue;
                    }
                }
                catch (InterruptedException ex) {
                    ErrorManager.getDefault().notify(1, ex);
                    continue;
                }
                break;
            }
        }
    }

    static interface RE {
        public void init(String[] var1, String[] var2);

        public String convert(String var1);

        public String[] readPair(String var1);
    }

    public static class UnorderableException
    extends RuntimeException {
        private Collection unorderable;
        private Map deps;
        static final long serialVersionUID = 6749951134051806661L;

        public UnorderableException(Collection unorderable, Map deps) {
            this.unorderable = unorderable;
            this.deps = deps;
        }

        public UnorderableException(String message, Collection unorderable, Map deps) {
            super(message);
            this.unorderable = unorderable;
            this.deps = deps;
        }

        public Collection getUnorderable() {
            return this.unorderable;
        }

        public Map getDeps() {
            return this.deps;
        }
    }
}

