/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.Line;
import org.openide.text.LineListener;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.WeakListener;

public abstract class DocumentLine
extends Line {
    protected PositionRef pos;
    private boolean breakpoint;
    private transient boolean error;
    private transient boolean current;
    private transient LR listener;
    private transient DocumentListener docL;
    private static WeakHashMap assigned = new WeakHashMap(5);
    private List lineParts = new ArrayList(3);
    static final long serialVersionUID = 3213776466939427487L;

    public DocumentLine(DataObject obj, PositionRef pos) {
        super(obj);
        this.pos = pos;
    }

    void init() {
        this.listener = new LR();
        this.pos.getCloneableEditorSupport().addChangeListener(WeakListener.change(this.listener, this.pos.getCloneableEditorSupport()));
    }

    public int getLineNumber() {
        try {
            return this.pos.getLine();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    public abstract void show(int var1, int var2);

    public void setBreakpoint(boolean b) {
        if (this.breakpoint != b) {
            this.breakpoint = b;
            this.refreshState();
        }
    }

    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    public void markError() {
        DocumentLine previous = this.registerLine(1, this);
        if (previous != null) {
            previous.error = false;
            previous.refreshState();
        }
        this.error = true;
        this.refreshState();
    }

    public void unmarkError() {
        this.error = false;
        this.registerLine(1, null);
        this.refreshState();
    }

    public void markCurrentLine() {
        DocumentLine previous = this.registerLine(0, this);
        if (previous != null) {
            previous.current = false;
            previous.refreshState();
        }
        this.current = true;
        this.refreshState();
    }

    public void unmarkCurrentLine() {
        this.current = false;
        this.registerLine(0, null);
        this.refreshState();
    }

    synchronized void refreshState() {
        StyledDocument doc = this.pos.getCloneableEditorSupport().getDocument();
        if (doc != null) {
            if (this.docL != null) {
                doc.removeDocumentListener(this.docL);
            }
            if (this.error) {
                NbDocument.markError(doc, this.pos.getOffset());
                this.docL = WeakListener.document(this.listener, doc);
                doc.addDocumentListener(this.docL);
                return;
            }
            if (this.current) {
                NbDocument.markCurrent(doc, this.pos.getOffset());
                return;
            }
            if (this.breakpoint) {
                NbDocument.markBreakpoint(doc, this.pos.getOffset());
                return;
            }
            NbDocument.markNormal(doc, this.pos.getOffset());
            return;
        }
    }

    public int hashCode() {
        return this.pos.getCloneableEditorSupport().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DocumentLine) {
            DocumentLine dl = (DocumentLine)o;
            if (dl.pos.getCloneableEditorSupport() == this.pos.getCloneableEditorSupport()) {
                return dl.getLineNumber() == this.getLineNumber();
            }
        }
        return false;
    }

    private DocumentLine registerLine(int indx, DocumentLine line) {
        DocumentLine prev;
        CloneableEditorSupport es = this.pos.getCloneableEditorSupport();
        DocumentLine[] arr = (DocumentLine[])assigned.get(es);
        if (arr != null) {
            prev = arr[indx];
        } else {
            arr = new DocumentLine[2];
            assigned.put(es, arr);
            prev = null;
        }
        arr[indx] = line;
        return prev;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.pos);
        oos.writeBoolean(this.breakpoint);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.pos = (PositionRef)ois.readObject();
        this.setBreakpoint(ois.readBoolean());
        this.lineParts = new ArrayList(3);
    }

    Object readResolve() throws ObjectStreamException {
        return this.pos.getCloneableEditorSupport().getLineSet().registerLine(this);
    }

    protected void addAnnotation(Annotation anno) {
        super.addAnnotation(anno);
        StyledDocument doc = this.pos.getCloneableEditorSupport().getDocument();
        if (doc == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        try {
            if (!anno.isInDocument()) {
                anno.setInDocument(true);
                NbDocument.addAnnotation(doc, this.pos.getPosition(), -1, anno);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, ex);
        }
    }

    protected void removeAnnotation(Annotation anno) {
        super.removeAnnotation(anno);
        StyledDocument doc = this.pos.getCloneableEditorSupport().getDocument();
        if (doc == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        if (anno.isInDocument()) {
            anno.setInDocument(false);
            NbDocument.removeAnnotation(doc, anno);
        }
    }

    void attachDetachAnnotations(StyledDocument doc, boolean closing) {
        List list = this.getAnnotations();
        int i = 0;
        while (i < list.size()) {
            Annotation anno = (Annotation)list.get(i);
            if (!closing) {
                try {
                    if (!anno.isInDocument()) {
                        anno.setInDocument(true);
                        NbDocument.addAnnotation(doc, this.pos.getPosition(), -1, anno);
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(4096, ex);
                }
            } else if (anno.isInDocument()) {
                anno.setInDocument(false);
                NbDocument.removeAnnotation(doc, anno);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.lineParts.size()) {
            ((Part)this.lineParts.get(i2)).attachDetachAnnotations(doc, closing);
            ++i2;
        }
    }

    public String getText() {
        StyledDocument doc = this.pos.getCloneableEditorSupport().getDocument();
        if (doc == null) {
            return null;
        }
        int lineNumber = this.getLineNumber();
        int lineStart = NbDocument.findLineOffset(doc, lineNumber);
        int lineEnd = lineNumber + 1 >= NbDocument.findLineRootElement(doc).getElementCount() ? doc.getLength() : NbDocument.findLineOffset(doc, lineNumber + 1);
        try {
            return doc.getText(lineStart, lineEnd - lineStart);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(4096, ex);
            return null;
        }
    }

    void addLinePart(Part linePart) {
        this.lineParts.add(linePart);
    }

    void moveLinePart(Part linePart, DocumentLine newLine) {
        this.lineParts.remove(linePart);
        newLine.addLinePart(linePart);
        linePart.changeLine(newLine);
    }

    void notifyChange(DocumentEvent p0, Set set, StyledDocument doc) {
        int i = 0;
        while (i < this.lineParts.size()) {
            Part part = (Part)this.lineParts.get(i);
            part.handleDocumentChange(p0);
            if (NbDocument.findLineNumber(doc, part.getOffset()) != part.getLine().getLineNumber()) {
                DocumentLine line = (DocumentLine)set.getCurrent(NbDocument.findLineNumber(doc, part.getOffset()));
                this.moveLinePart(part, line);
                continue;
            }
            ++i;
        }
    }

    void notifyMove() {
        this.updatePositionRef();
        int i = 0;
        while (i < this.lineParts.size()) {
            ((Part)this.lineParts.get(i)).firePropertyChange("line", null, null);
            ++i;
        }
    }

    private void updatePositionRef() {
        CloneableEditorSupport support = this.pos.getCloneableEditorSupport();
        int startOffset = NbDocument.findLineOffset(support.getDocument(), this.getLineNumber());
        if (this.pos.getOffset() != startOffset) {
            this.pos = new PositionRef(support.getPositionManager(), startOffset, Position.Bias.Forward);
        }
    }

    public static abstract class Set
    extends Line.Set {
        private final LineListener listener;
        private List list;

        public Set(StyledDocument doc) {
            this(doc, null);
        }

        Set(StyledDocument doc, CloneableEditorSupport support) {
            this.listener = new LineListener(doc, support);
        }

        void linesChanged(int startLineNumber, int endLineNumber, DocumentEvent p0) {
            List changedLines = this.getLinesFromRange(startLineNumber, endLineNumber);
            Iterator it = changedLines.iterator();
            while (it.hasNext()) {
                Line line = (Line)it.next();
                line.firePropertyChange("text", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyChange(p0, this, this.listener.doc);
            }
        }

        void linesMoved(int startLineNumber, int endLineNumber) {
            List movedLines = this.getLinesFromRange(startLineNumber, endLineNumber);
            Iterator it = movedLines.iterator();
            while (it.hasNext()) {
                Line line = (Line)it.next();
                line.firePropertyChange("lineNumber", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyMove();
            }
        }

        private List getLinesFromRange(int startLineNumber, int endLineNumber) {
            ArrayList<Line> linesInRange = new ArrayList<Line>(10);
            Map map = this.lines;
            synchronized (map) {
                Iterator it = this.lines.keySet().iterator();
                while (it.hasNext()) {
                    Line line = (Line)it.next();
                    int lineNumber = line.getLineNumber();
                    if (startLineNumber > lineNumber || lineNumber > endLineNumber) continue;
                    linesInRange.add(line);
                }
            }
            return linesInRange;
        }

        public List getLines() {
            if (this.list == null) {
                int cnt = this.listener.getOriginalLineCount();
                LinkedList<Line> l = new LinkedList<Line>();
                int i = 0;
                while (i < cnt) {
                    l.add(this.getOriginal(i));
                    ++i;
                }
                this.list = l;
            }
            return this.list;
        }

        public Line getOriginal(int line) throws IndexOutOfBoundsException {
            int newLine = this.listener.getLine(line);
            int offset = NbDocument.findLineOffset(this.listener.doc, newLine);
            return this.registerLine(this.createLine(offset));
        }

        public Line getCurrent(int line) throws IndexOutOfBoundsException {
            int offset = NbDocument.findLineOffset(this.listener.doc, line);
            return this.registerLine(this.createLine(offset));
        }

        protected abstract Line createLine(int var1);
    }

    private final class LR
    implements Runnable,
    ChangeListener,
    DocumentListener {
        private static final int REFRESH = 0;
        private static final int UNMARK = 1;
        private static final int ATTACH_DETACH = 2;
        private int actionId;
        private EnhancedChangeEvent ev;

        public LR() {
        }

        public LR(int actionId) {
            this.actionId = actionId;
        }

        public LR(EnhancedChangeEvent ev) {
            this.actionId = 2;
            this.ev = ev;
        }

        public void run() {
            switch (this.actionId) {
                case 0: {
                    DocumentLine.this.refreshState();
                    break;
                }
                case 1: {
                    DocumentLine.this.unmarkError();
                    break;
                }
                case 2: {
                    DocumentLine.this.attachDetachAnnotations(this.ev.getDocument(), this.ev.isClosingDocument());
                    this.ev = null;
                }
            }
        }

        private void invoke(int op) {
            SwingUtilities.invokeLater(new LR(op));
        }

        private void invoke(EnhancedChangeEvent ev) {
            SwingUtilities.invokeLater(new LR(ev));
        }

        public void stateChanged(ChangeEvent ev) {
            this.invoke(0);
            this.invoke((EnhancedChangeEvent)ev);
        }

        public void removeUpdate(DocumentEvent p0) {
            this.invoke(1);
        }

        public void insertUpdate(DocumentEvent p0) {
            this.invoke(1);
        }

        public void changedUpdate(DocumentEvent p0) {
        }
    }

    static class Part
    extends Line.Part {
        private PositionRef position;
        private Line line;
        private int length;
        private int previousOffset;

        public Part(Line line, PositionRef position, int length) {
            this.position = position;
            this.line = line;
            this.length = length;
            this.previousOffset = position.getOffset();
        }

        public int getColumn() {
            try {
                return this.position.getColumn();
            }
            catch (IOException ex) {
                return 0;
            }
        }

        public int getLength() {
            return this.length;
        }

        public Line getLine() {
            return this.line;
        }

        int getOffset() {
            return this.position.getOffset();
        }

        void changeLine(Line line) {
            this.line = line;
            this.firePropertyChange("lineNumber", null, line);
        }

        protected void addAnnotation(Annotation anno) {
            super.addAnnotation(anno);
            StyledDocument doc = this.position.getCloneableEditorSupport().getDocument();
            if (doc == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            try {
                if (!anno.isInDocument()) {
                    anno.setInDocument(true);
                    NbDocument.addAnnotation(doc, this.position.getPosition(), this.length, anno);
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, ex);
            }
        }

        protected void removeAnnotation(Annotation anno) {
            super.removeAnnotation(anno);
            StyledDocument doc = this.position.getCloneableEditorSupport().getDocument();
            if (doc == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            if (anno.isInDocument()) {
                anno.setInDocument(false);
                NbDocument.removeAnnotation(doc, anno);
            }
        }

        public String getText() {
            StyledDocument doc = this.position.getCloneableEditorSupport().getDocument();
            if (doc == null) {
                return null;
            }
            try {
                return doc.getText(this.position.getOffset(), this.getLength());
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify(4096, ex);
                return null;
            }
        }

        void attachDetachAnnotations(StyledDocument doc, boolean closing) {
            List list = this.getAnnotations();
            int i = 0;
            while (i < list.size()) {
                Annotation anno = (Annotation)list.get(i);
                if (!closing) {
                    try {
                        if (!anno.isInDocument()) {
                            anno.setInDocument(true);
                            NbDocument.addAnnotation(doc, this.position.getPosition(), this.getLength(), anno);
                        }
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(4096, ex);
                    }
                } else if (anno.isInDocument()) {
                    anno.setInDocument(false);
                    NbDocument.removeAnnotation(doc, anno);
                }
                ++i;
            }
        }

        void handleDocumentChange(DocumentEvent p0) {
            if (p0.getType().equals(DocumentEvent.EventType.INSERT) && p0.getOffset() >= this.previousOffset && p0.getOffset() < this.previousOffset + this.getLength()) {
                this.firePropertyChange("text", null, null);
            }
            if (p0.getType().equals(DocumentEvent.EventType.REMOVE) && (p0.getOffset() >= this.previousOffset && p0.getOffset() < this.previousOffset + this.getLength() || p0.getOffset() < this.previousOffset && p0.getOffset() + p0.getLength() > this.previousOffset)) {
                this.firePropertyChange("text", null, null);
            }
            if ((p0.getType().equals(DocumentEvent.EventType.INSERT) || p0.getType().equals(DocumentEvent.EventType.REMOVE)) && p0.getOffset() < this.previousOffset) {
                this.firePropertyChange("column", null, null);
            }
            this.previousOffset = this.position.getOffset();
        }
    }
}

