/*
 * Decompiled with CFR 0.152.
 */
package org.openide.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import org.openide.options.SystemOption;

public abstract class VetoSystemOption
extends SystemOption {
    static final long serialVersionUID = -614731095908156413L;
    private static final String PROP_VETO_SUPPORT = "vetoSupport";

    private HashSet getVeto() {
        HashSet set = (HashSet)this.getProperty(PROP_VETO_SUPPORT);
        if (set == null) {
            set = new HashSet();
            this.putProperty(PROP_VETO_SUPPORT, set);
        }
        return set;
    }

    public final void addVetoableChangeListener(VetoableChangeListener list) {
        Object object = this.getLock();
        synchronized (object) {
            this.getVeto().add(list);
        }
    }

    public final void removeVetoableChangeListener(VetoableChangeListener list) {
        Object object = this.getLock();
        synchronized (object) {
            this.getVeto().remove(list);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        Iterator en;
        PropertyChangeEvent ev = new PropertyChangeEvent(this, name, oldValue, newValue);
        Object object = this.getLock();
        synchronized (object) {
            en = ((HashSet)this.getVeto().clone()).iterator();
        }
        while (en.hasNext()) {
            ((VetoableChangeListener)en.next()).vetoableChange(ev);
        }
    }
}

