/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.NewObjectPanel;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class NewObjectWizardPanel
implements WizardDescriptor.FinishPanel {
    private NewObjectPanel newObjectPanelUI;
    private ChangeListener listener;
    DataFolder targetFolder;
    private String extension;
    private TemplateWizard wizard;
    static /* synthetic */ Class class$org$openide$loaders$NewObjectPanel;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard2;

    NewObjectWizardPanel() {
    }

    private NewObjectPanel getPanelUI() {
        if (this.newObjectPanelUI == null) {
            this.newObjectPanelUI = new NewObjectPanel();
            this.newObjectPanelUI.addChangeListener(this.listener);
        }
        return this.newObjectPanelUI;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        if (this.newObjectPanelUI != null) {
            this.newObjectPanelUI.addChangeListener(l);
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
        if (this.newObjectPanelUI != null) {
            this.newObjectPanelUI.removeChangeListener(l);
        }
    }

    public Component getComponent() {
        return this.getPanelUI();
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$openide$loaders$NewObjectPanel == null ? (class$org$openide$loaders$NewObjectPanel = NewObjectWizardPanel.class$("org.openide.loaders.NewObjectPanel")) : class$org$openide$loaders$NewObjectPanel);
    }

    public boolean isValid() {
        String errorMsg = null;
        boolean isOK = true;
        if (this.targetFolder.getPrimaryFile().isReadOnly()) {
            errorMsg = NbBundle.getMessage(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = NewObjectWizardPanel.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2, "MSG_fs_is_readonly");
            isOK = false;
        }
        if (isOK) {
            FileObject f;
            Object obj = this.targetFolder.getPrimaryFile().getAttribute("isRemoteAndSlow");
            boolean makeFileExistsChecks = true;
            if (obj instanceof Boolean) {
                boolean bl = makeFileExistsChecks = (Boolean)obj == false;
            }
            if (makeFileExistsChecks && (f = this.targetFolder.getPrimaryFile().getFileObject(this.getPanelUI().getNewObjectName(), this.extension)) != null) {
                errorMsg = NbBundle.getMessage(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = NewObjectWizardPanel.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2, "MSG_file_already_exist", f.getNameExt());
                isOK = false;
            }
        }
        this.wizard.putProperty("WizardPanel_errorMessage", errorMsg);
        return isOK;
    }

    public void readSettings(Object settings) {
        this.wizard = (TemplateWizard)settings;
        DataObject template = this.wizard.getTemplate();
        if (template != null) {
            this.extension = template.getPrimaryFile().getExt();
        }
        try {
            this.targetFolder = this.wizard.getTargetFolder();
        }
        catch (IOException x) {
            ErrorManager.getDefault().notify(x);
        }
    }

    public void storeSettings(Object settings) {
        String name = this.getPanelUI().getNewObjectName();
        if (name.equals(NewObjectPanel.defaultNewObjectName())) {
            name = null;
        }
        this.wizard.setTargetName(name);
        this.wizard = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

