/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.ListenerList;

class FCLSupport {
    public static final int DATA_CREATED = 0;
    public static final int FOLDER_CREATED = 1;
    public static final int FILE_CHANGED = 2;
    public static final int FILE_DELETED = 3;
    public static final int FILE_RENAMED = 4;
    public static final int ATTR_CHANGED = 5;
    private ListenerList listeners;
    static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;

    FCLSupport() {
    }

    final void addFileChangeListener(FileChangeListener fcl) {
        if (this.listeners == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.listeners == null) {
                    this.listeners = new ListenerList(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = FCLSupport.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener);
                }
            }
        }
        this.listeners.add(fcl);
    }

    final void removeFileChangeListener(FileChangeListener fcl) {
        if (this.listeners != null) {
            this.listeners.remove(fcl);
        }
    }

    final void dispatchEvent(FileEvent fe, int operation) {
        if (this.listeners == null) {
            return;
        }
        Object[] fcls = this.listeners.getAllListeners();
        int i = 0;
        while (i < fcls.length) {
            if (fcls[i] instanceof FileChangeListener) {
                FCLSupport.dispatchEvent((FileChangeListener)fcls[i], fe, operation);
            }
            ++i;
        }
    }

    static final void dispatchEvent(FileChangeListener fcl, FileEvent fe, int operation) {
        switch (operation) {
            case 0: {
                fcl.fileDataCreated(fe);
                break;
            }
            case 1: {
                fcl.fileFolderCreated(fe);
                break;
            }
            case 2: {
                fcl.fileChanged(fe);
                break;
            }
            case 3: {
                fcl.fileDeleted(fe);
                break;
            }
            case 4: {
                fcl.fileRenamed((FileRenameEvent)fe);
                break;
            }
            case 5: {
                fcl.fileAttributeChanged((FileAttributeEvent)fe);
            }
        }
    }

    final boolean hasListeners() {
        return this.listeners != null && this.listeners.getAllListeners().length != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

