/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.DropGlassPane;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

final class TreeViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    Rectangle lastNodeArea;
    private int upperNodeIdx = -1;
    private int lowerNodeIdx = -1;
    Timer timer;
    DropGlassPane dropPane;
    protected static final int FUSSY_POINTING = 3;
    private static final int DELAY_TIME_FOR_EXPAND = 1000;
    private static final int SHIFT_DOWN = -1;
    private static final int SHIFT_RIGHT = 10;
    private static final int SHIFT_LEFT = 15;
    private int pointAt = 0;
    protected TreeView view;
    protected JTree tree;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public TreeViewDropSupport(TreeView view, JTree tree, boolean dropTargetPopupAllowed) {
        this.view = view;
        this.tree = tree;
        this.dropTargetPopupAllowed = dropTargetPopupAllowed;
    }

    public void setDropTargetPopupAllowed(boolean value) {
        this.dropTargetPopupAllowed = value;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!DropGlassPane.isOriginalPaneStored()) {
            Component comp = this.tree.getRootPane().getGlassPane();
            DropGlassPane.setOriginalPane(this.tree, comp, comp.isVisible());
            this.dropPane = DropGlassPane.getDefault(this.tree);
            this.tree.getRootPane().setGlassPane(this.dropPane);
            this.dropPane.setOpaque(false);
            this.dropPane.revalidate();
            this.dropPane.setVisible(true);
        }
        this.doDragOver(dtde);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this.doDragOver(dtde);
    }

    private void doDragOver(DropTargetDragEvent dtde) {
        Line2D.Double line;
        TreePath tp = this.getTreePath(dtde);
        if (tp == null) {
            dtde.rejectDrag();
            this.removeDropLine();
            return;
        }
        Point p = dtde.getLocation();
        Node dropNode = this.getNodeForDrop(p);
        if (dropNode == null) {
            dtde.rejectDrag();
            this.removeDropLine();
            return;
        }
        Rectangle nodeArea = this.tree.getPathBounds(tp);
        int endPointX = nodeArea.x + nodeArea.width;
        int row = this.tree.getRowForPath(tp);
        if (nodeArea != null) {
            this.pointAt = 0;
            if (p.y <= nodeArea.y + 3) {
                if (row != 0) {
                    this.pointAt = -1;
                    TreePath upPath = this.tree.getPathForRow(row - 1);
                    if (upPath != null && !upPath.equals(tp)) {
                        endPointX = Math.max(nodeArea.x + nodeArea.width, this.tree.getPathBounds((TreePath)upPath).x + this.tree.getPathBounds((TreePath)upPath).width);
                    }
                    if (dropNode.getParentNode() != null) {
                        dropNode = dropNode.getParentNode();
                        tp = null;
                    }
                }
            } else if (p.y >= nodeArea.y + nodeArea.height - 3 && !this.view.isExpanded(dropNode)) {
                this.pointAt = 1;
                TreePath downPath = this.tree.getPathForRow(row + 1);
                if (downPath != null && !downPath.equals(tp)) {
                    endPointX = Math.max(nodeArea.x + nodeArea.width, this.tree.getPathBounds((TreePath)downPath).x + this.tree.getPathBounds((TreePath)downPath).width);
                }
                if (dropNode.getParentNode() != null) {
                    dropNode = dropNode.getParentNode();
                    tp = null;
                }
            }
        }
        endPointX += 10;
        Index indexCookie = (Index)dropNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = TreeViewDropSupport.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (indexCookie != null) {
            if (this.pointAt == -1) {
                this.lowerNodeIdx = indexCookie.indexOf(this.getNodeForDrop(p));
                this.upperNodeIdx = this.lowerNodeIdx - 1;
            } else if (this.pointAt == 1) {
                this.upperNodeIdx = indexCookie.indexOf(this.getNodeForDrop(p));
                this.lowerNodeIdx = this.upperNodeIdx + 1;
            }
        }
        if (!(this.timer != null && this.timer.isRunning() || dropNode == null || dropNode.isLeaf() || this.view.isExpanded(dropNode))) {
            final Node cn = dropNode;
            this.removeTimer();
            this.timer = new Timer(1000, new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    TreeViewDropSupport.this.view.expandNode(cn);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
        if (this.pointAt == 0) {
            this.dropPane.setDropLine(null);
        } else if (this.pointAt == -1) {
            line = new Line2D.Double(nodeArea.x - 15, nodeArea.y + -1, endPointX, nodeArea.y + -1);
            this.convertBoundsAndSetDropLine(line);
            Rectangle lineArea = new Rectangle(nodeArea.x - 15, nodeArea.y + -1 - 3, endPointX - nodeArea.x + 15, 5);
            nodeArea = (Rectangle)nodeArea.createUnion(lineArea);
        } else {
            line = new Line2D.Double(nodeArea.x - 15, nodeArea.y + nodeArea.height + -1, endPointX, nodeArea.y + nodeArea.height + -1);
            this.convertBoundsAndSetDropLine(line);
            Rectangle lineArea = new Rectangle(nodeArea.x - 15, nodeArea.y + nodeArea.height, endPointX - nodeArea.x + 15, 2);
            nodeArea = (Rectangle)nodeArea.createUnion(lineArea);
        }
        if (this.lastNodeArea != null && !this.lastNodeArea.equals(nodeArea)) {
            NodeRenderer.dragExit();
            this.repaint(this.lastNodeArea);
        }
        if (!nodeArea.equals(this.lastNodeArea)) {
            if (tp != null) {
                NodeRenderer.dragEnter(tp.getLastPathComponent());
            }
            this.repaint(nodeArea);
            this.lastNodeArea = nodeArea;
            this.removeTimer();
        }
        if (this.canDrop(dropNode, dtde.getDropAction())) {
            dtde.acceptDrag(dtde.getDropAction());
        } else if (this.canReorder(dropNode, ExplorerDnDManager.getDefault().getDraggedNodes())) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    private void repaint(Rectangle r) {
        this.tree.repaint(r.x - 5, r.y - 5, r.width + 10, r.height + 10);
    }

    private void convertBoundsAndSetDropLine(Line2D line) {
        int x1 = (int)line.getX1();
        int x2 = (int)line.getX2();
        int y1 = (int)line.getY1();
        int y2 = (int)line.getY2();
        Point p1 = SwingUtilities.convertPoint(this.tree, x1, y1, this.tree.getRootPane());
        Point p2 = SwingUtilities.convertPoint(this.tree, x2, y2, this.tree.getRootPane());
        line.setLine(p1, p2);
        this.dropPane.setDropLine(line);
    }

    private void removeTimer() {
        if (this.timer != null) {
            ActionListener[] l = (ActionListener[])this.timer.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = TreeViewDropSupport.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
            int i = 0;
            while (i < l.length) {
                this.timer.removeActionListener(l[i]);
                ++i;
            }
            this.timer.stop();
            this.timer = null;
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        Node[] nodes = ExplorerDnDManager.getDefault().getDraggedNodes();
        int dropAction = dtde.getDropAction();
        int i = 0;
        while (i < nodes.length) {
            if (!DragDropUtilities.checkNodeForAction(nodes[i], dropAction)) {
                dtde.rejectDrag();
                return;
            }
            ++i;
        }
    }

    public void dragExit(DropTargetEvent dte) {
        this.stopDragging();
    }

    private void removeDropLine() {
        this.dropPane.setDropLine(null);
        if (this.lastNodeArea != null) {
            NodeRenderer.dragExit();
            this.repaint(this.lastNodeArea);
            this.lastNodeArea = null;
        }
    }

    private void stopDragging() {
        this.removeDropLine();
        this.removeTimer();
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
        }
    }

    private Node getNodeForDrop(Point p) {
        TreePath tp;
        if (p != null && (tp = this.tree.getPathForLocation(p.x, p.y)) != null) {
            return DragDropUtilities.secureFindNode(tp.getLastPathComponent());
        }
        return null;
    }

    private boolean canReorder(Node folder, Node[] dragNodes) {
        if (ExplorerDnDManager.getDefault().getAllowedDragActions() != 2) {
            return false;
        }
        if (folder == null || dragNodes.length == 0) {
            return false;
        }
        Index ic = (Index)folder.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = TreeViewDropSupport.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (ic == null) {
            return false;
        }
        int i = 0;
        while (i < dragNodes.length) {
            if (dragNodes[i] == null) {
                return false;
            }
            if (dragNodes[i].getParentNode() == null) {
                return false;
            }
            if (!dragNodes[i].getParentNode().equals(folder)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void performReorder(Node folder, Node[] dragNodes, int lNode, int uNode) {
        block18: {
            try {
                Index indexCookie = (Index)folder.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = TreeViewDropSupport.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
                if (indexCookie == null) break block18;
                int[] perm = new int[indexCookie.getNodesCount()];
                int[] indexes = new int[dragNodes.length];
                int indexesLength = 0;
                int i = 0;
                while (i < dragNodes.length) {
                    int idx = indexCookie.indexOf(dragNodes[i]);
                    if (idx >= 0 && idx < perm.length) {
                        indexes[indexesLength++] = idx;
                    }
                    ++i;
                }
                Arrays.sort(indexes);
                if (lNode < 0 || uNode >= perm.length || indexesLength == 0) {
                    return;
                }
                int k = 0;
                int i2 = 0;
                while (i2 < perm.length) {
                    int j;
                    if (i2 <= uNode) {
                        if (!this.containsNumber(indexes, indexesLength, i2)) {
                            perm[i2] = k++;
                        }
                        if (i2 == uNode) {
                            j = 0;
                            while (j < indexesLength) {
                                if (indexes[j] <= uNode) {
                                    perm[indexes[j]] = k++;
                                }
                                ++j;
                            }
                        }
                    } else {
                        if (i2 == lNode) {
                            j = 0;
                            while (j < indexesLength) {
                                if (indexes[j] >= lNode) {
                                    perm[indexes[j]] = k++;
                                }
                                ++j;
                            }
                        }
                        if (!this.containsNumber(indexes, indexesLength, i2)) {
                            perm[i2] = k++;
                        }
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 < perm.length) {
                    if (perm[i3] != i3) {
                        indexCookie.reorder(perm);
                        break;
                    }
                    ++i3;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, e);
            }
        }
    }

    private boolean containsNumber(int[] arr, int arrLength, int n) {
        int i = 0;
        while (i < arrLength) {
            if (arr[i] == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Node[] findDropedNodes(Node folder, Node[] dragNodes) {
        if (folder == null || dragNodes.length == 0) {
            return null;
        }
        Node[] dropNodes = new Node[dragNodes.length];
        Children children = folder.getChildren();
        int i = 0;
        while (i < dragNodes.length) {
            dropNodes[i] = children.findChild(dragNodes[i].getName());
            ++i;
        }
        return dropNodes;
    }

    private boolean canDrop(Node n, int dropAction) {
        Transferable trans;
        if (n == null) {
            return false;
        }
        if (2 == dropAction) {
            Node[] nodes = ExplorerDnDManager.getDefault().getDraggedNodes();
            if (nodes == null) {
                return false;
            }
            int i = 0;
            while (i < nodes.length) {
                if (n.equals(nodes[i].getParentNode())) {
                    return false;
                }
                ++i;
            }
        }
        if ((trans = ExplorerDnDManager.getDefault().getDraggedTransferable(2 == dropAction)) == null) {
            return false;
        }
        PasteType[] pt = DragDropUtilities.getPasteTypes(n, trans);
        return pt != null && pt.length != 0;
    }

    public void drop(DropTargetDropEvent dtde) {
        this.stopDragging();
        Node dropNode = this.getNodeForDrop(dtde.getLocation());
        Node[] dragNodes = ExplorerDnDManager.getDefault().getDraggedNodes();
        TreePath tp = this.tree.getPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        if (this.pointAt != 0) {
            dropNode = dropNode.getParentNode();
        }
        if (!this.canDrop(dropNode, dtde.getDropAction())) {
            if (this.canReorder(dropNode, dragNodes)) {
                this.performReorder(dropNode, dragNodes, this.lowerNodeIdx, this.upperNodeIdx);
                dtde.acceptDrop(dtde.getDropAction());
            } else {
                dtde.rejectDrop();
            }
            dtde.dropComplete(true);
            return;
        }
        int dropAction = dtde.getDropAction();
        dtde.acceptDrop(dropAction);
        if (0x40000000 == dropAction) {
            PasteType[] ptCut = new PasteType[]{};
            PasteType[] ptCopy = new PasteType[]{};
            if (ExplorerDnDManager.getDefault().getAllowedDragActions() == 2) {
                ptCut = DragDropUtilities.getPasteTypes(dropNode, ExplorerDnDManager.getDefault().getDraggedTransferable(true));
            }
            if (ExplorerDnDManager.getDefault().getAllowedDragActions() >= 1) {
                ptCopy = DragDropUtilities.getPasteTypes(dropNode, ExplorerDnDManager.getDefault().getDraggedTransferable(false));
            }
            TreeSet<PasteType> setPasteTypes = new TreeSet<PasteType>(new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    return ((PasteType)obj1).getName().compareTo(((PasteType)obj2).getName());
                }
            });
            int i = 0;
            while (i < ptCut.length) {
                setPasteTypes.add(ptCut[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < ptCopy.length) {
                setPasteTypes.add(ptCopy[i2]);
                ++i2;
            }
            DragDropUtilities.createDropFinishPopup(setPasteTypes).show(this.tree, Math.max(dtde.getLocation().x - 5, 0), Math.max(dtde.getLocation().y - 5, 0));
            if (this.canReorder(dropNode, dragNodes)) {
                final Node tempDropNode = dropNode;
                final int tmpUpper = this.upperNodeIdx;
                final int tmpLower = this.lowerNodeIdx;
                final Node[] tempDragNodes = dragNodes;
                DragDropUtilities.setPostDropRun(new Runnable(){

                    public void run() {
                        TreeViewDropSupport.this.performReorder(tempDropNode, TreeViewDropSupport.this.findDropedNodes(tempDropNode, tempDragNodes), tmpLower, tmpUpper);
                    }
                });
            }
        } else {
            PasteType[] pt = DragDropUtilities.getPasteTypes(dropNode, ExplorerDnDManager.getDefault().getDraggedTransferable(2 == dropAction));
            DragDropUtilities.performDrop(pt[0]);
            if (this.canReorder(dropNode, this.findDropedNodes(dropNode, dragNodes))) {
                this.performReorder(dropNode, this.findDropedNodes(dropNode, dragNodes), this.lowerNodeIdx, this.upperNodeIdx);
            }
        }
        TreeCellEditor tce = this.tree.getCellEditor();
        if (tce instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)tce).setDnDActive(false);
        }
        dtde.dropComplete(true);
    }

    public void activate(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.getDropTarget().setActive(active);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    TreePath getTreePath(DropTargetDragEvent dtde) {
        int dropAction = dtde.getDropAction();
        Point location = dtde.getLocation();
        TreePath tp = this.tree.getPathForLocation(location.x, location.y);
        return tp != null && DragDropUtilities.secureFindNode(tp.getLastPathComponent()) != null ? tp : null;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.tree, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

