/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.explorer.view.TreeViewDragSupport;
import org.openide.explorer.view.TreeViewDropSupport;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public abstract class TreeView
extends JScrollPane {
    static final long serialVersionUID = -1639001987693376168L;
    private static final int TIME_TO_COLLAPSE = System.getProperty("netbeans.debug.heap") != null ? 0 : 15000;
    private static final int MIN_TREEVIEW_WIDTH = 400;
    private static final int MIN_TREEVIEW_HEIGHT = 400;
    protected transient JTree tree;
    transient NodeTreeModel treeModel;
    transient ExplorerManager manager;
    transient PopupSupport defaultActionListener;
    transient boolean defaultActionEnabled;
    transient PopupAdapter popupListener;
    transient TreePropertyListener managerListener = null;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient TreeViewDragSupport dragSupport;
    transient TreeViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    private transient Container contentPane;
    transient Boolean waitCursorDisabled;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;

    public TreeView() {
        this(true, true);
    }

    public TreeView(boolean defaultAction, boolean popupAllowed) {
        this.initializeTree();
        if (DragDropUtilities.dragAndDropEnabled) {
            ExplorerDnDManager.getDefault().addFutureDropTarget(this);
        }
        this.setPopupAllowed(popupAllowed);
        this.setDefaultActionAllowed(defaultAction);
        Dimension dim = null;
        try {
            dim = this.getPreferredSize();
            if (dim == null) {
                dim = new Dimension(400, 400);
            }
        }
        catch (NullPointerException npe) {
            dim = new Dimension(400, 400);
        }
        if (dim.width < 400) {
            dim.width = 400;
        }
        if (dim.height < 400) {
            dim.height = 400;
        }
        this.setPreferredSize(dim);
    }

    void initializeTree() {
        this.treeModel = this.createModel();
        this.tree = new ExplorerTree(this.treeModel);
        NodeRenderer rend = NodeRenderer.sharedInstance();
        this.tree.setCellRenderer(rend);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.setViewportView(this.tree);
        this.setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.managerListener = new TreePropertyListener();
        this.tree.addTreeExpansionListener(this.managerListener);
        this.tree.addTreeWillExpandListener(this.managerListener);
        this.setRequestFocusEnabled(false);
        this.defaultActionListener = new PopupSupport();
        this.tree.addFocusListener(this.defaultActionListener);
        this.tree.addMouseListener(this.defaultActionListener);
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    public void setPopupAllowed(boolean value) {
        if (this.popupListener == null && value) {
            this.popupListener = new PopupAdapter();
            this.tree.addMouseListener(this.popupListener);
            return;
        }
        if (this.popupListener != null && !value) {
            this.tree.removeMouseListener(this.popupListener);
            this.popupListener = null;
            return;
        }
    }

    void setDropTargetPopupAllowed(boolean value) {
        this.dropTargetPopupAllowed = value;
        if (this.dropSupport != null) {
            this.dropSupport.setDropTargetPopupAllowed(value);
        }
    }

    boolean isDropTargetPopupAllowed() {
        return this.dropSupport != null ? this.dropSupport.isDropTargetPopupAllowed() : this.dropTargetPopupAllowed;
    }

    public boolean isDefaultActionEnabled() {
        return this.defaultActionEnabled;
    }

    public void requestFocus() {
        this.tree.requestFocus();
    }

    public void setDefaultActionAllowed(boolean value) {
        this.defaultActionEnabled = value;
        if (value) {
            this.tree.registerKeyboardAction(this.defaultActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
        this.tree.setShowsRootHandles(!visible);
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean state) {
        if (state == this.dragActive) {
            return;
        }
        this.dragActive = state;
        if (this.dragActive && this.dragSupport == null) {
            this.dragSupport = new TreeViewDragSupport(this, this.tree);
        }
        this.dragSupport.activate(this.dragActive);
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean state) {
        if (state == this.dropActive) {
            return;
        }
        this.dropActive = state;
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new TreeViewDropSupport(this, this.tree, this.dropTargetPopupAllowed);
        }
        this.dropSupport.activate(this.dropActive);
    }

    public int getAllowedDragActions() {
        return 0x40000003;
    }

    public void setAllowedDragActions(int actions) {
    }

    public int getAllowedDropActions() {
        return 0x40000003;
    }

    public void setAllowedDropActions(int actions) {
    }

    public void collapseNode(Node n) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        this.tree.collapsePath(treePath);
    }

    public void expandNode(Node n) {
        this.lookupExplorerManager();
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        this.tree.expandPath(treePath);
    }

    public boolean isExpanded(Node n) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        return this.tree.isExpanded(treePath);
    }

    public void expandAll() {
        int j;
        int i = 0;
        int k = this.tree.getRowCount();
        do {
            j = this.tree.getRowCount();
            this.tree.expandRow(i);
        } while (j != this.tree.getRowCount() || ++i < this.tree.getRowCount());
    }

    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
    }

    private void lookupExplorerManager() {
        ExplorerManager newManager = ExplorerManager.find(this);
        if (newManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = newManager;
            this.wlvc = WeakListener.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.synchronizeRootContext();
            this.synchronizeExploredContext();
            this.synchronizeSelectedNodes();
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
    }

    protected abstract NodeTreeModel createModel();

    protected abstract void selectionChanged(Node[] var1, ExplorerManager var2) throws PropertyVetoException;

    protected abstract boolean selectionAccept(Node[] var1);

    protected abstract void showPath(TreePath var1);

    protected abstract void showSelection(TreePath[] var1);

    protected boolean useExploredContextMenu() {
        return false;
    }

    private boolean isSelectionModeBroken(Node[] nodes) {
        if (nodes.length <= 1 || this.getSelectionMode() == 4) {
            return false;
        }
        if (this.getSelectionMode() == 1) {
            return true;
        }
        TreePath[] paths = new TreePath[nodes.length];
        RowMapper rowMapper = this.tree.getSelectionModel().getRowMapper();
        if (rowMapper == null) {
            return false;
        }
        ArrayList<Node> toBeExpaned = new ArrayList<Node>(3);
        int i = 0;
        while (i < nodes.length) {
            TreePath treePath;
            toBeExpaned.clear();
            Node n = nodes[i];
            while (n.getParentNode() != null) {
                if (!this.isExpanded(n)) {
                    toBeExpaned.add(n);
                }
                n = n.getParentNode();
            }
            int j = toBeExpaned.size() - 1;
            while (j >= 0) {
                this.expandNode((Node)toBeExpaned.get(j));
                --j;
            }
            paths[i] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, nodes[i])));
            ++i;
        }
        int[] rows = rowMapper.getRowsForPaths(paths);
        Arrays.sort(rows);
        int i2 = 1;
        while (i2 < rows.length) {
            if (rows[i2] != rows[i2 - 1] + 1) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    final void callSelectionChanged(Node[] nodes) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            try {
                this.selectionChanged(nodes, this.manager);
            }
            catch (PropertyVetoException e) {
                this.synchronizeSelectedNodes();
                Object var4_3 = null;
                this.manager.addPropertyChangeListener(this.wlpc);
                this.manager.addVetoableChangeListener(this.wlvc);
            }
            Object var4_2 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
            throw throwable;
        }
    }

    final void synchronizeRootContext() {
        this.treeModel.setNode(this.manager.getRootContext());
    }

    final void synchronizeExploredContext() {
        Node n = this.manager.getExploredContext();
        if (n != null) {
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
            this.showPath(treePath);
        }
    }

    public void setSelectionMode(int mode) {
        this.tree.getSelectionModel().setSelectionMode(mode);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    private void showWaitCursor() {
        if (this.getRootPane() == null) {
            return;
        }
        this.contentPane = this.getRootPane().getContentPane();
        if (SwingUtilities.isEventDispatchThread()) {
            this.contentPane.setCursor(Utilities.createProgressCursor(this.contentPane));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeView.this.contentPane.setCursor(Utilities.createProgressCursor(TreeView.this.contentPane));
                }
            });
        }
    }

    private void showNormalCursor() {
        if (this.contentPane == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.contentPane.setCursor(null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeView.this.contentPane.setCursor(null);
                }
            });
        }
    }

    private void prepareWaitCursor(final Node node) {
        if (node == null) {
            this.showNormalCursor();
        }
        this.showWaitCursor();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        node.getChildren().getNodes(true);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(1, e);
                        Object var3_2 = null;
                        TreeView.this.showNormalCursor();
                        return;
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    TreeView.this.showNormalCursor();
                    throw throwable;
                }
                TreeView.this.showNormalCursor();
            }
        });
    }

    final void synchronizeSelectedNodes() {
        Node[] arr = this.manager.getSelectedNodes();
        TreePath[] paths = new TreePath[arr.length];
        int i = 0;
        while (i < arr.length) {
            TreePath treePath;
            paths[i] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, arr[i])));
            ++i;
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.showSelection(paths);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    void scrollTreeToVisible(TreePath path, TreeNode child) {
        Rectangle base = this.tree.getVisibleRect();
        Rectangle b1 = this.tree.getPathBounds(path);
        Rectangle b2 = this.tree.getPathBounds(new TreePath(this.treeModel.getPathToRoot(child)));
        if (base != null && b1 != null && b2 != null) {
            this.tree.scrollRectToVisible(new Rectangle(base.x, b1.y, 1, b2.y - b1.y + b2.height));
        }
    }

    static boolean shouldPopupBeDisplayed(Component comp) {
        try {
            Class<?> c = Class.forName("org.openide.windows.TopComponent$Registry");
            Object registry = Lookup.getDefault().lookup(c);
            if (registry == null) {
                return true;
            }
            Method m = c.getMethod("getActivated", new Class[0]);
            Object activated = m.invoke(registry, new Object[0]);
            boolean fromActivated = SwingUtilities.isDescendingFrom(comp, (Component)activated);
            if (fromActivated) {
                return true;
            }
            Window w = SwingUtilities.getWindowAncestor(comp);
            return w instanceof Dialog;
        }
        catch (Exception x) {
            ErrorManager.getDefault().notify(1, x);
            return true;
        }
    }

    private void createPopup(int xpos, int ypos, JPopupMenu popup) {
        if (popup != null && popup.getSubElements().length > 0 && TreeView.shouldPopupBeDisplayed(this)) {
            popup.show(this, xpos, ypos);
        }
    }

    void createPopup(int xpos, int ypos) {
        Node[] arr;
        Action[] actions;
        if (this.isPopupAllowed() && (actions = NodeOp.findActions(arr = this.manager.getSelectedNodes())).length > 0) {
            this.createPopup(xpos, ypos, Utilities.actionsToPopup(actions, this));
        }
    }

    void createExtendedPopup(int xpos, int ypos, JMenu newMenu) {
        Node[] ns = this.manager.getSelectedNodes();
        JPopupMenu popup = null;
        if (ns.length > 0) {
            Action[] actions = NodeOp.findActions(ns);
            popup = Utilities.actionsToPopup(actions, this);
        } else if (this.manager.getRootContext() != null) {
            popup = this.manager.getRootContext().getContextMenu();
        }
        int cnt = 0;
        if (popup != null && (cnt = popup.getComponentCount()) > 1) {
            popup.insert(newMenu, cnt - 1);
            popup.insert(new JPopupMenu.Separator(), cnt);
        } else {
            if (popup == null) {
                popup = SystemAction.createPopupMenu(new SystemAction[0]);
            }
            popup.add(newMenu);
        }
        this.createPopup(xpos, ypos, popup);
    }

    static void invokeAction(SystemAction sa, ActionEvent ev) {
        Exception t = null;
        try {
            Class<?> c = Class.forName("org.openide.actions.ActionManager");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = TreeView.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = TreeView.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                m.invoke(o, sa, ev);
                return;
            }
        }
        catch (ClassNotFoundException x) {
        }
        catch (ExceptionInInitializerError x) {
        }
        catch (LinkageError x) {
        }
        catch (SecurityException x) {
            t = x;
        }
        catch (NoSuchMethodException x) {
            t = x;
        }
        catch (IllegalAccessException x) {
            t = x;
        }
        catch (IllegalArgumentException x) {
            t = x;
        }
        catch (InvocationTargetException x) {
            t = x;
        }
        if (t != null) {
            ErrorManager.getDefault().notify(1, t);
        }
        sa.actionPerformed(ev);
    }

    Point getPositionForPopup() {
        int i = this.tree.getLeadSelectionRow();
        if (i < 0) {
            return null;
        }
        Rectangle rect = this.tree.getRowBounds(i);
        if (rect == null) {
            return null;
        }
        Point p = new Point(rect.x, rect.y);
        if (this.tree.getRootPane() != null) {
            p = SwingUtilities.convertPoint(this.tree, rect.x, rect.y, this.tree.getRootPane());
        }
        return p;
    }

    static final TreePath findSiblingTreePath(TreePath parentPath, int[] childIndices) {
        if (childIndices == null) {
            throw new IllegalArgumentException("Indexes of changed children are null.");
        }
        if (parentPath == null) {
            throw new IllegalArgumentException("The tree path to parent is null.");
        }
        if (childIndices.length == 0) {
            return null;
        }
        TreeNode parent = (TreeNode)parentPath.getLastPathComponent();
        Object[] parentPaths = parentPath.getPath();
        TreePath newSelection = null;
        if (parent.getChildCount() > 0) {
            int childPathLength = parentPaths.length + 1;
            Object[] childPath = new Object[childPathLength];
            System.arraycopy(parentPaths, 0, childPath, 0, parentPaths.length);
            int selectedChild = childIndices[0] - 1;
            if (selectedChild < 0) {
                selectedChild = 0;
            }
            childPath[childPathLength - 1] = parent.getChildAt(selectedChild);
            newSelection = new TreePath(childPath);
        } else {
            newSelection = new TreePath(parentPaths);
        }
        return newSelection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ExplorerTree
    extends JTree
    implements Autoscroll {
        AutoscrollSupport support;
        private String maxPrefix;
        private JTextField searchTextField = new JTextField(this){
            private final /* synthetic */ ExplorerTree this$1;
            {
                this.this$1 = this$1;
            }

            public boolean isManagingFocus() {
                return true;
            }

            public void processKeyEvent(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    ExplorerTree.access$600(this.this$1);
                } else {
                    super.processKeyEvent(ke);
                }
            }
        };
        private final int heightOfTextField;
        private int originalScrollMode;
        static /* synthetic */ Class class$java$awt$event$KeyListener;

        ExplorerTree(TreeModel model) {
            super(model);
            this.heightOfTextField = this.searchTextField.getPreferredSize().height;
            this.toggleClickCount = 0;
            if (System.getProperty("java.version").startsWith("1.4")) {
                this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("COPY"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("PASTE"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("CUT"), "none");
            } else {
                this.getActionMap().put("cancel", new OurTreeCancelEditingAction());
            }
            this.setupSearch();
        }

        private void setupSearch() {
            KeyListener[] keyListeners = (KeyListener[])this.getListeners(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = ExplorerTree.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener);
            int i = 0;
            while (i < keyListeners.length) {
                this.removeKeyListener(keyListeners[i]);
                ++i;
            }
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ExplorerTree this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    int modifiers = e.getModifiers();
                    int keyCode = e.getKeyCode();
                    if (modifiers > 0 || e.isActionKey()) {
                        return;
                    }
                    char c = e.getKeyChar();
                    if (!Character.isISOControl(c)) {
                        ExplorerTree.access$700(this.this$1).setText(String.valueOf(c));
                        ExplorerTree.access$800(this.this$1);
                    }
                }
            });
            SearchFieldListener searchFieldListener = new SearchFieldListener();
            this.searchTextField.addKeyListener(searchFieldListener);
            this.searchTextField.addFocusListener(searchFieldListener);
            this.searchTextField.getDocument().addDocumentListener(searchFieldListener);
        }

        private void doSearch(String str, ArrayList results) {
            int[] rows = this.getSelectionRows();
            int row = rows == null || rows.length == 0 ? 0 : rows[0];
            int rowCount = this.getRowCount();
            int i = row;
            while (i < this.getRowCount()) {
                this.addPathIfMatches(str, i, results);
                ++i;
            }
            int i2 = 0;
            while (i2 < row && i2 < rowCount) {
                this.addPathIfMatches(str, i2, results);
                ++i2;
            }
        }

        private void addPathIfMatches(String str, int row, ArrayList results) {
            TreePath path = this.getPathForRow(row);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            String nodeName = node.toString();
            if (nodeName.toUpperCase().startsWith(str)) {
                this.maxPrefix = this.maxPrefix == null ? nodeName : this.findMaxPrefix(this.maxPrefix, nodeName);
                results.add(path);
            }
        }

        private String findMaxPrefix(String str1, String str2) {
            String res = null;
            int i = 0;
            while (str1.regionMatches(true, 0, str2, 0, i)) {
                res = str1.substring(0, i);
                ++i;
            }
            return res;
        }

        private void displaySearchField() {
            if (!this.searchTextField.isDisplayable()) {
                JViewport viewport = TreeView.this.getViewport();
                this.originalScrollMode = viewport.getScrollMode();
                viewport.setScrollMode(0);
                Rectangle visibleTreeRect = this.getVisibleRect();
                this.add(this.searchTextField);
                this.repaint();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ExplorerTree this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ExplorerTree.access$700(this.this$1).requestFocus();
                    }
                });
            }
        }

        public void paint(Graphics g) {
            Rectangle visibleRect = this.getVisibleRect();
            if (this.searchTextField.isDisplayable()) {
                this.searchTextField.setBounds(Math.max(3, visibleRect.x + visibleRect.width - 163), visibleRect.y + 3, Math.min(this.getPreferredSize().width - 6, 160), this.heightOfTextField);
            }
            super.paint(g);
        }

        private void removeSearchField() {
            if (this.searchTextField.isDisplayable()) {
                this.remove(this.searchTextField);
                TreeView.this.getViewport().setScrollMode(this.originalScrollMode);
                this.repaint();
            }
        }

        public void autoscroll(Point cursorLoc) {
            this.getSupport().autoscroll(cursorLoc);
        }

        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        public String getToolTipText(MouseEvent event) {
            if (event != null) {
                Point p = event.getPoint();
                int selRow = this.getRowForLocation(p.x, p.y);
                if (selRow != -1) {
                    TreePath path = this.getPathForRow(selRow);
                    VisualizerNode v = (VisualizerNode)path.getLastPathComponent();
                    String tooltip = v.getShortDescription();
                    String displayName = v.getDisplayName();
                    if (tooltip != null && !tooltip.equals(displayName)) {
                        return tooltip;
                    }
                }
            }
            return null;
        }

        protected TreeModelListener createTreeModelListener() {
            return new ModelHandler();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerTree();
            }
            return this.accessibleContext;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ void access$800(ExplorerTree x0) {
            x0.displaySearchField();
        }

        private class OurTreeCancelEditingAction
        extends AbstractAction {
            OurTreeCancelEditingAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (((ExplorerTree)ExplorerTree.this).TreeView.this.tree != null) {
                    ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.cancelEditing();
                }
            }

            public boolean isEnabled() {
                return ((ExplorerTree)ExplorerTree.this).TreeView.this.tree != null && ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.isEnabled() && ExplorerTree.this.getUI().isEditing(((ExplorerTree)ExplorerTree.this).TreeView.this.tree);
            }
        }

        private class ModelHandler
        extends JTree.TreeModelHandler {
            ModelHandler() {
                super(ExplorerTree.this);
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreePath[] selectionPaths = ExplorerTree.this.getSelectionPaths();
                Enumeration<TreePath> expanded = ExplorerTree.this.getExpandedDescendants(e.getTreePath());
                super.treeStructureChanged(e);
                if (expanded != null) {
                    while (expanded.hasMoreElements()) {
                        ExplorerTree.this.expandPath(expanded.nextElement());
                    }
                }
                if (selectionPaths != null && selectionPaths.length > 0) {
                    boolean wasSelected = ExplorerTree.this.isPathSelected(selectionPaths[0]);
                    ExplorerTree.this.setSelectionPaths(selectionPaths);
                    if (!wasSelected) {
                        ExplorerTree.this.scrollPathToVisible(selectionPaths[0]);
                    }
                }
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                TreePath path;
                super.treeNodesRemoved(e);
                if (((ExplorerTree)ExplorerTree.this).TreeView.this.tree.getSelectionCount() == 0 && (path = TreeView.findSiblingTreePath(e.getTreePath(), e.getChildIndices())) != null && path.getPathCount() > 0) {
                    ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.setSelectionPath(path);
                }
            }
        }

        private class AccessibleExplorerTree
        extends JTree.AccessibleJTree {
            AccessibleExplorerTree() {
                super(ExplorerTree.this);
            }

            public String getAccessibleName() {
                return TreeView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return TreeView.this.getAccessibleContext().getAccessibleDescription();
            }
        }

        private class SearchFieldListener
        extends KeyAdapter
        implements DocumentListener,
        FocusListener {
            private ArrayList results = new ArrayList();
            private int currentSelectionIndex;

            SearchFieldListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void insertUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void removeUpdate(DocumentEvent e) {
                this.searchForNode();
            }

            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 27) {
                    ExplorerTree.this.removeSearchField();
                    ExplorerTree.this.requestFocus();
                } else if (keyCode == 38) {
                    --this.currentSelectionIndex;
                    this.displaySearchResult();
                    e.consume();
                } else if (keyCode == 40) {
                    ++this.currentSelectionIndex;
                    this.displaySearchResult();
                    e.consume();
                } else if (keyCode == 9) {
                    if (ExplorerTree.this.maxPrefix != null) {
                        ExplorerTree.this.searchTextField.setText(ExplorerTree.this.maxPrefix);
                    }
                    e.consume();
                } else if (keyCode == 10) {
                    ExplorerTree.this.removeSearchField();
                    ExplorerTree.this.expandPath(ExplorerTree.this.getSelectionPath());
                    ExplorerTree.this.requestFocus();
                    ExplorerTree.this.dispatchEvent(e);
                }
            }

            private void searchForNode() {
                this.currentSelectionIndex = 0;
                this.results.clear();
                ExplorerTree.this.maxPrefix = null;
                String text = ExplorerTree.this.searchTextField.getText().toUpperCase();
                if (text.length() > 0) {
                    ExplorerTree.this.doSearch(text, this.results);
                    this.displaySearchResult();
                }
            }

            private void displaySearchResult() {
                int sz = this.results.size();
                if (sz > 0) {
                    if (this.currentSelectionIndex < 0) {
                        this.currentSelectionIndex = sz - 1;
                    } else if (this.currentSelectionIndex >= sz) {
                        this.currentSelectionIndex = 0;
                    }
                    TreePath path = (TreePath)this.results.get(this.currentSelectionIndex);
                    ExplorerTree.this.setSelectionPath(path);
                    ExplorerTree.this.scrollPathToVisible(path);
                } else {
                    ExplorerTree.this.clearSelection();
                }
            }

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ExplorerTree.this.removeSearchField();
            }
        }
    }

    final class PopupSupport
    extends MouseAdapter
    implements ActionPerformer,
    Runnable,
    FocusListener,
    ActionListener {
        CallbackSystemAction csa;
        boolean firstFocus = true;
        static /* synthetic */ Class class$org$openide$actions$PopupAction;

        PopupSupport() {
        }

        public void performAction(SystemAction act) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Point p = TreeView.this.getPositionForPopup();
            if (p == null) {
                return;
            }
            TreeView.this.createPopup(p.x, p.y);
        }

        public void focusGained(FocusEvent ev) {
            if (this.csa == null) {
                this.csa = (CallbackSystemAction)SystemAction.get(class$org$openide$actions$PopupAction == null ? (class$org$openide$actions$PopupAction = PopupSupport.class$("org.openide.actions.PopupAction")) : class$org$openide$actions$PopupAction);
            }
            this.csa.setActionPerformer(this);
            if (this.firstFocus) {
                this.firstFocus = false;
                if (DragDropUtilities.dragAndDropEnabled) {
                    TreeView.this.setDragSource(true);
                }
                TreeView.this.tree.setCellEditor(new TreeViewCellEditor(TreeView.this.tree, new NodeRenderer.Tree()));
                TreeView.this.tree.setEditable(true);
            }
        }

        public void focusLost(FocusEvent ev) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupSupport) {
                this.csa.setActionPerformer(null);
            }
        }

        public void mouseClicked(MouseEvent e) {
            int selRow = TreeView.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow != -1 && SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick(e)) {
                TreePath selPath;
                Node node;
                SystemAction sa;
                if (TreeView.this.defaultActionEnabled && (sa = (node = Visualizer.findNode((selPath = TreeView.this.tree.getPathForLocation(e.getX(), e.getY())).getLastPathComponent())).getDefaultAction()) != null) {
                    TreeView.invokeAction(sa, new ActionEvent(node, 1001, ""));
                    e.consume();
                    return;
                }
                if (TreeView.this.tree.isExpanded(selRow)) {
                    TreeView.this.tree.collapseRow(selRow);
                } else {
                    TreeView.this.tree.expandRow(selRow);
                }
            }
        }

        public void actionPerformed(ActionEvent evt) {
            SystemAction sa;
            Node[] nodes = TreeView.this.manager.getSelectedNodes();
            if (nodes.length == 1 && (sa = nodes[0].getDefaultAction()) != null) {
                TreeView.invokeAction(sa, new ActionEvent(nodes[0], 1001, ""));
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int selRow = TreeView.this.tree.getRowForLocation(e.getX(), e.getY());
            if (!TreeView.this.tree.isRowSelected(selRow)) {
                TreeView.this.tree.setSelectionRow(selRow);
            }
            if (selRow != -1) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), TreeView.this);
                TreeView.this.createPopup((int)p.getX(), (int)p.getY());
            }
        }
    }

    class TreePropertyListener
    implements VetoableChangeListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeWillExpandListener,
    TreeSelectionListener,
    Runnable {
        private RequestProcessor.Task scheduled;
        private TreePath[] readAccessPaths;

        TreePropertyListener() {
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getPropertyName().equals("selectedNodes")) {
                if (TreeView.this.isSelectionModeBroken((Node[])evt.getNewValue())) {
                    throw new PropertyVetoException("", evt);
                }
                if (!TreeView.this.selectionAccept((Node[])evt.getNewValue())) {
                    throw new PropertyVetoException("", evt);
                }
            }
        }

        public final void propertyChange(PropertyChangeEvent evt) {
            if (TreeView.this.manager == null) {
                return;
            }
            if (evt.getPropertyName().equals("rootContext")) {
                TreeView.this.synchronizeRootContext();
            }
            if (evt.getPropertyName().equals("exploredContext")) {
                TreeView.this.synchronizeExploredContext();
            }
            if (evt.getPropertyName().equals("selectedNodes")) {
                TreeView.this.synchronizeSelectedNodes();
            }
        }

        public synchronized void treeExpanded(TreeExpansionEvent ev) {
            TreePath path = ev.getPath();
            RequestProcessor.Task t = this.scheduled;
            if (t != null) {
                t.cancel();
            }
            this.scheduled = RequestProcessor.getDefault().post(new Runnable(this, path){
                private final /* synthetic */ TreePath val$path;
                private final /* synthetic */ TreePropertyListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$path = val$path;
                }

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (!TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isVisible(this.val$path)) {
                        return;
                    }
                    if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel == null) {
                        return;
                    }
                    TreeNode myNode = (TreeNode)this.val$path.getLastPathComponent();
                    if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(myNode)[0] != TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                        return;
                    }
                    int lastChildIndex = myNode.getChildCount() - 1;
                    if (lastChildIndex >= 0) {
                        TreeNode lastChild = myNode.getChildAt(lastChildIndex);
                        Rectangle base = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getVisibleRect();
                        Rectangle b1 = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getPathBounds(this.val$path);
                        Rectangle b2 = TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.getPathBounds(new TreePath(TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(lastChild)));
                        if (base != null && b1 != null && b2 != null) {
                            TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.scrollRectToVisible(new Rectangle(base.x, b1.y, 1, b2.y - b1.y + b2.height));
                        }
                    }
                }
            }, 250);
        }

        public synchronized void treeCollapsed(TreeExpansionEvent ev) {
            TreePath path = ev.getPath();
            TreeView.this.showNormalCursor();
            RequestProcessor.Task t = this.scheduled;
            if (t != null) {
                t.cancel();
            }
            this.scheduled = RequestProcessor.getDefault().post(new Runnable(this, path){
                private final /* synthetic */ TreePath val$path;
                private final /* synthetic */ TreePropertyListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$path = val$path;
                }

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isExpanded(this.val$path)) {
                        return;
                    }
                    if (!TreePropertyListener.access$300((TreePropertyListener)this.this$1).tree.isVisible(this.val$path)) {
                        return;
                    }
                    if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel == null) {
                        return;
                    }
                    TreeNode myNode = (TreeNode)this.val$path.getLastPathComponent();
                    if (TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getPathToRoot(myNode)[0] != TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                        return;
                    }
                    TreePropertyListener.access$300((TreePropertyListener)this.this$1).treeModel.nodeStructureChanged(myNode);
                }
            }, TIME_TO_COLLAPSE);
        }

        public void valueChanged(TreeSelectionEvent ev) {
            TreePath[] paths = TreeView.this.tree.getSelectionPaths();
            if (paths == null) {
                TreeView.this.callSelectionChanged(new Node[0]);
            } else {
                this.readAccessPaths = paths;
                Children.MUTEX.postReadRequest(this);
            }
        }

        public void run() {
            if (this.readAccessPaths == null) {
                return;
            }
            TreePath[] paths = this.readAccessPaths;
            this.readAccessPaths = null;
            ArrayList<Node> ll = new ArrayList<Node>(paths.length);
            int i = 0;
            while (i < paths.length) {
                Node n = Visualizer.findNode(paths[i].getLastPathComponent());
                if (n == TreeView.this.manager.getRootContext() || n.getParentNode() != null) {
                    ll.add(n);
                }
                ++i;
            }
            TreeView.this.callSelectionChanged(ll.toArray(new Node[ll.size()]));
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            TreeView.this.prepareWaitCursor(DragDropUtilities.secureFindNode(path.getLastPathComponent()));
        }

        static /* synthetic */ TreeView access$300(TreePropertyListener x0) {
            return x0.TreeView.this;
        }
    }
}

